/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.oidc.entities;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.URI;
import java.util.List;
import java.util.Objects;

public class OidcAuthResponse {
    private final URI uri;
    private final List<String> cookies;
    private final AuthTokenResponse body;

    public OidcAuthResponse(URI uri, List<String> cookies) {
        this.uri = uri;
        this.cookies = cookies;
        this.body = null;
    }

    public OidcAuthResponse(URI uri, List<String> cookies, String authToken, Long exp) {
        this.uri = uri;
        this.cookies = cookies;
        this.body = new AuthTokenResponse(authToken, exp);
    }

    public URI uri() {
        return this.uri;
    }

    public List<String> cookies() {
        return this.cookies;
    }

    public AuthTokenResponse body() {
        return this.body;
    }

    public static class AuthTokenResponse {
        @JsonProperty(value="auth_token")
        private final String authToken;
        @JsonProperty(value="exp")
        private final Long exp;

        public AuthTokenResponse(String authToken, Long expirySec) {
            this.authToken = authToken;
            this.exp = expirySec;
        }

        public String authToken() {
            return this.authToken;
        }

        public Long exp() {
            return this.exp;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other instanceof AuthTokenResponse) {
                AuthTokenResponse that = (AuthTokenResponse)other;
                return Objects.equals(this.authToken, that.authToken) && Objects.equals(this.exp, that.exp);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.authToken, this.exp);
        }

        public String toString() {
            return "AuthTokenResponse{authToken='sensitive', exp=" + this.exp + "}";
        }
    }
}

