/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.oidc.resources;

import io.confluent.oidc.entities.OidcAuthResponse;
import io.confluent.oidc.services.OidcTokenService;
import jakarta.ws.rs.core.Cookie;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import org.eclipse.jetty.http.HttpHeader;
import org.testng.util.Strings;

public class OidcTokenResource {
    private final OidcTokenService oidcTokenService;

    public OidcTokenResource(OidcTokenService oidcTokenService) {
        this.oidcTokenService = oidcTokenService;
    }

    public Response getIdpAuthUri(UriInfo uriInfo, URI caller) {
        OidcAuthResponse authResponse = this.oidcTokenService.getIdpAuthUri(uriInfo, caller);
        return this.buildResponse(authResponse, Response.Status.FOUND);
    }

    public Response handleCallback(Cookie encryptedStateCk, String state, String code, String error, String errorDescription) {
        OidcAuthResponse authResponse = this.oidcTokenService.handleCallback(encryptedStateCk, state, code, error, errorDescription);
        return this.buildResponse(authResponse, Response.Status.FOUND);
    }

    public Response checkSessionAndRefreshToken(SecurityContext securityContext) {
        OidcAuthResponse authResponse = this.oidcTokenService.refreshConfluentTokenIfApplicable(securityContext);
        return this.buildResponse(authResponse, Response.Status.OK);
    }

    public Response clearToken(SecurityContext securityContext) {
        OidcAuthResponse authResponse = this.oidcTokenService.clearToken(securityContext);
        return this.buildResponse(authResponse, Response.Status.OK);
    }

    private Response buildResponse(OidcAuthResponse authResponse, Response.Status status) {
        List<String> cookies;
        Response.ResponseBuilder builder = Response.status((Response.Status)status);
        if (Objects.nonNull(authResponse.uri())) {
            builder = Response.Status.FOUND.equals((Object)status) ? builder.location(authResponse.uri()) : builder.entity((Object)authResponse.uri());
        }
        if (Objects.nonNull(authResponse.body())) {
            builder = builder.entity((Object)authResponse.body());
        }
        if (Objects.nonNull(cookies = authResponse.cookies())) {
            for (String cookie : cookies) {
                if (Strings.isNullOrEmpty((String)cookie)) continue;
                builder = builder.header(HttpHeader.SET_COOKIE.toString(), (Object)cookie);
            }
        }
        return builder.build();
    }
}

