/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.oidc.utilities;

import io.confluent.kafka.security.oauthbearer.ClientAssertion;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.security.oauthbearer.internals.secured.SerializedJwt;
import org.apache.kafka.common.security.oauthbearer.internals.secured.ValidateException;
import org.apache.kafka.common.security.oauthbearer.internals.unsecured.OAuthBearerIllegalTokenException;
import org.apache.kafka.common.security.oauthbearer.internals.unsecured.OAuthBearerUnsecuredJws;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingClientAssertion
implements ClientAssertion {
    private static final Logger log = LoggerFactory.getLogger(CachingClientAssertion.class);
    private static final double TOKEN_REFRESH_RATE = 0.8;
    private final ClientAssertion delegate;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private String clientAssertionJwt;

    public CachingClientAssertion(ClientAssertion clientAssertion) {
        this.delegate = clientAssertion;
        this.clientAssertionJwt = this.delegate.getJwt();
        this.scheduleAssertionRefresh();
    }

    public String getJwt() {
        return this.clientAssertionJwt;
    }

    private void scheduleAssertionRefresh() {
        long delayForTokenRefresh = this.getNextAssertionRefresh();
        if (delayForTokenRefresh < 0L) {
            log.warn("Assertion already expired, refreshing token immediately");
            delayForTokenRefresh = 0L;
        }
        log.debug("scheduling Assertion refresh after delay - {}", (Object)delayForTokenRefresh);
        this.scheduler.schedule(() -> {
            try {
                this.clientAssertionJwt = this.delegate.getJwt();
                this.scheduleAssertionRefresh();
            }
            catch (RuntimeException e) {
                log.warn("Assertion refresh failed", (Throwable)e);
            }
        }, delayForTokenRefresh, TimeUnit.MILLISECONDS);
    }

    private long getNextAssertionRefresh() {
        long expirationTime = this.getAssertionExpirySec();
        long currentTime = System.currentTimeMillis();
        long activePeriod = expirationTime * 1000L - currentTime;
        return (long)((double)activePeriod * 0.8);
    }

    long getAssertionExpirySec() {
        Map payload;
        SerializedJwt serializedJwt = new SerializedJwt(this.clientAssertionJwt);
        try {
            payload = OAuthBearerUnsecuredJws.toMap((String)serializedJwt.getPayload());
        }
        catch (OAuthBearerIllegalTokenException e) {
            throw new ValidateException(String.format("Invalid Token: %s", e.getMessage()), (Throwable)e);
        }
        return ((Number)payload.get("exp")).longValue();
    }

    Boolean isAssertionExpired() {
        long expirationTime = this.getAssertionExpirySec();
        long currentTime = System.currentTimeMillis();
        return currentTime > expirationTime * 1000L;
    }

    public void close() {
        this.scheduler.shutdown();
    }
}

