/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.oidc.utilities;

import com.google.common.base.Strings;
import io.confluent.kafka.security.oauthbearer.ClientAssertion;
import io.confluent.kafka.security.oauthbearer.FileBasedClientAssertion;
import io.confluent.kafka.security.oauthbearer.PrivateKeyClientAssertion;
import io.confluent.oidc.config.OidcConfig;
import io.confluent.oidc.exceptions.InvalidCodeException;
import io.confluent.oidc.utilities.CachingClientAssertion;
import jakarta.ws.rs.core.Form;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.apache.kafka.common.config.ConfigException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestBodyBuilder {
    private static final Logger log = LoggerFactory.getLogger(RequestBodyBuilder.class);
    private ClientAssertion clientAssertion;
    private final Boolean configureClientAssertion;
    private final String clientIdIdp;
    private String clientSecretIdp;
    private final String scopeForGroupsClaim;
    private final boolean idpRefreshTokenEnabled;
    private final boolean includeClientIdInBody;

    public RequestBodyBuilder(OidcConfig oidcConfig) {
        this.clientIdIdp = oidcConfig.getString("confluent.oidc.idp.client.id");
        this.scopeForGroupsClaim = oidcConfig.getString("confluent.oidc.idp.groups.claim.scope");
        this.idpRefreshTokenEnabled = oidcConfig.getBoolean("confluent.oidc.idp.refresh.token.enabled");
        String clientAssertionIssuer = oidcConfig.getString("confluent.oidc.idp.client.assertion.claim.iss");
        String clientAssertionLocation = oidcConfig.getString("confluent.oidc.idp.client.assertion.file");
        if (clientAssertionIssuer != null || clientAssertionLocation != null) {
            if (clientAssertionLocation != null) {
                log.info("Configuring File based client assertion using file: {}", (Object)clientAssertionLocation);
                this.clientAssertion = new FileBasedClientAssertion(clientAssertionLocation);
            } else {
                log.info("Configuring local client assertion creation");
                String passPhrase = oidcConfig.getPassword("confluent.oidc.idp.client.assertion.private.key.passphrase") == null ? null : oidcConfig.getPassword("confluent.oidc.idp.client.assertion.private.key.passphrase").value();
                this.clientAssertion = new PrivateKeyClientAssertion(oidcConfig.getString("confluent.oidc.idp.client.assertion.claim.iss"), oidcConfig.getString("confluent.oidc.idp.client.assertion.claim.aud"), oidcConfig.getString("confluent.oidc.idp.client.assertion.claim.sub"), oidcConfig.getInt("confluent.oidc.idp.client.assertion.claim.exp.minutes"), oidcConfig.getBoolean("confluent.oidc.idp.client.assertion.claim.nbf.include"), oidcConfig.getBoolean("confluent.oidc.idp.client.assertion.claim.jti.include"), oidcConfig.getString("confluent.oidc.idp.client.assertion.private.key.file"), passPhrase, oidcConfig.getString("confluent.oidc.idp.client.assertion.template.file"));
            }
            this.includeClientIdInBody = oidcConfig.getBoolean("confluent.oidc.idp.client.assertion.include.client.id");
            if (oidcConfig.getBoolean("confluent.oidc.idp.client.assertion.include.client.id").booleanValue()) {
                log.info("Client Id will be included in the request to IDP");
            }
            this.configureClientAssertion = true;
            if (!oidcConfig.getBoolean("confluent.oidc.idp.client.assertion.claim.jti.include").booleanValue()) {
                log.info("JTI claim disabled for client assertion, token will be cached for 80% of its lifetime");
                this.clientAssertion = new CachingClientAssertion(this.clientAssertion);
            }
        } else {
            log.info("Configuring client secret method for authentication with IDP");
            this.includeClientIdInBody = false;
            if (oidcConfig.getPassword("confluent.oidc.idp.client.secret") == null) {
                throw new ConfigException("Client secret is required for client secret based authentication");
            }
            this.clientSecretIdp = oidcConfig.getPassword("confluent.oidc.idp.client.secret").value();
            this.configureClientAssertion = false;
        }
    }

    private Form addClientCredentials() {
        if (this.configureClientAssertion.booleanValue()) {
            return this.addClientAssertionParams();
        }
        return new Form().param("client_id", this.clientIdIdp).param("client_secret", this.clientSecretIdp);
    }

    private Form addClientAssertionParams() {
        if (!this.configureClientAssertion.booleanValue()) {
            return new Form();
        }
        log.debug("Adding client assertion to request body");
        Form clientAssertionParams = new Form().param("client_assertion", this.clientAssertion.getJwt()).param("client_assertion_type", "urn:ietf:params:oauth:client-assertion-type:jwt-bearer");
        if (this.includeClientIdInBody) {
            clientAssertionParams.param("client_id", this.clientIdIdp);
        }
        return clientAssertionParams;
    }

    public Form getCheckDeviceAuthRequestBody(String deviceCode) {
        Form body = this.addClientCredentials();
        body.param("grant_type", "urn:ietf:params:oauth:grant-type:device_code");
        body.param("device_code", deviceCode);
        return body;
    }

    public Form getCreateDeviceAuthRequestBody() {
        Form body = this.addClientCredentials();
        body.param("scope", this.getScopeParam(this.idpRefreshTokenEnabled));
        return body;
    }

    public Form getTokenRequestBody(String code, String callbackUri) {
        if (Strings.isNullOrEmpty((String)code)) {
            throw new InvalidCodeException("authorization code is null or empty");
        }
        Form body = this.addClientAssertionParams();
        body.param("grant_type", "authorization_code");
        body.param("code", code);
        body.param("redirect_uri", callbackUri);
        return body;
    }

    public Form getTokenRequestUsingRefreshTokenBody(String refreshToken) {
        Form body = this.addClientAssertionParams();
        body.param("grant_type", "refresh_token");
        body.param("refresh_token", refreshToken);
        body.param("scope", this.getScopeParam(false));
        return body;
    }

    public String getEncodedCredentials() {
        String credentials = this.clientIdIdp + ":" + this.clientSecretIdp;
        return Base64.getEncoder().encodeToString(credentials.getBytes(StandardCharsets.UTF_8));
    }

    public Boolean isClientAssertionConfigured() {
        return this.configureClientAssertion;
    }

    public String getScopeParam(boolean requestRefreshToken) {
        StringBuilder scope = new StringBuilder("openid");
        if (requestRefreshToken) {
            scope.append(" offline_access");
        }
        if (!Strings.isNullOrEmpty((String)this.scopeForGroupsClaim)) {
            scope.append(" ").append(this.scopeForGroupsClaim);
        }
        log.debug("Using scope: {}", (Object)scope);
        return scope.toString();
    }
}

