/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import io.confluent.connect.json.JsonSchemaConverterConfig;
import io.confluent.connect.json.JsonSchemaData;
import io.confluent.connect.json.JsonSchemaDataConfig;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClientFactory;
import io.confluent.kafka.schemaregistry.json.JsonSchema;
import io.confluent.kafka.schemaregistry.json.JsonSchemaProvider;
import io.confluent.kafka.serializers.AbstractKafkaSchemaSerDe;
import io.confluent.kafka.serializers.json.AbstractKafkaJsonSchemaDeserializer;
import io.confluent.kafka.serializers.json.AbstractKafkaJsonSchemaSerializer;
import io.confluent.kafka.serializers.json.JsonSchemaAndValue;
import io.confluent.kafka.serializers.json.KafkaJsonSchemaDeserializerConfig;
import io.confluent.kafka.serializers.json.KafkaJsonSchemaSerializerConfig;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.NetworkException;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.errors.DataException;
import org.apache.kafka.connect.errors.RetriableException;
import org.apache.kafka.connect.storage.Converter;

public class JsonSchemaConverter
extends AbstractKafkaSchemaSerDe
implements Converter {
    private SchemaRegistryClient schemaRegistry;
    private Serializer serializer;
    private Deserializer deserializer;
    private boolean isKey;
    private JsonSchemaData jsonSchemaData;

    public JsonSchemaConverter() {
    }

    @VisibleForTesting
    public JsonSchemaConverter(SchemaRegistryClient client) {
        this.schemaRegistry = client;
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.isKey = isKey;
        JsonSchemaConverterConfig jsonSchemaConverterConfig = new JsonSchemaConverterConfig(configs);
        if (this.schemaRegistry == null) {
            this.schemaRegistry = SchemaRegistryClientFactory.newClient((List)jsonSchemaConverterConfig.getSchemaRegistryUrls(), (int)jsonSchemaConverterConfig.getMaxSchemasPerSubject(), Collections.singletonList(new JsonSchemaProvider()), configs, (Map)jsonSchemaConverterConfig.requestHeaders());
        }
        this.serializer = new Serializer(configs, this.schemaRegistry);
        this.deserializer = new Deserializer(configs, this.schemaRegistry);
        this.jsonSchemaData = new JsonSchemaData(new JsonSchemaDataConfig(configs));
    }

    public byte[] fromConnectData(String topic, Schema schema, Object value) {
        return this.fromConnectData(topic, null, schema, value);
    }

    public byte[] fromConnectData(String topic, Headers headers, Schema schema, Object value) {
        if (schema == null && value == null) {
            return null;
        }
        JsonSchema jsonSchema = this.jsonSchemaData.fromConnectSchema(schema);
        JsonNode jsonValue = this.jsonSchemaData.fromConnectData(schema, value);
        try {
            return this.serializer.serialize(topic, headers, this.isKey, jsonValue, jsonSchema);
        }
        catch (TimeoutException e) {
            throw new RetriableException(String.format("Converting Kafka Connect data to byte[] failed due to serialization error of topic %s: ", topic), (Throwable)e);
        }
        catch (SerializationException e) {
            if (e.getCause() instanceof IOException) {
                throw new NetworkException(String.format("I/O error while serializing Json data for topic %s: %s", topic, e.getCause().getMessage()), (Throwable)e);
            }
            throw new DataException(String.format("Converting Kafka Connect data to byte[] failed due to serialization error of topic %s: ", topic), (Throwable)e);
        }
        catch (InvalidConfigurationException e) {
            throw new ConfigException(String.format("Failed to access JSON Schema data from topic %s : %s", topic, e.getMessage()));
        }
    }

    public SchemaAndValue toConnectData(String topic, byte[] value) {
        return this.toConnectData(topic, null, value);
    }

    public SchemaAndValue toConnectData(String topic, Headers headers, byte[] value) {
        try {
            JsonSchemaAndValue deserialized = this.deserializer.deserialize(topic, this.isKey, headers, value);
            if (deserialized == null || deserialized.getValue() == null) {
                return SchemaAndValue.NULL;
            }
            JsonSchema jsonSchema = deserialized.getSchema();
            Schema schema = this.jsonSchemaData.toConnectSchema(jsonSchema);
            return new SchemaAndValue(schema, this.jsonSchemaData.toConnectData(schema, (JsonNode)deserialized.getValue()));
        }
        catch (TimeoutException e) {
            throw new RetriableException(String.format("Converting byte[] to Kafka Connect data failed due to serialization error of topic %s: ", topic), (Throwable)e);
        }
        catch (SerializationException e) {
            if (e.getCause() instanceof IOException) {
                throw new NetworkException(String.format("I/O error while deserializing data for topic %s: %s", topic, e.getCause().getMessage()), (Throwable)e);
            }
            throw new DataException(String.format("Converting byte[] to Kafka Connect data failed due to serialization error of topic %s: ", topic), (Throwable)e);
        }
        catch (InvalidConfigurationException e) {
            throw new ConfigException(String.format("Failed to access JSON Schema data from topic %s : %s", topic, e.getMessage()));
        }
    }

    static class Serializer
    extends AbstractKafkaJsonSchemaSerializer {
        public Serializer(SchemaRegistryClient client, boolean autoRegisterSchema) {
            this.schemaRegistry = client;
            this.autoRegisterSchema = autoRegisterSchema;
        }

        public Serializer(Map<String, ?> configs, SchemaRegistryClient client) {
            this(client, false);
            this.configure(new KafkaJsonSchemaSerializerConfig(configs));
        }

        public byte[] serialize(String topic, Headers headers, boolean isKey, Object value, JsonSchema schema) {
            if (value == null) {
                return null;
            }
            return this.serializeImpl(this.getSubjectName(topic, isKey, value, (ParsedSchema)schema), topic, headers, value, schema);
        }
    }

    static class Deserializer
    extends AbstractKafkaJsonSchemaDeserializer {
        public Deserializer(SchemaRegistryClient client) {
            this.schemaRegistry = client;
        }

        public Deserializer(Map<String, ?> configs, SchemaRegistryClient client) {
            this(client);
            this.configure(new KafkaJsonSchemaDeserializerConfig(configs), null);
        }

        public JsonSchemaAndValue deserialize(String topic, boolean isKey, Headers headers, byte[] payload) {
            return this.deserializeWithSchemaAndVersion(topic, isKey, headers, payload);
        }
    }
}

