/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.tools.oomeventgeneration;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.exporter.otlp.logs.OtlpGrpcLogRecordExporter;
import io.opentelemetry.instrumentation.log4j.appender.v2_17.OpenTelemetryAppender;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.logs.LogRecordProcessor;
import io.opentelemetry.sdk.logs.SdkLoggerProvider;
import io.opentelemetry.sdk.logs.export.LogRecordExporter;
import io.opentelemetry.sdk.logs.export.SimpleLogRecordProcessor;
import io.opentelemetry.sdk.resources.Resource;
import org.apache.kafka.common.utils.Exit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OomOtelEventGeneration {
    private static final Logger LOGGER = LogManager.getLogger(OomOtelEventGeneration.class);
    private static final String SERVICE_NAME_ATTRIBUTE_KEY = "service.name";
    private static final String SERVICE_NAME = "kafka-oom-notifier";

    public static void main(String[] args) {
        OpenTelemetry openTelemetry = OomOtelEventGeneration.initializeOpenTelemetry();
        OpenTelemetryAppender.install((OpenTelemetry)openTelemetry);
        LOGGER.info("java.lang.OutOfMemoryError occurred on JVM which is running Kafka");
        Exit.exit((int)0);
    }

    private static OpenTelemetry initializeOpenTelemetry() {
        OtlpGrpcLogRecordExporter logRecordExporter = OtlpGrpcLogRecordExporter.builder().setEndpoint(System.getenv("OTEL_EXPORTER_OTLP_ENDPOINT")).build();
        LogRecordProcessor logRecordProcessor = SimpleLogRecordProcessor.create((LogRecordExporter)logRecordExporter);
        SdkLoggerProvider sdkLoggerProvider = SdkLoggerProvider.builder().setResource(Resource.getDefault().toBuilder().put(SERVICE_NAME_ATTRIBUTE_KEY, SERVICE_NAME).build()).addLogRecordProcessor(logRecordProcessor).build();
        OpenTelemetrySdk sdk = OpenTelemetrySdk.builder().setLoggerProvider(sdkLoggerProvider).build();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> ((OpenTelemetrySdk)sdk).close()));
        return sdk;
    }
}

