/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.tools.recovery;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.confluent.kafka.tools.recovery.MetadataLogIterator;
import io.confluent.kafka.tools.recovery.MetadataRecoveryPartition;
import io.confluent.kafka.tools.recovery.MetadataRecoveryUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kafka.raft.KafkaMetadataLog;
import kafka.raft.MetadataLogConfig;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentType;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.metadata.AccessControlEntryRecord;
import org.apache.kafka.common.metadata.MetadataJsonConverters;
import org.apache.kafka.common.metadata.MetadataRecordType;
import org.apache.kafka.common.metadata.RemoveAccessControlEntryRecord;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.raft.ReplicatedLog;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.util.FileLock;
import org.apache.kafka.server.util.KafkaScheduler;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.snapshot.RecordsSnapshotReader;

final class AclCommand {
    static final String COMMAND = "acl";
    private static final String RECONFIG_COMMAND_POSITIONAL = "acl-command";
    private static final String FIND_UNPREFIXED_ACLS_COMMAND = "find-unprefixed-acls";
    private static final String DELETE_FROM_FILE_COMMAND = "delete-from-file";
    private static final String DELETE_ALL_COMMAND = "delete-all";
    private static final String CREATE_BAD_COMMAND = "create-bad";
    private static final String METADATA_LOG_DIR_OPTION = "--metadata-log-dir";
    private static final String OUTPUT_FILE_OPTION = "--output-file";
    private static final String INPUT_FILE_OPTION = "--input-file";
    private static final String BOOTSTRAP_SERVER_OPTION = "--bootstrap-server";
    private static final String COMMAND_CONFIG_OPTION = "--command-config";

    AclCommand() {
    }

    static void addCommand(Subparsers subparsers) {
        Subparsers acl = subparsers.addParser(COMMAND).help("commands specific to acls").addSubparsers().dest(RECONFIG_COMMAND_POSITIONAL);
        Subparser findUnprefixed = acl.addParser(FIND_UNPREFIXED_ACLS_COMMAND).help("Find the unprefixed ACLs in a metadata log.");
        findUnprefixed.addArgument(new String[]{METADATA_LOG_DIR_OPTION}).dest(METADATA_LOG_DIR_OPTION).required(true).metavar(new String[]{"<path-metadata-dir>"}).help("directory containing the cluster metadata log").type((ArgumentType)Arguments.fileType().verifyCanRead());
        findUnprefixed.addArgument(new String[]{OUTPUT_FILE_OPTION}).dest(OUTPUT_FILE_OPTION).required(true).help("the file to write the unprefixed ACLs to.").type((ArgumentType)Arguments.fileType().verifyCanCreate());
        Subparser deleteFromFile = acl.addParser(DELETE_FROM_FILE_COMMAND).help("delete all the acls found in the given file.");
        deleteFromFile.addArgument(new String[]{BOOTSTRAP_SERVER_OPTION}).dest(BOOTSTRAP_SERVER_OPTION).required(true).metavar(new String[]{"<bootstrap-servers-list>"}).help("The bootstrap servers list");
        deleteFromFile.addArgument(new String[]{COMMAND_CONFIG_OPTION}).dest(COMMAND_CONFIG_OPTION).help("Property file containing configs to passed to Admin Client.").type((ArgumentType)Arguments.fileType().verifyCanRead());
        deleteFromFile.addArgument(new String[]{INPUT_FILE_OPTION}).dest(INPUT_FILE_OPTION).required(true).help("the file to read the ACLs to remove from.").type((ArgumentType)Arguments.fileType().verifyCanCreate());
        if (System.getenv().containsKey("CC_DOTFILES_ALPHA")) {
            Subparser createBad = acl.addParser(CREATE_BAD_COMMAND).help("Create a bad unprefixed ACL.");
            createBad.addArgument(new String[]{BOOTSTRAP_SERVER_OPTION}).dest(BOOTSTRAP_SERVER_OPTION).required(true).metavar(new String[]{"<bootstrap-servers-list>"}).help("The bootstrap servers list");
            createBad.addArgument(new String[]{COMMAND_CONFIG_OPTION}).dest(COMMAND_CONFIG_OPTION).help("Property file containing configs to passed to Admin Client.").type((ArgumentType)Arguments.fileType().verifyCanRead());
        }
        Subparser deleteAll = acl.addParser(DELETE_ALL_COMMAND).help("Delete all ACLs.");
        deleteAll.addArgument(new String[]{BOOTSTRAP_SERVER_OPTION}).dest(BOOTSTRAP_SERVER_OPTION).required(true).metavar(new String[]{"<bootstrap-servers-list>"}).help("The bootstrap servers list");
    }

    static int execute(Namespace namespace) {
        switch (namespace.getString(RECONFIG_COMMAND_POSITIONAL)) {
            case "find-unprefixed-acls": {
                Path clusterMetadataPartition = Paths.get(namespace.getString(METADATA_LOG_DIR_OPTION), new String[0]).resolve(MetadataRecoveryUtils.LOG_DIR);
                Map<Uuid, ApiMessageAndVersion> acls = AclCommand.loadUnprefixedAcls(clusterMetadataPartition);
                Path outputFile = Paths.get(namespace.getString(OUTPUT_FILE_OPTION), new String[0]);
                AclCommand.writeAclsToFile(acls, outputFile);
                return 0;
            }
            case "delete-from-file": {
                List<AclBindingFilter> filters = AclCommand.loadFiltersFromFile(Paths.get(namespace.getString(INPUT_FILE_OPTION), new String[0]));
                AclCommand.deleteAcls(namespace.getString(BOOTSTRAP_SERVER_OPTION), namespace.getString(COMMAND_CONFIG_OPTION), filters);
                return 0;
            }
            case "delete-all": {
                AclCommand.deleteAcls(namespace.getString(BOOTSTRAP_SERVER_OPTION), namespace.getString(COMMAND_CONFIG_OPTION), Arrays.asList(AclBindingFilter.ANY));
                return 0;
            }
            case "create-bad": {
                AclCommand.createBad(namespace.getString(BOOTSTRAP_SERVER_OPTION), namespace.getString(COMMAND_CONFIG_OPTION));
                return 0;
            }
        }
        throw new IllegalArgumentException(String.format("unknown command: %s", namespace));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Uuid, ApiMessageAndVersion> loadUnprefixedAcls(Path clusterMetadataPartition) {
        if (!Files.exists(clusterMetadataPartition, new LinkOption[0])) {
            throw new IllegalArgumentException(String.format("Directory %s doesn't exist", clusterMetadataPartition));
        }
        FileLock lock = null;
        File lockFile = new File(clusterMetadataPartition.toFile().getParentFile(), ".lock");
        try {
            lock = new FileLock(lockFile);
            if (!lock.tryLock()) {
                throw new IllegalStateException("Cluster may be active, unable to acquire lockfile " + String.valueOf(lockFile));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            Map<Uuid, ApiMessageAndVersion> map = AclCommand.loadUnprefixedAclsWithLock(clusterMetadataPartition);
            return map;
        }
        finally {
            try {
                lock.unlock();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static Map<Uuid, ApiMessageAndVersion> loadUnprefixedAclsWithLock(Path clusterMetadataPartition) {
        TreeMap<Uuid, ApiMessageAndVersion> acls = new TreeMap<Uuid, ApiMessageAndVersion>();
        KafkaScheduler scheduler = new KafkaScheduler(1, true, "target-dir-scheduler", false);
        try {
            TreeMap<Uuid, ApiMessageAndVersion> treeMap;
            block22: {
                KafkaMetadataLog log = KafkaMetadataLog.apply((TopicPartition)Topic.CLUSTER_METADATA_TOPIC_PARTITION, (Uuid)Uuid.METADATA_TOPIC_ID, (File)clusterMetadataPartition.toFile(), (Time)Time.SYSTEM, (Metrics)new Metrics(), (Scheduler)scheduler, (MetadataLogConfig)MetadataRecoveryPartition.metadataLogConfig(), ignore -> {}, ignore -> {});
                try {
                    log.latestSnapshot().ifPresent(rawReader -> {
                        try (RecordsSnapshotReader<ApiMessageAndVersion> recordReader = MetadataRecoveryUtils.openSnapshotReader(rawReader);){
                            recordReader.forEachRemaining(b -> b.forEach(r -> AclCommand.loadUnprefixedAclsRecord(r, acls)));
                        }
                    });
                    try (MetadataLogIterator iterator = MetadataLogIterator.open((ReplicatedLog)log, log.startOffset());){
                        iterator.forEachRemaining(b -> b.forEach(r -> AclCommand.loadUnprefixedAclsRecord(r, acls)));
                    }
                    treeMap = acls;
                    if (log == null) break block22;
                }
                catch (Throwable throwable) {
                    try {
                        if (log != null) {
                            try {
                                log.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Error processing metadata log", e);
                    }
                }
                log.close();
            }
            return treeMap;
        }
        finally {
            try {
                scheduler.shutdown();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    static void loadUnprefixedAclsRecord(ApiMessageAndVersion message, Map<Uuid, ApiMessageAndVersion> acls) {
        if (message.message().apiKey() == MetadataRecordType.ACCESS_CONTROL_ENTRY_RECORD.id()) {
            AccessControlEntryRecord aclRecord = (AccessControlEntryRecord)message.message();
            if (aclRecord.principal() != null && !aclRecord.principal().contains(":")) {
                acls.put(aclRecord.id(), message);
            }
        } else if (message.message().apiKey() == MetadataRecordType.REMOVE_ACCESS_CONTROL_ENTRY_RECORD.id()) {
            RemoveAccessControlEntryRecord removeAclRecord = (RemoveAccessControlEntryRecord)message.message();
            acls.remove(removeAclRecord.id());
        }
    }

    static void writeAclsToFile(Map<Uuid, ApiMessageAndVersion> acls, Path outputFile) {
        ObjectNode root = new ObjectNode(JsonNodeFactory.instance);
        ArrayNode aclArray = new ArrayNode(JsonNodeFactory.instance);
        root.set("acls", (JsonNode)aclArray);
        for (ApiMessageAndVersion message : acls.values()) {
            ObjectNode messageAndVersionNode = new ObjectNode(JsonNodeFactory.instance);
            messageAndVersionNode.set("version", (JsonNode)IntNode.valueOf((int)message.version()));
            messageAndVersionNode.set("message", MetadataJsonConverters.writeJson((ApiMessage)message.message(), (short)message.version()));
            aclArray.add((JsonNode)messageAndVersionNode);
        }
        System.out.printf("Writing %d ACLs to %s%n", acls.size(), outputFile.toAbsolutePath().getFileName());
        try {
            new ObjectMapper().writerWithDefaultPrettyPrinter().writeValue(outputFile.toFile(), (Object)root);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        System.out.printf("Done.%n", new Object[0]);
    }

    public static List<AclBindingFilter> loadFiltersFromFile(Path inputFile) {
        ObjectNode root;
        try {
            root = (ObjectNode)new ObjectMapper().readValue(inputFile.toFile(), ObjectNode.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return AclCommand.loadFiltersFromJson(root);
    }

    public static List<AclBindingFilter> loadFiltersFromJson(ObjectNode root) {
        ArrayList<AclBindingFilter> results = new ArrayList<AclBindingFilter>();
        JsonNode aclArray = root.get("acls");
        for (int i = 0; i < aclArray.size(); ++i) {
            JsonNode entry = aclArray.get(i);
            int version = entry.get("version").asInt();
            JsonNode message = entry.get("message");
            AccessControlEntryRecord record = (AccessControlEntryRecord)MetadataJsonConverters.readJson((JsonNode)message, (short)MetadataRecordType.ACCESS_CONTROL_ENTRY_RECORD.id(), (short)((short)version));
            List clusterLinkIds = Uuid.ZERO_UUID.equals((Object)record.clusterLinkId()) ? Collections.emptyList() : Collections.singletonList(record.clusterLinkId());
            results.add(new AclBindingFilter(new ResourcePatternFilter(ResourceType.fromCode((byte)record.resourceType()), record.resourceName(), PatternType.fromCode((byte)record.patternType())), new AccessControlEntryFilter(record.principal(), record.host(), AclOperation.fromCode((byte)record.operation()), AclPermissionType.fromCode((byte)record.permissionType()), clusterLinkIds)));
        }
        return results;
    }

    public static Admin createAdmin(String bootstrapServers, String commandConfigFile) {
        Properties props = new Properties();
        if (commandConfigFile != null) {
            try {
                props = Utils.loadProps((String)commandConfigFile);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        props.setProperty("bootstrap.servers", bootstrapServers);
        return Admin.create((Properties)props);
    }

    public static void deleteAcls(String bootstrapServers, String commandConfigFile, List<AclBindingFilter> filters) {
        try (Admin admin = AclCommand.createAdmin(bootstrapServers, commandConfigFile);){
            int numDeleted = ((Collection)admin.deleteAcls(filters).all().get(5L, TimeUnit.MINUTES)).size();
            System.out.printf("Deleted %d ACLs%n", numDeleted);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    public static void createBad(String bootstrapServers, String commandConfigFile) {
        try (Admin admin = AclCommand.createAdmin(bootstrapServers, commandConfigFile);){
            AclBinding aclBinding = new AclBinding(new ResourcePattern(ResourceType.TOPIC, "mytopic", PatternType.LITERAL), new AccessControlEntry("unprefixed", "*", AclOperation.ALL, AclPermissionType.ALLOW, Collections.emptyList()));
            admin.createAcls(Collections.singleton(aclBinding)).all().get();
            System.out.println("Created bad acl " + String.valueOf(aclBinding));
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}

