/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.tools.recovery;

import io.confluent.kafka.tools.recovery.CheckpointConvertCommand;
import io.confluent.kafka.tools.recovery.CheckpointRemoteCommand;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;

public final class CheckpointCommand {
    static final String COMMAND = "checkpoint";
    private static final String CHECKPOINT_COMMAND_POSITIONAL = "checkpoint-command";
    private static final String CONVERT_COMMAND = "convert";

    static void addCommand(Subparsers subparsers) {
        Subparsers checkpoint = subparsers.addParser(COMMAND).help("commands specific to checkpoints").addSubparsers().dest(CHECKPOINT_COMMAND_POSITIONAL);
        Subparser convert = checkpoint.addParser(CONVERT_COMMAND).help("convert metadata to and from different formats");
        Subparser remote = checkpoint.addParser("remote").help("Utility to interact with checkpoints in object store");
        CheckpointConvertCommand.addCommand(convert);
        CheckpointRemoteCommand.addCommand(remote);
    }

    static int execute(Namespace namespace) {
        switch (namespace.getString(CHECKPOINT_COMMAND_POSITIONAL)) {
            case "convert": {
                return CheckpointConvertCommand.execute(namespace);
            }
            case "remote": {
                return CheckpointRemoteCommand.execute(namespace);
            }
        }
        throw new IllegalArgumentException(String.format("unknown command: %s", namespace));
    }
}

