/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.tools.recovery;

import io.confluent.kafka.tools.recovery.AutoCloseableIterator;
import io.confluent.kafka.tools.recovery.MetadataLogIterator;
import io.confluent.kafka.tools.recovery.PartitionMetadata;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import kafka.raft.KafkaMetadataLog;
import kafka.raft.MetadataLogConfig;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.message.KRaftVersionRecord;
import org.apache.kafka.common.message.LeaderChangeMessage;
import org.apache.kafka.common.message.VotersRecord;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.MetadataRecordSerde;
import org.apache.kafka.raft.Batch;
import org.apache.kafka.raft.ControlRecord;
import org.apache.kafka.raft.ReplicatedLog;
import org.apache.kafka.raft.internals.BatchAccumulator;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.kafka.server.util.KafkaScheduler;
import org.apache.kafka.server.util.Scheduler;

final class MetadataRecoveryPartition
implements AutoCloseable,
Iterable<Batch<ApiMessageAndVersion>> {
    private static final int RECOVERY_PARTITION_EPOCH = 1;
    private final ReplicatedLog log;
    private final Scheduler scheduler;
    private final BatchAccumulator<ApiMessageAndVersion> batchAccumulator;

    private MetadataRecoveryPartition(ReplicatedLog log, Scheduler scheduler, BatchAccumulator<ApiMessageAndVersion> batchAccumulator) {
        this.log = log;
        this.scheduler = scheduler;
        this.batchAccumulator = batchAccumulator;
    }

    public void appendRecord(ApiMessageAndVersion record) {
        List<ApiMessageAndVersion> singletonRecord = Collections.singletonList(record);
        this.batchAccumulator.append(1, singletonRecord, false);
        this.finishAppend();
    }

    public void maybeAppendControlRecord(ControlRecord controlRecord) {
        if (controlRecord.message() instanceof LeaderChangeMessage) {
            this.batchAccumulator.appendLeaderChangeMessage((LeaderChangeMessage)controlRecord.message(), Time.SYSTEM.milliseconds());
            this.finishAppend();
        } else if (controlRecord.message() instanceof KRaftVersionRecord) {
            this.batchAccumulator.appendKRaftVersionRecord((KRaftVersionRecord)controlRecord.message(), Time.SYSTEM.milliseconds());
            this.finishAppend();
        } else if (controlRecord.message() instanceof VotersRecord) {
            this.batchAccumulator.appendVotersRecord((VotersRecord)controlRecord.message(), Time.SYSTEM.milliseconds());
            this.finishAppend();
        }
    }

    public void truncateTo(long offset) {
        this.log.truncateTo(offset);
    }

    @Override
    public AutoCloseableIterator<Batch<ApiMessageAndVersion>> iterator() {
        return MetadataLogIterator.open(this.log, 0L);
    }

    @Override
    public void close() {
        try {
            this.log.close();
            this.scheduler.shutdown();
            this.batchAccumulator.close();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void createNewMetadataPartitionFile(Path logDir) {
        if (Files.exists(logDir.resolve("partition.metadata"), new LinkOption[0])) {
            throw new UncheckedIOException(new IOException(String.format("partition.metadata file already exists in log directory: %s", logDir)));
        }
        PartitionMetadata.write(logDir);
    }

    public static MetadataRecoveryPartition open(Path logDir, Metrics metrics, Time time) throws IllegalArgumentException, UncheckedIOException {
        PartitionMetadata metadata = PartitionMetadata.read(logDir);
        if (!metadata.isMetadataRecovery()) {
            throw new IllegalArgumentException("Provided partition.metadata file with is_metadata_recovery: false");
        }
        KafkaScheduler scheduler = new KafkaScheduler(1, true, "metadata-recovery-log-scheduler", false);
        KafkaMetadataLog log = KafkaMetadataLog.apply((TopicPartition)Topic.CLUSTER_METADATA_TOPIC_PARTITION, (Uuid)Uuid.METADATA_TOPIC_ID, (File)logDir.toFile(), (Time)time, (Metrics)metrics, (Scheduler)scheduler, (MetadataLogConfig)MetadataRecoveryPartition.metadataLogConfig(), ignore -> {}, ignore -> {});
        BatchAccumulator batchAccumulator = new BatchAccumulator(1, log.endOffset().offset(), Integer.MAX_VALUE, 0x800000, Integer.MAX_VALUE, MemoryPool.NONE, time, (Compression)Compression.NONE, (RecordSerde)MetadataRecordSerde.INSTANCE);
        return new MetadataRecoveryPartition((ReplicatedLog)log, (Scheduler)scheduler, (BatchAccumulator<ApiMessageAndVersion>)batchAccumulator);
    }

    public static MetadataLogConfig metadataLogConfig() {
        return MetadataLogConfig.apply((int)0xA00000, (int)0xA00000, (long)Integer.MAX_VALUE, (long)Long.MAX_VALUE, (long)Long.MAX_VALUE, (int)0x800000, (int)0x800000, (long)Long.MAX_VALUE, (int)-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishAppend() {
        Optional<Object> appendFailed = Optional.empty();
        List batches = this.batchAccumulator.drain();
        for (BatchAccumulator.CompletedBatch batch : batches) {
            try {
                this.log.appendAsLeader((Records)batch.data, 1);
            }
            catch (Exception e) {
                if (!appendFailed.isPresent()) {
                    appendFailed = Optional.of(new RuntimeException("Append to recovery partition failed"));
                }
                ((RuntimeException)appendFailed.get()).addSuppressed(e);
            }
            finally {
                batch.release();
            }
        }
        if (appendFailed.isPresent()) {
            throw (RuntimeException)appendFailed.get();
        }
    }
}

