/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.tools.recovery;

import io.confluent.kafka.tools.recovery.ReconfigForceStandaloneCommand;
import io.confluent.kafka.tools.recovery.ReconfigLogLengthCommand;
import java.io.IOException;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;
import org.apache.kafka.tools.TerseException;

final class ReconfigCommand {
    static final String COMMAND = "reconfig";
    private static final String RECONFIG_COMMAND_POSITIONAL = "reconfig-command";

    ReconfigCommand() {
    }

    static void addCommand(Subparsers subparsers) {
        Subparsers reconfig = subparsers.addParser(COMMAND).help("commands specific to reconfig").addSubparsers().dest(RECONFIG_COMMAND_POSITIONAL);
        Subparser logLength = reconfig.addParser("log-length").help("compute the epoch and log end offset of the metadata log");
        Subparser forceStandalone = reconfig.addParser("force-standalone").help("forcefully override the voter set to contain only the current controller");
        ReconfigLogLengthCommand.addCommand(logLength);
        ReconfigForceStandaloneCommand.addCommand(forceStandalone);
    }

    static int execute(Namespace namespace) throws IOException, TerseException {
        switch (namespace.getString(RECONFIG_COMMAND_POSITIONAL)) {
            case "log-length": {
                return ReconfigLogLengthCommand.execute(namespace);
            }
            case "force-standalone": {
                return ReconfigForceStandaloneCommand.execute(namespace);
            }
        }
        throw new IllegalArgumentException(String.format("unknown command: %s", namespace));
    }
}

