/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.tools.recovery;

import io.confluent.kafka.tools.recovery.LockedMetadataLog;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentType;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import org.apache.kafka.raft.OffsetAndEpoch;

final class ReconfigLogLengthCommand {
    static final String COMMAND = "log-length";
    private static final String METADATA_LOG_DIR_OPTION = "--metadata-log-dir";

    ReconfigLogLengthCommand() {
    }

    static void addCommand(Subparser logLength) {
        logLength.addArgument(new String[]{METADATA_LOG_DIR_OPTION}).dest(METADATA_LOG_DIR_OPTION).required(true).metavar(new String[]{"<path-metadata-dir>"}).help("directory containing the cluster metadata log").type((ArgumentType)Arguments.fileType().verifyCanRead());
    }

    static int execute(Namespace namespace) throws IOException {
        OffsetAndEpoch latestEpochAndOffset = ReconfigLogLengthCommand.getLatestEpochAndOffset(namespace);
        System.out.printf("epoch: %s, log end offset: %s%n", latestEpochAndOffset.epoch(), latestEpochAndOffset.offset());
        return 0;
    }

    public static OffsetAndEpoch getLatestEpochAndOffset(Namespace namespace) {
        Path metadataDirectory = Paths.get(namespace.getString(METADATA_LOG_DIR_OPTION), new String[0]);
        try (LockedMetadataLog lockedLog = LockedMetadataLog.openMetadataLog(metadataDirectory);){
            long latestOffset = lockedLog.endOffset().offset();
            int latestEpoch = lockedLog.lastFetchedEpoch();
            OffsetAndEpoch offsetAndEpoch = new OffsetAndEpoch(latestOffset, latestEpoch);
            return offsetAndEpoch;
        }
    }
}

