/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConfigsOptions;
import org.apache.kafka.clients.admin.ClientMetricsResourceListing;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.util.CommandDefaultOptions;
import org.apache.kafka.server.util.CommandLineUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientMetricsCommand {
    private static final Logger LOG = LoggerFactory.getLogger(ClientMetricsCommand.class);

    public static void main(String ... args) {
        Exit.exit((int)ClientMetricsCommand.mainNoExit(args));
    }

    static int mainNoExit(String ... args) {
        try {
            ClientMetricsCommand.execute(args);
            return 0;
        }
        catch (Throwable e) {
            System.err.println(e.getMessage());
            System.err.println(Utils.stackTrace((Throwable)e));
            return 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void execute(String ... args) throws Exception {
        ClientMetricsCommandOptions opts = new ClientMetricsCommandOptions(args);
        Properties config = opts.commandConfig();
        config.put("bootstrap.servers", opts.bootstrapServer());
        int exitCode = 0;
        try (ClientMetricsService service = new ClientMetricsService(config);){
            if (opts.hasAlterOption()) {
                service.alterClientMetrics(opts);
            } else if (opts.hasDescribeOption()) {
                service.describeClientMetrics(opts);
            } else if (opts.hasDeleteOption()) {
                service.deleteClientMetrics(opts);
            } else if (opts.hasListOption()) {
                service.listClientMetrics();
            }
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause != null) {
                ClientMetricsCommand.printException(cause);
            } else {
                ClientMetricsCommand.printException(e);
            }
            exitCode = 1;
        }
        catch (Throwable t) {
            ClientMetricsCommand.printException(t);
            exitCode = 1;
        }
        finally {
            Exit.exit((int)exitCode);
        }
    }

    private static void printException(Throwable e) {
        System.out.println("Error while executing client metrics command : " + e.getMessage());
        LOG.error(Utils.stackTrace((Throwable)e));
    }

    public static final class ClientMetricsCommandOptions
    extends CommandDefaultOptions {
        private final ArgumentAcceptingOptionSpec<String> bootstrapServerOpt;
        private final ArgumentAcceptingOptionSpec<String> commandConfigOpt;
        private final OptionSpecBuilder alterOpt;
        private final OptionSpecBuilder deleteOpt;
        private final OptionSpecBuilder describeOpt;
        private final OptionSpecBuilder listOpt;
        private final ArgumentAcceptingOptionSpec<String> nameOpt;
        private final OptionSpecBuilder generateNameOpt;
        private final ArgumentAcceptingOptionSpec<String> intervalOpt;
        private final ArgumentAcceptingOptionSpec<String> matchOpt;
        private final ArgumentAcceptingOptionSpec<String> metricsOpt;

        public ClientMetricsCommandOptions(String[] args) {
            super(args);
            this.bootstrapServerOpt = this.parser.accepts("bootstrap-server", "REQUIRED: The Kafka server to connect to.").withRequiredArg().describedAs("server to connect to").ofType(String.class);
            this.commandConfigOpt = this.parser.accepts("command-config", "Property file containing configs to be passed to Admin Client.").withRequiredArg().describedAs("command config property file").ofType(String.class);
            this.alterOpt = this.parser.accepts("alter", "Alter the configuration for the client metrics resource.");
            this.deleteOpt = this.parser.accepts("delete", "Delete the configuration for the client metrics resource.");
            this.describeOpt = this.parser.accepts("describe", "List configurations for the client metrics resource.");
            this.listOpt = this.parser.accepts("list", "List the client metrics resources.");
            this.nameOpt = this.parser.accepts("name", "Name of client metrics configuration resource.").withRequiredArg().describedAs("name").ofType(String.class);
            this.generateNameOpt = this.parser.accepts("generate-name", "Generate a UUID to use as the name.");
            String nl = System.lineSeparator();
            this.intervalOpt = this.parser.accepts("interval", "The metrics push interval in milliseconds." + nl + "Leave empty to reset the interval.").withRequiredArg().describedAs("push interval").ofType(String.class);
            String[] matchSelectors = new String[]{"client_id", "client_instance_id", "client_software_name", "client_software_version", "client_source_address", "client_source_port"};
            String matchSelectorNames = Arrays.stream(matchSelectors).map(config -> "\t" + config).collect(Collectors.joining(nl));
            this.matchOpt = this.parser.accepts("match", "Matching selector 'k1=v1,k2=v2'. The following is a list of valid selector names: " + nl + matchSelectorNames).withRequiredArg().describedAs("k1=v1,k2=v2").ofType(String.class).withValuesSeparatedBy(',');
            this.metricsOpt = this.parser.accepts("metrics", "Telemetry metric name prefixes 'm1,m2'.").withRequiredArg().describedAs("m1,m2").ofType(String.class).withValuesSeparatedBy(',');
            this.options = this.parser.parse(args);
            this.checkArgs();
        }

        public Boolean has(OptionSpec<?> builder) {
            return this.options.has(builder);
        }

        public <A> Optional<A> valueAsOption(OptionSpec<A> option) {
            return this.valueAsOption(option, Optional.empty());
        }

        public <A> Optional<List<A>> valuesAsOption(OptionSpec<A> option) {
            return this.valuesAsOption(option, Optional.empty());
        }

        public <A> Optional<A> valueAsOption(OptionSpec<A> option, Optional<A> defaultValue) {
            if (this.has(option).booleanValue()) {
                return Optional.of(this.options.valueOf(option));
            }
            return defaultValue;
        }

        public <A> Optional<List<A>> valuesAsOption(OptionSpec<A> option, Optional<List<A>> defaultValue) {
            return this.options.has(option) ? Optional.of(this.options.valuesOf(option)) : defaultValue;
        }

        public String bootstrapServer() {
            return (String)this.options.valueOf(this.bootstrapServerOpt);
        }

        public Properties commandConfig() throws IOException {
            if (this.has((OptionSpec<?>)this.commandConfigOpt).booleanValue()) {
                return Utils.loadProps((String)((String)this.options.valueOf(this.commandConfigOpt)));
            }
            return new Properties();
        }

        public boolean hasAlterOption() {
            return this.has((OptionSpec<?>)this.alterOpt);
        }

        public boolean hasDeleteOption() {
            return this.has((OptionSpec<?>)this.deleteOpt);
        }

        public boolean hasDescribeOption() {
            return this.has((OptionSpec<?>)this.describeOpt);
        }

        public boolean hasListOption() {
            return this.has((OptionSpec<?>)this.listOpt);
        }

        public Optional<String> name() {
            return this.valueAsOption((OptionSpec)this.nameOpt);
        }

        public boolean hasGenerateNameOption() {
            return this.has((OptionSpec<?>)this.generateNameOpt);
        }

        public Optional<List<String>> metrics() {
            return this.valuesAsOption((OptionSpec)this.metricsOpt);
        }

        public Optional<String> interval() {
            return this.valueAsOption((OptionSpec)this.intervalOpt);
        }

        public Optional<List<String>> match() {
            return this.valuesAsOption((OptionSpec)this.matchOpt);
        }

        public void checkArgs() {
            if (this.args.length == 0) {
                CommandLineUtils.printUsageAndExit((OptionParser)this.parser, (String)"This tool helps to manipulate and describe client metrics configurations.");
            }
            CommandLineUtils.maybePrintHelpOrVersion((CommandDefaultOptions)this, (String)"This tool helps to manipulate and describe client metrics configurations.");
            long actions = Stream.of(this.alterOpt, this.deleteOpt, this.describeOpt, this.listOpt).filter(arg_0 -> ((OptionSet)this.options).has(arg_0)).count();
            if (actions != 1L) {
                CommandLineUtils.printUsageAndExit((OptionParser)this.parser, (String)"Command must include exactly one action: --alter, --delete, --describe or --list.");
            }
            if (!this.has((OptionSpec<?>)this.bootstrapServerOpt).booleanValue()) {
                throw new IllegalArgumentException("--bootstrap-server must be specified.");
            }
            CommandLineUtils.checkInvalidArgs((OptionParser)this.parser, (OptionSet)this.options, (OptionSpec)this.deleteOpt, (OptionSpec[])new OptionSpec[]{this.generateNameOpt, this.intervalOpt, this.matchOpt, this.metricsOpt});
            CommandLineUtils.checkInvalidArgs((OptionParser)this.parser, (OptionSet)this.options, (OptionSpec)this.describeOpt, (OptionSpec[])new OptionSpec[]{this.generateNameOpt, this.intervalOpt, this.matchOpt, this.metricsOpt});
            CommandLineUtils.checkInvalidArgs((OptionParser)this.parser, (OptionSet)this.options, (OptionSpec)this.listOpt, (OptionSpec[])new OptionSpec[]{this.nameOpt, this.generateNameOpt, this.intervalOpt, this.matchOpt, this.metricsOpt});
            boolean isNamePresent = this.has((OptionSpec<?>)this.nameOpt);
            if (this.has((OptionSpec<?>)this.alterOpt).booleanValue()) {
                if (isNamePresent && this.has((OptionSpec<?>)this.generateNameOpt).booleanValue() || !isNamePresent && !this.has((OptionSpec<?>)this.generateNameOpt).booleanValue()) {
                    throw new IllegalArgumentException("One of --name or --generate-name must be specified with --alter.");
                }
                this.interval().ifPresent(intervalStr -> {
                    if (!intervalStr.isEmpty()) {
                        try {
                            Integer.parseInt(intervalStr);
                        }
                        catch (NumberFormatException e) {
                            throw new IllegalArgumentException("Invalid interval value. Enter an integer, or leave empty to reset.");
                        }
                    }
                });
            }
            if (this.has((OptionSpec<?>)this.deleteOpt).booleanValue() && !isNamePresent) {
                throw new IllegalArgumentException("A client metrics resource name must be specified with --delete.");
            }
        }
    }

    public static class ClientMetricsService
    implements AutoCloseable {
        private final Admin adminClient;

        public ClientMetricsService(Properties config) {
            this.adminClient = Admin.create((Properties)config);
        }

        ClientMetricsService(Admin adminClient) {
            this.adminClient = adminClient;
        }

        public void alterClientMetrics(ClientMetricsCommandOptions opts) throws Exception {
            String entityName = opts.hasGenerateNameOption() ? Uuid.randomUuid().toString() : opts.name().get();
            HashMap configsToBeSet = new HashMap();
            opts.interval().ifPresent(intervalVal -> configsToBeSet.put("interval.ms", intervalVal.toString()));
            opts.metrics().ifPresent(metricslist -> configsToBeSet.put("metrics", String.join((CharSequence)",", metricslist)));
            opts.match().ifPresent(matchlist -> configsToBeSet.put("match", String.join((CharSequence)",", matchlist)));
            ConfigResource configResource = new ConfigResource(ConfigResource.Type.CLIENT_METRICS, entityName);
            AlterConfigsOptions alterOptions = new AlterConfigsOptions().timeoutMs(Integer.valueOf(30000)).validateOnly(false);
            Collection alterEntries = configsToBeSet.entrySet().stream().map(entry -> new AlterConfigOp(new ConfigEntry((String)entry.getKey(), (String)entry.getValue()), ((String)entry.getValue()).isEmpty() ? AlterConfigOp.OpType.DELETE : AlterConfigOp.OpType.SET)).collect(Collectors.toList());
            this.adminClient.incrementalAlterConfigs(Collections.singletonMap(configResource, alterEntries), alterOptions).all().get(30L, TimeUnit.SECONDS);
            System.out.println("Altered client metrics config for " + entityName + ".");
        }

        public void deleteClientMetrics(ClientMetricsCommandOptions opts) throws Exception {
            String entityName = opts.name().get();
            Collection<ConfigEntry> oldConfigs = this.getClientMetricsConfig(entityName);
            ConfigResource configResource = new ConfigResource(ConfigResource.Type.CLIENT_METRICS, entityName);
            AlterConfigsOptions alterOptions = new AlterConfigsOptions().timeoutMs(Integer.valueOf(30000)).validateOnly(false);
            Collection alterEntries = oldConfigs.stream().map(entry -> new AlterConfigOp(entry, AlterConfigOp.OpType.DELETE)).collect(Collectors.toList());
            this.adminClient.incrementalAlterConfigs(Collections.singletonMap(configResource, alterEntries), alterOptions).all().get(30L, TimeUnit.SECONDS);
            System.out.println("Deleted client metrics config for " + entityName + ".");
        }

        public void describeClientMetrics(ClientMetricsCommandOptions opts) throws Exception {
            List<String> entities;
            Optional<String> entityNameOpt = opts.name();
            if (entityNameOpt.isPresent()) {
                entities = Collections.singletonList(entityNameOpt.get());
            } else {
                Collection resources = (Collection)this.adminClient.listClientMetricsResources().all().get(30L, TimeUnit.SECONDS);
                entities = resources.stream().map(ClientMetricsResourceListing::name).collect(Collectors.toList());
            }
            for (String entity : entities) {
                System.out.println("Client metrics configs for " + entity + " are:");
                this.getClientMetricsConfig(entity).forEach(entry -> System.out.println("  " + entry.name() + "=" + entry.value()));
            }
        }

        public void listClientMetrics() throws Exception {
            Collection resources = (Collection)this.adminClient.listClientMetricsResources().all().get(30L, TimeUnit.SECONDS);
            String results = resources.stream().map(ClientMetricsResourceListing::name).collect(Collectors.joining("\n"));
            System.out.println(results);
        }

        private Collection<ConfigEntry> getClientMetricsConfig(String entityName) throws Exception {
            ConfigResource configResource = new ConfigResource(ConfigResource.Type.CLIENT_METRICS, entityName);
            Map result = (Map)this.adminClient.describeConfigs(Collections.singleton(configResource)).all().get(30L, TimeUnit.SECONDS);
            return ((Config)result.get(configResource)).entries();
        }

        @Override
        public void close() throws Exception {
            this.adminClient.close();
        }
    }
}

