/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools;

import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentGroup;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.ArgumentType;
import net.sourceforge.argparse4j.inf.MutuallyExclusiveGroup;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;
import net.sourceforge.argparse4j.internal.HelpScreenException;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.QuorumInfo;
import org.apache.kafka.clients.admin.RaftVoterEndpoint;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metadata.properties.MetaProperties;
import org.apache.kafka.metadata.properties.MetaPropertiesEnsemble;
import org.apache.kafka.network.SocketServerConfigs;
import org.apache.kafka.server.util.CommandLineUtils;
import org.apache.kafka.tools.TerseException;
import org.apache.kafka.tools.ToolsUtils;

public class MetadataQuorumCommand {
    public static void main(String ... args) {
        Exit.exit((int)MetadataQuorumCommand.mainNoExit(args));
    }

    static int mainNoExit(String ... args) {
        try {
            MetadataQuorumCommand.execute(args);
            return 0;
        }
        catch (HelpScreenException e) {
            return 0;
        }
        catch (ArgumentParserException e) {
            e.getParser().handleError(e);
            return 1;
        }
        catch (TerseException e) {
            System.err.println(e.getMessage());
            return 1;
        }
        catch (Throwable e) {
            System.err.println(e.getMessage());
            System.err.println(Utils.stackTrace((Throwable)e));
            return 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void execute(String ... args) throws Exception {
        block12: {
            ArgumentParser parser = ArgumentParsers.newArgumentParser((String)"kafka-metadata-quorum").defaultHelp(true).description("This tool describes kraft metadata quorum status.");
            MutuallyExclusiveGroup connectionOptions = parser.addMutuallyExclusiveGroup().required(true);
            connectionOptions.addArgument(new String[]{"--bootstrap-server"}).help("A comma-separated list of host:port pairs to use for establishing the connection to the Kafka cluster.");
            connectionOptions.addArgument(new String[]{"--bootstrap-controller"}).help("A comma-separated list of host:port pairs to use for establishing the connection to the Kafka controllers.");
            parser.addArgument(new String[]{"--command-config"}).type((ArgumentType)Arguments.fileType()).help("Property file containing configs to be passed to Admin Client. For add-controller, the file is used to specify the controller properties as well.");
            Subparsers subparsers = parser.addSubparsers().dest("command");
            MetadataQuorumCommand.addDescribeSubParser(subparsers);
            MetadataQuorumCommand.addAddControllerSubParser(subparsers);
            MetadataQuorumCommand.addRemoveControllerSubParser(subparsers);
            try (Admin admin = null;){
                Namespace namespace = parser.parseArgs(args);
                String command = namespace.getString("command");
                File optionalCommandConfig = (File)namespace.get("command_config");
                Properties props = MetadataQuorumCommand.getProperties(optionalCommandConfig);
                CommandLineUtils.initializeBootstrapProperties((Properties)props, Optional.ofNullable(namespace.getString("bootstrap_server")), Optional.ofNullable(namespace.getString("bootstrap_controller")));
                admin = Admin.create((Properties)props);
                if (command.equals("describe")) {
                    if (namespace.getBoolean("status").booleanValue() && namespace.getBoolean("replication").booleanValue()) {
                        throw new TerseException("Only one of --status or --replication should be specified with describe sub-command");
                    }
                    if (namespace.getBoolean("replication").booleanValue()) {
                        boolean humanReadable = Optional.ofNullable(namespace.getBoolean("human_readable")).orElse(false);
                        MetadataQuorumCommand.handleDescribeReplication(admin, humanReadable);
                        break block12;
                    }
                    if (namespace.getBoolean("status").booleanValue()) {
                        if (namespace.getBoolean("human_readable").booleanValue()) {
                            throw new TerseException("The option --human-readable is only supported along with --replication");
                        }
                        MetadataQuorumCommand.handleDescribeStatus(admin);
                        break block12;
                    }
                    throw new TerseException("One of --status or --replication must be specified with describe sub-command");
                }
                if (command.equals("add-controller")) {
                    if (optionalCommandConfig == null) {
                        throw new TerseException("You must supply the configuration file of the controller you are adding when using add-controller.");
                    }
                    MetadataQuorumCommand.handleAddController(admin, namespace.getBoolean("dry_run"), props);
                    break block12;
                }
                if (command.equals("remove-controller")) {
                    MetadataQuorumCommand.handleRemoveController(admin, namespace.getInt("controller_id"), namespace.getString("controller_directory_id"), namespace.getBoolean("dry_run"));
                    break block12;
                }
                throw new IllegalStateException(String.format("Unknown command: %s", command));
            }
        }
    }

    private static Properties getProperties(File optionalCommandConfig) throws TerseException, IOException {
        if (optionalCommandConfig == null) {
            return new Properties();
        }
        if (!optionalCommandConfig.exists()) {
            throw new TerseException("Properties file " + optionalCommandConfig.getPath() + " does not exists!");
        }
        return Utils.loadProps((String)optionalCommandConfig.getPath());
    }

    private static void addDescribeSubParser(Subparsers subparsers) {
        Subparser describeParser = subparsers.addParser("describe").help("Describe the metadata quorum info");
        ArgumentGroup statusArgs = describeParser.addArgumentGroup("Status");
        statusArgs.addArgument(new String[]{"--status"}).help("A short summary of the quorum status and the other provides detailed information about the status of replication.").action((ArgumentAction)Arguments.storeTrue());
        ArgumentGroup replicationArgs = describeParser.addArgumentGroup("Replication");
        replicationArgs.addArgument(new String[]{"--replication"}).help("Detailed information about the status of replication").action((ArgumentAction)Arguments.storeTrue());
        replicationArgs.addArgument(new String[]{"--human-readable"}).help("Human-readable output").action((ArgumentAction)Arguments.storeTrue());
    }

    private static void handleDescribeReplication(Admin admin, boolean humanReadable) throws ExecutionException, InterruptedException {
        QuorumInfo quorumInfo = (QuorumInfo)admin.describeMetadataQuorum().quorumInfo().get();
        int leaderId = quorumInfo.leaderId();
        QuorumInfo.ReplicaState leader = quorumInfo.voters().stream().filter(voter -> voter.replicaId() == leaderId).findFirst().get();
        ArrayList<List<String>> rows = new ArrayList<List<String>>();
        rows.addAll(MetadataQuorumCommand.quorumInfoToRows(leader, Stream.of(leader), "Leader", humanReadable));
        rows.addAll(MetadataQuorumCommand.quorumInfoToRows(leader, quorumInfo.voters().stream().filter(v -> v.replicaId() != leaderId), "Follower", humanReadable));
        rows.addAll(MetadataQuorumCommand.quorumInfoToRows(leader, quorumInfo.observers().stream(), "Observer", humanReadable));
        ToolsUtils.prettyPrintTable(Arrays.asList("NodeId", "DirectoryId", "LogEndOffset", "Lag", "LastFetchTimestamp", "LastCaughtUpTimestamp", "Status"), rows, System.out);
    }

    private static List<List<String>> quorumInfoToRows(QuorumInfo.ReplicaState leader, Stream<QuorumInfo.ReplicaState> infos, String status, boolean humanReadable) {
        return infos.map(info -> {
            String lastFetchTimestamp;
            String string = info.lastFetchTimestamp().isEmpty() ? "-1" : (lastFetchTimestamp = humanReadable ? String.format("%d ms ago", MetadataQuorumCommand.relativeTimeMs(info.lastFetchTimestamp().getAsLong(), "last fetch")) : String.valueOf(info.lastFetchTimestamp().getAsLong()));
            String lastCaughtUpTimestamp = info.lastCaughtUpTimestamp().isEmpty() ? "-1" : (humanReadable ? String.format("%d ms ago", MetadataQuorumCommand.relativeTimeMs(info.lastCaughtUpTimestamp().getAsLong(), "last caught up")) : String.valueOf(info.lastCaughtUpTimestamp().getAsLong()));
            return Stream.of(Integer.valueOf(info.replicaId()), info.replicaDirectoryId(), info.logEndOffset(), leader.logEndOffset() - info.logEndOffset(), lastFetchTimestamp, lastCaughtUpTimestamp, status).map(r -> r.toString()).collect(Collectors.toList());
        }).collect(Collectors.toList());
    }

    static long relativeTimeMs(long timestampMs, String desc) {
        Instant lastTimestamp = Instant.ofEpochMilli(timestampMs);
        Instant now = Instant.now();
        if (!lastTimestamp.isAfter(Instant.EPOCH) || !lastTimestamp.isBefore(now) && !lastTimestamp.equals(now)) {
            throw new KafkaException(String.format("Error while computing relative time, possible drift in system clock.%nCurrent timestamp is %d, %s timestamp is %d", now.toEpochMilli(), desc, timestampMs));
        }
        return Duration.between(lastTimestamp, now).toMillis();
    }

    private static void handleDescribeStatus(Admin admin) throws ExecutionException, InterruptedException {
        String clusterId = (String)admin.describeCluster().clusterId().get();
        QuorumInfo quorumInfo = (QuorumInfo)admin.describeMetadataQuorum().quorumInfo().get();
        int leaderId = quorumInfo.leaderId();
        QuorumInfo.ReplicaState leader = quorumInfo.voters().stream().filter(voter -> voter.replicaId() == leaderId).findFirst().get();
        QuorumInfo.ReplicaState maxLagFollower = quorumInfo.voters().stream().min(Comparator.comparingLong(qi -> qi.logEndOffset())).get();
        long maxFollowerLag = leader.logEndOffset() - maxLagFollower.logEndOffset();
        long maxFollowerLagTimeMs = leader == maxLagFollower ? 0L : (leader.lastCaughtUpTimestamp().isPresent() && maxLagFollower.lastCaughtUpTimestamp().isPresent() ? leader.lastCaughtUpTimestamp().getAsLong() - maxLagFollower.lastCaughtUpTimestamp().getAsLong() : -1L);
        System.out.println("ClusterId:              " + clusterId + "\nLeaderId:               " + quorumInfo.leaderId() + "\nLeaderEpoch:            " + quorumInfo.leaderEpoch() + "\nHighWatermark:          " + quorumInfo.highWatermark() + "\nMaxFollowerLag:         " + maxFollowerLag + "\nMaxFollowerLagTimeMs:   " + maxFollowerLagTimeMs + "\nCurrentVoters:          " + MetadataQuorumCommand.printVoterState(quorumInfo) + "\nCurrentObservers:       " + MetadataQuorumCommand.printObserverState(quorumInfo));
    }

    private static String printVoterState(QuorumInfo quorumInfo) {
        return MetadataQuorumCommand.printReplicaState(quorumInfo, quorumInfo.voters());
    }

    private static String printObserverState(QuorumInfo quorumInfo) {
        return MetadataQuorumCommand.printReplicaState(quorumInfo, quorumInfo.observers());
    }

    private static String printReplicaState(QuorumInfo quorumInfo, List<QuorumInfo.ReplicaState> replicas) {
        List currentVoterList = replicas.stream().map(voter -> new Node(voter.replicaId(), voter.replicaDirectoryId(), MetadataQuorumCommand.getEndpoints((QuorumInfo.Node)quorumInfo.nodes().get(voter.replicaId())))).collect(Collectors.toList());
        return currentVoterList.stream().map(Objects::toString).collect(Collectors.joining(", ", "[", "]"));
    }

    private static List<RaftVoterEndpoint> getEndpoints(QuorumInfo.Node node) {
        return node == null ? new ArrayList() : node.endpoints();
    }

    private static void addAddControllerSubParser(Subparsers subparsers) {
        Subparser addControllerParser = subparsers.addParser("add-controller").help("Add a controller to the KRaft controller cluster");
        addControllerParser.addArgument(new String[]{"--dry-run"}).help("True if we should print what would be done, but not do it.").action((ArgumentAction)Arguments.storeTrue());
    }

    public static int getControllerId(Properties props) throws TerseException {
        if (!props.containsKey("node.id")) {
            throw new TerseException("node.id not found in configuration file. Is this a valid controller configuration file?");
        }
        int nodeId = Integer.parseInt(props.getProperty("node.id"));
        if (nodeId < 0) {
            throw new TerseException("node.id was negative in configuration file. Is this a valid controller configuration file?");
        }
        if (!props.getOrDefault((Object)"process.roles", "").toString().contains("controller")) {
            throw new TerseException("process.roles did not contain 'controller' in configuration file. Is this a valid controller configuration file?");
        }
        return nodeId;
    }

    public static String getMetadataDirectory(Properties props) throws TerseException {
        String[] logDirs;
        if (props.containsKey("metadata.log.dir")) {
            return props.getProperty("metadata.log.dir");
        }
        if (props.containsKey("log.dirs") && (logDirs = props.getProperty("log.dirs").trim().split(",")).length > 0) {
            return logDirs[0];
        }
        throw new TerseException("Neither metadata.log.dir nor log.dirs were found. Is this a valid controller configuration file?");
    }

    public static Uuid getMetadataDirectoryId(String metadataDirectory) throws TerseException, IOException {
        MetaPropertiesEnsemble ensemble = new MetaPropertiesEnsemble.Loader().addLogDirs(Collections.singletonList(metadataDirectory)).addMetadataLogDir(metadataDirectory).load();
        MetaProperties metaProperties = (MetaProperties)ensemble.logDirProps().get(metadataDirectory);
        if (metaProperties == null) {
            throw new TerseException("Unable to read meta.properties from " + metadataDirectory);
        }
        if (metaProperties.directoryId().isEmpty()) {
            throw new TerseException("No directory id found in " + metadataDirectory);
        }
        return (Uuid)metaProperties.directoryId().get();
    }

    public static Set<RaftVoterEndpoint> getControllerAdvertisedListeners(Properties props) throws TerseException {
        HashMap listeners = new HashMap();
        SocketServerConfigs.listenerListToEndPoints((String)props.getOrDefault((Object)"listeners", "").toString(), __ -> SecurityProtocol.PLAINTEXT).forEach(e -> listeners.put((String)e.listenerName().get(), e));
        SocketServerConfigs.listenerListToEndPoints((String)props.getOrDefault((Object)"advertised.listeners", "").toString(), __ -> SecurityProtocol.PLAINTEXT).forEach(e -> listeners.put((String)e.listenerName().get(), e));
        if (!props.containsKey("controller.listener.names")) {
            throw new TerseException("controller.listener.names was not found. Is this a valid controller configuration file?");
        }
        LinkedHashSet<RaftVoterEndpoint> results = new LinkedHashSet<RaftVoterEndpoint>();
        for (String listenerName : props.getProperty("controller.listener.names").split(",")) {
            Endpoint endpoint = (Endpoint)listeners.get(listenerName = ListenerName.normalised((String)listenerName).value());
            if (endpoint == null) {
                throw new TerseException("Cannot find information about controller listener name: " + listenerName);
            }
            results.add(new RaftVoterEndpoint((String)endpoint.listenerName().get(), endpoint.host() == null ? "localhost" : endpoint.host(), endpoint.port()));
        }
        return results;
    }

    static void handleAddController(Admin admin, boolean dryRun, Properties props) throws Exception {
        int controllerId = MetadataQuorumCommand.getControllerId(props);
        String metadataDirectory = MetadataQuorumCommand.getMetadataDirectory(props);
        Uuid directoryId = MetadataQuorumCommand.getMetadataDirectoryId(metadataDirectory);
        Set<RaftVoterEndpoint> endpoints = MetadataQuorumCommand.getControllerAdvertisedListeners(props);
        if (!dryRun) {
            admin.addRaftVoter(controllerId, directoryId, endpoints).all().get();
        }
        StringBuilder output = new StringBuilder();
        if (dryRun) {
            output.append("DRY RUN of adding");
        } else {
            output.append("Added");
        }
        output.append(" controller ").append(controllerId);
        output.append(" with directory id ").append(directoryId);
        output.append(" and endpoints: ");
        String prefix = "";
        for (RaftVoterEndpoint endpoint : endpoints) {
            output.append(prefix).append(endpoint.name()).append("://");
            if (endpoint.host().contains(":")) {
                output.append("[");
            }
            output.append(endpoint.host());
            if (endpoint.host().contains(":")) {
                output.append("]");
            }
            output.append(":").append(endpoint.port());
            prefix = ", ";
        }
        System.out.println(output);
    }

    private static void addRemoveControllerSubParser(Subparsers subparsers) {
        Subparser removeControllerParser = subparsers.addParser("remove-controller").help("Remove a controller from the KRaft controller cluster");
        removeControllerParser.addArgument(new String[]{"--controller-id", "-i"}).help("The id of the controller to remove.").type(Integer.class).required(true).action((ArgumentAction)Arguments.store());
        removeControllerParser.addArgument(new String[]{"--controller-directory-id", "-d"}).help("The directory ID of the controller to remove.").required(true).action((ArgumentAction)Arguments.store());
        removeControllerParser.addArgument(new String[]{"--dry-run"}).help("True if we should print what would be done, but not do it.").action((ArgumentAction)Arguments.storeTrue());
    }

    static void handleRemoveController(Admin admin, int controllerId, String controllerDirectoryIdString, boolean dryRun) throws TerseException, ExecutionException, InterruptedException {
        Uuid directoryId;
        if (controllerId < 0) {
            throw new TerseException("Invalid negative --controller-id: " + controllerId);
        }
        try {
            directoryId = Uuid.fromString((String)controllerDirectoryIdString);
        }
        catch (IllegalArgumentException e) {
            throw new TerseException("Failed to parse --controller-directory-id: " + e.getMessage());
        }
        if (!dryRun) {
            admin.removeRaftVoter(controllerId, directoryId).all().get();
        }
        System.out.printf("%s KRaft controller %d with directory id %s%n", dryRun ? "DRY RUN of removing " : "Removed ", controllerId, directoryId);
    }

    private static class Node {
        private final int id;
        private final Uuid directoryId;
        private final List<RaftVoterEndpoint> endpoints;

        private Node(int id, Uuid directoryId, List<RaftVoterEndpoint> endpoints) {
            this.id = id;
            this.directoryId = Objects.requireNonNull(directoryId);
            this.endpoints = Objects.requireNonNull(endpoints);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            sb.append("\"id\": ").append(this.id).append(", ");
            sb.append("\"directoryId\": ").append((String)(this.directoryId.equals((Object)Uuid.ZERO_UUID) ? "null" : "\"" + String.valueOf(this.directoryId) + "\""));
            if (!this.endpoints.isEmpty()) {
                sb.append(", \"endpoints\": [");
                for (RaftVoterEndpoint endpoint : this.endpoints) {
                    sb.append("\"");
                    sb.append(endpoint.toString()).append("\", ");
                }
                sb.setLength(sb.length() - 2);
                sb.append("]");
            }
            sb.append("}");
            return sb.toString();
        }
    }
}

