/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.MutuallyExclusiveGroup;
import net.sourceforge.argparse4j.inf.Namespace;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Utils;

public class ProducerOneRequestPerConnectionPerformance {
    Stats stats;

    public static void main(String[] args) throws Exception {
        ProducerOneRequestPerConnectionPerformance perf = new ProducerOneRequestPerConnectionPerformance();
        perf.start(args);
    }

    void start(String[] args) throws IOException {
        ArgumentParser parser = ProducerOneRequestPerConnectionPerformance.argParser();
        try {
            int i;
            Namespace res = parser.parseArgs(args);
            String topicName = res.getString("topic");
            long numRecords = res.getLong("numRecords");
            Integer recordSize = res.getInt("recordSize");
            List producerProps = res.getList("producerConfig");
            String producerConfig = res.getString("producerConfigFile");
            int numThreads = res.getInt("numThreads");
            if (producerProps == null && producerConfig == null) {
                throw new ArgumentParserException("Either --producer-props or --producer.config must be specified.", parser);
            }
            Properties props = ProducerOneRequestPerConnectionPerformance.readProps(producerProps, producerConfig);
            if (recordSize == null) {
                recordSize = 1024;
            }
            byte[] payload = ProducerOneRequestPerConnectionPerformance.generateRandomPayload(recordSize);
            this.stats = new Stats(numRecords, 5000);
            long messageSent = 0L;
            SendMessageTask[] tasks = new SendMessageTask[numThreads];
            for (i = 0; i < numThreads; ++i) {
                tasks[i] = new SendMessageTask(props, topicName, payload, this.stats);
                new Thread(tasks[i]).start();
                ++messageSent;
            }
            while (messageSent < numRecords) {
                for (i = 0; i < numThreads; ++i) {
                    if (!tasks[i].isDone()) continue;
                    tasks[i] = new SendMessageTask(props, topicName, payload, this.stats);
                    new Thread(tasks[i]).start();
                    ++messageSent;
                }
                Thread.sleep(10L);
            }
            this.stats.printTotal();
        }
        catch (ArgumentParserException e) {
            if (args.length == 0) {
                parser.printHelp();
                Exit.exit((int)0);
            } else {
                parser.handleError(e);
                Exit.exit((int)1);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    static byte[] generateRandomPayload(Integer recordSize) {
        byte[] payload = new byte[recordSize.intValue()];
        Random random = new Random();
        for (int j = 0; j < recordSize; ++j) {
            payload[j] = (byte)(random.nextInt(26) + 65);
        }
        return payload;
    }

    static Properties readProps(List<String> producerProps, String producerConfig) throws IOException {
        Properties props = new Properties();
        if (producerConfig != null) {
            props.putAll((Map<?, ?>)Utils.loadProps((String)producerConfig));
        }
        if (producerProps != null) {
            for (String prop : producerProps) {
                String[] pieces = prop.split("=");
                if (pieces.length != 2) {
                    throw new IllegalArgumentException("Invalid property: " + prop);
                }
                props.put(pieces[0], pieces[1]);
            }
        }
        props.put("key.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        props.put("value.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        if (props.getProperty("client.id") == null) {
            Random random = new Random();
            props.put("client.id", "perf-producer-client-" + random.nextInt(10000));
        }
        return props;
    }

    static ArgumentParser argParser() {
        ArgumentParser parser = ArgumentParsers.newArgumentParser((String)"producer-performance").defaultHelp(true).description("This tool is used to verify the producer performance.");
        MutuallyExclusiveGroup payloadOptions = parser.addMutuallyExclusiveGroup().required(true).description("either --record-size or --payload-file must be specified but not both.");
        parser.addArgument(new String[]{"--topic"}).action((ArgumentAction)Arguments.store()).required(true).type(String.class).metavar(new String[]{"TOPIC"}).help("produce messages to this topic");
        parser.addArgument(new String[]{"--num-records"}).action((ArgumentAction)Arguments.store()).required(true).type(Long.class).metavar(new String[]{"NUM-RECORDS"}).dest("numRecords").help("number of messages to produce");
        parser.addArgument(new String[]{"--num-threads"}).action((ArgumentAction)Arguments.store()).required(true).type(Integer.class).metavar(new String[]{"NUM-THREADS"}).dest("numThreads").help("number of threads to produce in parallel");
        payloadOptions.addArgument(new String[]{"--record-size"}).action((ArgumentAction)Arguments.store()).required(false).type(Integer.class).metavar(new String[]{"RECORD-SIZE"}).dest("recordSize").help("message size in bytes. Note that you must provide exactly one of --record-size or --payload-file.");
        parser.addArgument(new String[]{"--producer-props"}).nargs("+").required(false).metavar(new String[]{"PROP-NAME=PROP-VALUE"}).type(String.class).dest("producerConfig").help("kafka producer related configuration properties like bootstrap.servers,client.id etc. These configs take precedence over those passed via --producer.config.");
        parser.addArgument(new String[]{"--producer.config"}).action((ArgumentAction)Arguments.store()).required(false).type(String.class).metavar(new String[]{"CONFIG-FILE"}).dest("producerConfigFile").help("producer config properties file.");
        parser.addArgument(new String[]{"--print-metrics"}).action((ArgumentAction)Arguments.storeTrue()).type(Boolean.class).metavar(new String[]{"PRINT-METRICS"}).dest("printMetrics").help("print out metrics at the end of the test.");
        return parser;
    }

    static class Stats {
        private final long start = System.currentTimeMillis();
        private final int[] latencies;
        private final long sampling;
        private final long reportingInterval;
        private volatile long iteration = 0L;
        private int index;
        private long count;
        private long bytes;
        private int maxLatency;
        private long totalLatency;
        private long windowCount;
        private int windowMaxLatency;
        private long windowTotalLatency;
        private long windowBytes;
        private long windowStart = System.currentTimeMillis();

        public Stats(long numRecords, int reportingInterval) {
            this.sampling = numRecords / Math.min(numRecords, 500000L);
            this.latencies = new int[(int)(numRecords / this.sampling) + 1];
            this.index = 0;
            this.maxLatency = 0;
            this.windowCount = 0L;
            this.windowMaxLatency = 0;
            this.windowTotalLatency = 0L;
            this.windowBytes = 0L;
            this.totalLatency = 0L;
            this.reportingInterval = reportingInterval;
        }

        public synchronized void record(int latency, int bytes, long time) {
            ++this.count;
            this.bytes += (long)bytes;
            this.totalLatency += (long)latency;
            this.maxLatency = Math.max(this.maxLatency, latency);
            ++this.windowCount;
            this.windowBytes += (long)bytes;
            this.windowTotalLatency += (long)latency;
            this.windowMaxLatency = Math.max(this.windowMaxLatency, latency);
            if (this.iteration % this.sampling == 0L) {
                this.latencies[this.index] = latency;
                ++this.index;
            }
            if (time - this.windowStart >= this.reportingInterval) {
                this.printWindow();
                this.newWindow();
            }
        }

        public long totalCount() {
            return this.count;
        }

        public long currentWindowCount() {
            return this.windowCount;
        }

        public long iteration() {
            return this.iteration;
        }

        public long bytes() {
            return this.bytes;
        }

        public int index() {
            return this.index;
        }

        public void printWindow() {
            long elapsed = System.currentTimeMillis() - this.windowStart;
            double recsPerSec = 1000.0 * (double)this.windowCount / (double)elapsed;
            double mbPerSec = 1000.0 * (double)this.windowBytes / (double)elapsed / 1048576.0;
            System.out.printf("%d records sent, %.1f records/sec (%.2f MB/sec), %.1f ms avg latency, %.1f ms max latency.%n", this.windowCount, recsPerSec, mbPerSec, (double)this.windowTotalLatency / (double)this.windowCount, (double)this.windowMaxLatency);
        }

        public void newWindow() {
            this.windowStart = System.currentTimeMillis();
            this.windowCount = 0L;
            this.windowMaxLatency = 0;
            this.windowTotalLatency = 0L;
            this.windowBytes = 0L;
        }

        public void printTotal() {
            long elapsed = System.currentTimeMillis() - this.start;
            double recsPerSec = 1000.0 * (double)this.count / (double)elapsed;
            double mbPerSec = 1000.0 * (double)this.bytes / (double)elapsed / 1048576.0;
            int[] percs = Stats.percentiles(this.latencies, this.index, 0.5, 0.95, 0.99, 0.999);
            System.out.printf("%d records sent, %f records/sec (%.2f MB/sec), %.2f ms avg latency, %.2f ms max latency, %d ms 50th, %d ms 95th, %d ms 99th, %d ms 99.9th.%n", this.count, recsPerSec, mbPerSec, (double)this.totalLatency / (double)this.count, (double)this.maxLatency, percs[0], percs[1], percs[2], percs[3]);
        }

        private static int[] percentiles(int[] latencies, int count, double ... percentiles) {
            int size = Math.min(count, latencies.length);
            Arrays.sort(latencies, 0, size);
            int[] values = new int[percentiles.length];
            for (int i = 0; i < percentiles.length; ++i) {
                int index = (int)(percentiles[i] * (double)size);
                values[i] = latencies[index];
            }
            return values;
        }
    }

    static class SendMessageTask
    implements Runnable {
        private final String topic;
        private final byte[] payload;
        private final Properties props;
        private final Stats stats;
        private volatile boolean isDone = false;

        public SendMessageTask(Properties producerConfig, String topic, byte[] payload, Stats stats) {
            this.props = producerConfig;
            this.topic = topic;
            this.payload = payload;
            this.stats = stats;
        }

        @Override
        public void run() {
            try (KafkaProducer producer = new KafkaProducer(this.props);){
                ProducerRecord record = new ProducerRecord(this.topic, (Object)this.payload);
                long sendStartMs = System.currentTimeMillis();
                PerfCallback cb = new PerfCallback(sendStartMs, this.payload.length, this.stats, this);
                producer.send(record, (Callback)cb);
            }
        }

        public boolean isDone() {
            return this.isDone;
        }

        public void markDone() {
            this.isDone = true;
        }
    }

    static final class PerfCallback
    implements Callback {
        private final long start;
        private final int bytes;
        private final Stats stats;
        private final SendMessageTask task;
        public static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

        public PerfCallback(long start, int bytes, Stats stats, SendMessageTask task) {
            this.start = start;
            this.stats = stats;
            this.bytes = bytes;
            this.task = task;
        }

        public void onCompletion(RecordMetadata metadata, Exception exception) {
            long now = System.currentTimeMillis();
            int latency = (int)(now - this.start);
            if (exception == null) {
                this.stats.record(latency, this.bytes, now);
                ++this.stats.iteration;
            }
            if (exception != null) {
                exception.printStackTrace();
            }
            this.task.markDone();
        }

        public static String convertToReadableFormat(long timestamp) {
            Date date = new Date(timestamp);
            return sdf.format(date);
        }
    }
}

