/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools.cellsadmincmd;

import io.confluent.kafka.clients.CloudAdmin;
import java.io.PrintStream;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.message.DescribeCellsResponseData;
import org.apache.kafka.tools.CloudAdminCommand;
import org.apache.kafka.tools.cellsadmincmd.CellsAdminCommand;

public class CellStatusCommand
implements CloudAdminCommand {
    @Override
    public String name() {
        return "status";
    }

    @Override
    public void addSubparser(Subparsers subparsers) {
        Subparser parser = subparsers.addParser(this.name()).help("Gives cell status");
    }

    @Override
    public void execute(CloudAdmin admin, Namespace ns, PrintStream out) throws Exception {
        boolean cellsEnabled;
        Config clusterConfig;
        try {
            ConfigResource cluster = new ConfigResource(ConfigResource.Type.BROKER, "0");
            Map describedConfigs = (Map)admin.describeConfigs(Collections.singleton(cluster)).all().get();
            clusterConfig = (Config)describedConfigs.get(cluster);
        }
        catch (ExecutionException e) {
            CellsAdminCommand.printErrorAndExit("Failed to fetch cluster details", e.getCause());
            return;
        }
        try {
            cellsEnabled = ((DescribeCellsResponseData)admin.describeCells(Collections.emptyList()).value().get()).cellsEnabled();
        }
        catch (ExecutionException e) {
            CellsAdminCommand.printErrorAndExit("Failed to fetch cell enabled details", e.getCause());
            return;
        }
        int cellSize = cellsEnabled ? Integer.parseInt(clusterConfig.get("confluent.cells.default.size").value()) : 15;
        int minCellSize = cellsEnabled ? Integer.parseInt(clusterConfig.get("confluent.cells.min.size").value()) : 6;
        int maxCellSize = cellsEnabled ? Integer.parseInt(clusterConfig.get("confluent.cells.max.size").value()) : 15;
        StringBuilder message = new StringBuilder();
        message.append(String.format("Cells enabled: %s\n", cellsEnabled));
        message.append(String.format("Cell size: %d\n", cellSize));
        message.append(String.format("Min cell size: %d\n", minCellSize));
        message.append(String.format("Max cell size: %d", maxCellSize));
        CellsAdminCommand.printMessageAndExit(out, message.toString());
    }
}

