/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools.cellsadmincmd;

import io.confluent.kafka.clients.CloudAdmin;
import java.io.PrintStream;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;
import org.apache.kafka.common.CellState;
import org.apache.kafka.tools.CloudAdminCommand;
import org.apache.kafka.tools.cellsadmincmd.CellsAdminCommand;

public class CreateCellCommand
implements CloudAdminCommand {
    private static final String VALID_CELL_STATES = CellState.VALID_CELL_STATES.stream().map(Enum::name).sorted().collect(Collectors.joining(", "));

    @Override
    public String name() {
        return "create-cell";
    }

    @Override
    public void addSubparser(Subparsers subparsers) {
        Subparser parser = subparsers.addParser(this.name()).help("Create cell");
        parser.addArgument(new String[]{"--cell-id"}).help("cell id to create").action((ArgumentAction)Arguments.store()).type(Integer.class).required(true);
        parser.addArgument(new String[]{"--state"}).help("target state of cell (" + VALID_CELL_STATES + ")").action((ArgumentAction)Arguments.store()).type(String.class).required(true);
    }

    @Override
    public void execute(CloudAdmin admin, Namespace ns, PrintStream out) throws Exception {
        CellState state;
        int cellId = ns.getInt("cell_id");
        String stateString = ns.getString("state");
        try {
            state = CellState.valueOf((String)stateString);
        }
        catch (IllegalArgumentException e) {
            CellsAdminCommand.printErrorAndExit("Invalid cell state given. Must be one of " + VALID_CELL_STATES);
            return;
        }
        try {
            admin.createCell(cellId, state).value().get();
        }
        catch (ExecutionException e) {
            CellsAdminCommand.printErrorAndExit("Failed to create cell", e.getCause());
            return;
        }
        String message = "Successfully created cell " + cellId + " with cell state " + stateString;
        CellsAdminCommand.printMessageAndExit(out, message);
    }
}

