/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools.cellsadmincmd;

import io.confluent.kafka.clients.CloudAdmin;
import java.io.PrintStream;
import java.util.concurrent.ExecutionException;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;
import org.apache.kafka.tools.CloudAdminCommand;
import org.apache.kafka.tools.cellsadmincmd.CellsAdminCommand;

public class DeleteCellCommand
implements CloudAdminCommand {
    @Override
    public String name() {
        return "delete-cell";
    }

    @Override
    public void addSubparser(Subparsers subparsers) {
        Subparser parser = subparsers.addParser(this.name()).help("Delete cell");
        parser.addArgument(new String[]{"--cell-id"}).help("cell id to delete").action((ArgumentAction)Arguments.store()).type(Integer.class).required(true);
    }

    @Override
    public void execute(CloudAdmin admin, Namespace ns, PrintStream out) throws Exception {
        int cellId = ns.getInt("cell_id");
        try {
            admin.deleteCell(cellId).value().get();
        }
        catch (ExecutionException e) {
            CellsAdminCommand.printErrorAndExit("Failed to delete cell", e.getCause());
            return;
        }
        CellsAdminCommand.printMessageAndExit(out, "Successfully deleted cell " + cellId);
    }
}

