/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools.consumer;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.nio.ByteBuffer;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.coordinator.group.generated.CoordinatorRecordType;
import org.apache.kafka.coordinator.group.generated.GroupMetadataKey;
import org.apache.kafka.coordinator.group.generated.GroupMetadataKeyJsonConverter;
import org.apache.kafka.coordinator.group.generated.GroupMetadataValue;
import org.apache.kafka.coordinator.group.generated.GroupMetadataValueJsonConverter;
import org.apache.kafka.tools.consumer.ApiMessageFormatter;

public class GroupMetadataMessageFormatter
extends ApiMessageFormatter {
    @Override
    protected JsonNode readToKeyJson(ByteBuffer byteBuffer) {
        try {
            switch (CoordinatorRecordType.fromId((short)byteBuffer.getShort())) {
                case GROUP_METADATA: {
                    return GroupMetadataKeyJsonConverter.write((GroupMetadataKey)new GroupMetadataKey((Readable)new ByteBufferAccessor(byteBuffer), 0), (short)0);
                }
            }
            return NullNode.getInstance();
        }
        catch (UnsupportedVersionException ex) {
            return NullNode.getInstance();
        }
    }

    @Override
    protected JsonNode readToValueJson(ByteBuffer byteBuffer) {
        short version = byteBuffer.getShort();
        if (version >= 0 && version <= 4) {
            return GroupMetadataValueJsonConverter.write((GroupMetadataValue)new GroupMetadataValue((Readable)new ByteBufferAccessor(byteBuffer), version), (short)version);
        }
        return new TextNode("unknown");
    }
}

