/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools.consumer;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.nio.ByteBuffer;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.coordinator.group.generated.CoordinatorRecordType;
import org.apache.kafka.coordinator.group.generated.OffsetCommitKey;
import org.apache.kafka.coordinator.group.generated.OffsetCommitKeyJsonConverter;
import org.apache.kafka.coordinator.group.generated.OffsetCommitValue;
import org.apache.kafka.coordinator.group.generated.OffsetCommitValueJsonConverter;
import org.apache.kafka.tools.consumer.ApiMessageFormatter;

public class OffsetsMessageFormatter
extends ApiMessageFormatter {
    @Override
    protected JsonNode readToKeyJson(ByteBuffer byteBuffer) {
        try {
            switch (CoordinatorRecordType.fromId((short)byteBuffer.getShort())) {
                case LEGACY_OFFSET_COMMIT: 
                case OFFSET_COMMIT: {
                    return OffsetCommitKeyJsonConverter.write((OffsetCommitKey)new OffsetCommitKey((Readable)new ByteBufferAccessor(byteBuffer), 0), (short)0);
                }
            }
            return NullNode.getInstance();
        }
        catch (UnsupportedVersionException ex) {
            return NullNode.getInstance();
        }
    }

    @Override
    protected JsonNode readToValueJson(ByteBuffer byteBuffer) {
        short version = byteBuffer.getShort();
        if (version >= 0 && version <= 4) {
            return OffsetCommitValueJsonConverter.write((OffsetCommitValue)new OffsetCommitValue((Readable)new ByteBufferAccessor(byteBuffer), version), (short)version);
        }
        return new TextNode("unknown");
    }
}

