/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools.consumer.group;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.apache.kafka.server.util.CommandDefaultOptions;
import org.apache.kafka.server.util.CommandLineUtils;
import org.apache.kafka.tools.ToolsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerGroupCommandOptions
extends CommandDefaultOptions {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsumerGroupCommandOptions.class);
    private static final String BOOTSTRAP_SERVER_DOC = "The server(s) to connect to. REQUIRED for all options except for --validate-regex.";
    private static final String GROUP_DOC = "The consumer group we wish to act on.";
    private static final String TOPIC_DOC = "The topic whose consumer group information should be deleted or topic whose should be included in the reset offset process. In `reset-offsets` case, partitions can be specified using this format: `topic1:0,1,2`, where 0,1,2 are the partition to be included in the process. Reset-offsets also supports multiple topic inputs.";
    private static final String ALL_TOPICS_DOC = "Consider all topics assigned to a group in the `reset-offsets` process.";
    private static final String LIST_DOC = "List all consumer groups.";
    private static final String DESCRIBE_DOC = "Describe consumer group and list offset lag (number of messages not yet processed) related to given group.";
    private static final String ALL_GROUPS_DOC = "Apply to all consumer groups.";
    private static final String NL = System.lineSeparator();
    private static final String DELETE_DOC = "Pass in groups to delete topic partition offsets and ownership information over the entire consumer group. For instance --group g1 --group g2";
    private static final String TIMEOUT_MS_DOC = "The timeout that can be set for some use cases. For example, it can be used when describing the group to specify the maximum amount of time in milliseconds to wait before the group stabilizes (when the group is just created, or is going through some changes).";
    private static final String COMMAND_CONFIG_DOC = "Property file containing configs to be passed to Admin Client and Consumer.";
    private static final String RESET_OFFSETS_DOC = "Reset offsets of consumer group. Supports one consumer group at the time, and instances should be inactive" + NL + "Has 2 execution options: --dry-run (the default) to plan which offsets to reset, and --execute to update the offsets. Additionally, the --export option is used to export the results to a CSV format." + NL + "You must choose one of the following reset specifications: --to-datetime, --by-duration, --to-earliest, --to-latest, --shift-by, --from-file, --to-current, --to-offset." + NL + "To define the scope use --all-topics or --topic. One scope must be specified unless you use '--from-file'.";
    private static final String DRY_RUN_DOC = "Only show results without executing changes on Consumer Groups. Supported operations: reset-offsets.";
    private static final String EXECUTE_DOC = "Execute operation. Supported operations: reset-offsets.";
    private static final String EXPORT_DOC = "Export operation execution to a CSV file. Supported operations: reset-offsets.";
    private static final String RESET_TO_OFFSET_DOC = "Reset offsets to a specific offset.";
    private static final String RESET_FROM_FILE_DOC = "Reset offsets to values defined in CSV file.";
    private static final String RESET_TO_DATETIME_DOC = "Reset offsets to offset from datetime. Format: 'YYYY-MM-DDThh:mm:ss.sss'";
    private static final String RESET_BY_DURATION_DOC = "Reset offsets to offset by duration from current timestamp. Format: 'PnDTnHnMnS'";
    private static final String RESET_TO_EARLIEST_DOC = "Reset offsets to earliest offset.";
    private static final String RESET_TO_LATEST_DOC = "Reset offsets to latest offset.";
    private static final String RESET_TO_CURRENT_DOC = "Reset offsets to current offset.";
    private static final String RESET_SHIFT_BY_DOC = "Reset offsets shifting current offset by 'n', where 'n' can be positive or negative.";
    private static final String MEMBERS_DOC = "Describe members of the group. This option may be used with '--describe' and '--bootstrap-server' options only." + NL + "Example: --bootstrap-server localhost:9092 --describe --group group1 --members";
    private static final String VERBOSE_DOC = "Provide additional information, if any, when describing the group. This option may be used with '--offsets'/'--members'/'--state' and '--bootstrap-server' options only." + NL + "Example: --bootstrap-server localhost:9092 --describe --group group1 --members --verbose";
    private static final String OFFSETS_DOC = "Describe the group and list all topic partitions in the group along with their offset lag. This is the default sub-action of and may be used with '--describe' and '--bootstrap-server' options only." + NL + "Example: --bootstrap-server localhost:9092 --describe --group group1 --offsets";
    private static final String STATE_DOC = "When specified with '--describe', includes the state of the group." + NL + "Example: --bootstrap-server localhost:9092 --describe --group group1 --state" + NL + "When specified with '--list', it displays the state of all groups. It can also be used to list groups with specific states." + NL + "Example: --bootstrap-server localhost:9092 --list --state stable,empty" + NL + "This option may be used with '--describe', '--list' and '--bootstrap-server' options only.";
    private static final String TYPE_DOC = "When specified with '--list', it displays the types of all the groups. It can also be used to list groups with specific types." + NL + "Example: --bootstrap-server localhost:9092 --list --type classic,consumer" + NL + "This option may be used with the '--list' option only.";
    private static final String DELETE_OFFSETS_DOC = "Delete offsets of consumer group. Supports one consumer group at the time, and multiple topics.";
    private static final String VALIDATE_REGEX_DOC = "Validate that the syntax of the provided regular expression is valid according to the RE2 format.";
    final OptionSpec<String> bootstrapServerOpt;
    final OptionSpec<String> groupOpt;
    final OptionSpec<String> topicOpt;
    final OptionSpec<Void> allTopicsOpt;
    final OptionSpec<Void> listOpt;
    final OptionSpec<Void> describeOpt;
    final OptionSpec<Void> allGroupsOpt;
    final OptionSpec<Void> deleteOpt;
    final OptionSpec<Long> timeoutMsOpt;
    final OptionSpec<String> commandConfigOpt;
    final OptionSpec<Void> resetOffsetsOpt;
    final OptionSpec<Void> deleteOffsetsOpt;
    final OptionSpec<Void> dryRunOpt;
    final OptionSpec<Void> executeOpt;
    final OptionSpec<Void> exportOpt;
    final OptionSpec<Long> resetToOffsetOpt;
    final OptionSpec<String> resetFromFileOpt;
    final OptionSpec<String> resetToDatetimeOpt;
    final OptionSpec<String> resetByDurationOpt;
    final OptionSpec<Void> resetToEarliestOpt;
    final OptionSpec<Void> resetToLatestOpt;
    final OptionSpec<Void> resetToCurrentOpt;
    final OptionSpec<Long> resetShiftByOpt;
    final OptionSpec<Void> membersOpt;
    final OptionSpec<Void> verboseOpt;
    final OptionSpec<Void> offsetsOpt;
    final OptionSpec<String> stateOpt;
    final OptionSpec<String> typeOpt;
    final OptionSpec<String> validateRegexOpt;
    final Set<OptionSpec<?>> allGroupSelectionScopeOpts;
    final Set<OptionSpec<?>> allConsumerGroupLevelOpts;
    final Set<OptionSpec<?>> allResetOffsetScenarioOpts;
    final Set<OptionSpec<?>> allDeleteOffsetsOpts;

    public static ConsumerGroupCommandOptions fromArgs(String[] args) {
        ConsumerGroupCommandOptions opts = new ConsumerGroupCommandOptions(args);
        opts.checkArgs();
        return opts;
    }

    private ConsumerGroupCommandOptions(String[] args) {
        super(args);
        this.bootstrapServerOpt = this.parser.accepts("bootstrap-server", BOOTSTRAP_SERVER_DOC).withRequiredArg().describedAs("server to connect to").ofType(String.class);
        this.groupOpt = this.parser.accepts("group", GROUP_DOC).withRequiredArg().describedAs("consumer group").ofType(String.class);
        this.topicOpt = this.parser.accepts("topic", TOPIC_DOC).withRequiredArg().describedAs("topic").ofType(String.class);
        this.allTopicsOpt = this.parser.accepts("all-topics", ALL_TOPICS_DOC);
        this.listOpt = this.parser.accepts("list", LIST_DOC);
        this.describeOpt = this.parser.accepts("describe", DESCRIBE_DOC);
        this.allGroupsOpt = this.parser.accepts("all-groups", ALL_GROUPS_DOC);
        this.deleteOpt = this.parser.accepts("delete", DELETE_DOC);
        this.timeoutMsOpt = this.parser.accepts("timeout", TIMEOUT_MS_DOC).withRequiredArg().describedAs("timeout (ms)").ofType(Long.class).defaultsTo((Object)5000L, (Object[])new Long[0]);
        this.commandConfigOpt = this.parser.accepts("command-config", COMMAND_CONFIG_DOC).withRequiredArg().describedAs("command config property file").ofType(String.class);
        this.resetOffsetsOpt = this.parser.accepts("reset-offsets", RESET_OFFSETS_DOC);
        this.deleteOffsetsOpt = this.parser.accepts("delete-offsets", DELETE_OFFSETS_DOC);
        this.dryRunOpt = this.parser.accepts("dry-run", DRY_RUN_DOC);
        this.executeOpt = this.parser.accepts("execute", EXECUTE_DOC);
        this.exportOpt = this.parser.accepts("export", EXPORT_DOC);
        this.resetToOffsetOpt = this.parser.accepts("to-offset", RESET_TO_OFFSET_DOC).withRequiredArg().describedAs("offset").ofType(Long.class);
        this.resetFromFileOpt = this.parser.accepts("from-file", RESET_FROM_FILE_DOC).withRequiredArg().describedAs("path to CSV file").ofType(String.class);
        this.resetToDatetimeOpt = this.parser.accepts("to-datetime", RESET_TO_DATETIME_DOC).withRequiredArg().describedAs("datetime").ofType(String.class);
        this.resetByDurationOpt = this.parser.accepts("by-duration", RESET_BY_DURATION_DOC).withRequiredArg().describedAs("duration").ofType(String.class);
        this.resetToEarliestOpt = this.parser.accepts("to-earliest", RESET_TO_EARLIEST_DOC);
        this.resetToLatestOpt = this.parser.accepts("to-latest", RESET_TO_LATEST_DOC);
        this.resetToCurrentOpt = this.parser.accepts("to-current", RESET_TO_CURRENT_DOC);
        this.resetShiftByOpt = this.parser.accepts("shift-by", RESET_SHIFT_BY_DOC).withRequiredArg().describedAs("number-of-offsets").ofType(Long.class);
        this.membersOpt = this.parser.accepts("members", MEMBERS_DOC).availableIf(this.describeOpt, new OptionSpec[0]);
        this.verboseOpt = this.parser.accepts("verbose", VERBOSE_DOC).availableIf(this.describeOpt, new OptionSpec[0]);
        this.offsetsOpt = this.parser.accepts("offsets", OFFSETS_DOC).availableIf(this.describeOpt, new OptionSpec[0]);
        this.stateOpt = this.parser.accepts("state", STATE_DOC).availableIf(this.describeOpt, new OptionSpec[]{this.listOpt}).withOptionalArg().ofType(String.class);
        this.typeOpt = this.parser.accepts("type", TYPE_DOC).availableIf(this.listOpt, new OptionSpec[0]).withOptionalArg().ofType(String.class);
        this.validateRegexOpt = this.parser.accepts("validate-regex", VALIDATE_REGEX_DOC).withRequiredArg().describedAs("regex").ofType(String.class);
        this.allGroupSelectionScopeOpts = new HashSet<OptionSpec>(Arrays.asList(this.groupOpt, this.allGroupsOpt));
        this.allConsumerGroupLevelOpts = new HashSet<OptionSpec>(Arrays.asList(this.listOpt, this.describeOpt, this.deleteOpt, this.resetOffsetsOpt));
        this.allResetOffsetScenarioOpts = new HashSet<OptionSpec>(Arrays.asList(this.resetToOffsetOpt, this.resetShiftByOpt, this.resetToDatetimeOpt, this.resetByDurationOpt, this.resetToEarliestOpt, this.resetToLatestOpt, this.resetToCurrentOpt, this.resetFromFileOpt));
        this.allDeleteOffsetsOpts = new HashSet<OptionSpec>(Arrays.asList(this.groupOpt, this.topicOpt));
        this.options = this.parser.parse(args);
    }

    void checkArgs() {
        CommandLineUtils.maybePrintHelpOrVersion((CommandDefaultOptions)this, (String)"This tool helps to list all consumer groups, describe a consumer group, delete consumer group info, or reset consumer group offsets.");
        if (!this.options.has(this.validateRegexOpt)) {
            CommandLineUtils.checkRequiredArgs((OptionParser)this.parser, (OptionSet)this.options, (OptionSpec[])new OptionSpec[]{this.bootstrapServerOpt});
        }
        if (this.options.has(this.describeOpt)) {
            List<OptionSpec> mutuallyExclusiveOpts;
            if (!this.options.has(this.groupOpt) && !this.options.has(this.allGroupsOpt)) {
                CommandLineUtils.printUsageAndExit((OptionParser)this.parser, (String)("Option " + String.valueOf(this.describeOpt) + " takes one of these options: " + this.allGroupSelectionScopeOpts.stream().map(Object::toString).collect(Collectors.joining(", "))));
            }
            if ((mutuallyExclusiveOpts = Arrays.asList(this.membersOpt, this.offsetsOpt, this.stateOpt)).stream().mapToInt(o -> this.options.has(o) ? 1 : 0).sum() > 1) {
                CommandLineUtils.printUsageAndExit((OptionParser)this.parser, (String)("Option " + String.valueOf(this.describeOpt) + " takes at most one of these options: " + mutuallyExclusiveOpts.stream().map(Object::toString).collect(Collectors.joining(", "))));
            }
            if (this.options.has(this.stateOpt) && this.options.valueOf(this.stateOpt) != null) {
                CommandLineUtils.printUsageAndExit((OptionParser)this.parser, (String)("Option " + String.valueOf(this.describeOpt) + " does not take a value for " + String.valueOf(this.stateOpt)));
            }
        } else if (this.options.has(this.timeoutMsOpt)) {
            LOGGER.debug("Option " + String.valueOf(this.timeoutMsOpt) + " is applicable only when " + String.valueOf(this.describeOpt) + " is used.");
        }
        if (this.options.has(this.deleteOpt)) {
            if (!this.options.has(this.groupOpt) && !this.options.has(this.allGroupsOpt)) {
                CommandLineUtils.printUsageAndExit((OptionParser)this.parser, (String)("Option " + String.valueOf(this.deleteOpt) + " takes one of these options: " + this.allGroupSelectionScopeOpts.stream().map(Object::toString).collect(Collectors.joining(", "))));
            }
            if (this.options.has(this.topicOpt)) {
                CommandLineUtils.printUsageAndExit((OptionParser)this.parser, (String)"The consumer does not support topic-specific offset deletion from a consumer group.");
            }
        }
        if (!(!this.options.has(this.deleteOffsetsOpt) || this.options.has(this.groupOpt) && this.options.has(this.topicOpt))) {
            CommandLineUtils.printUsageAndExit((OptionParser)this.parser, (String)("Option " + String.valueOf(this.deleteOffsetsOpt) + " takes the following options: " + this.allDeleteOffsetsOpts.stream().map(Object::toString).collect(Collectors.joining(", "))));
        }
        if (this.options.has(this.resetOffsetsOpt)) {
            if (this.options.has(this.dryRunOpt) && this.options.has(this.executeOpt)) {
                CommandLineUtils.printUsageAndExit((OptionParser)this.parser, (String)("Option " + String.valueOf(this.resetOffsetsOpt) + " only accepts one of " + String.valueOf(this.executeOpt) + " and " + String.valueOf(this.dryRunOpt)));
            }
            if (!this.options.has(this.dryRunOpt) && !this.options.has(this.executeOpt)) {
                System.err.println("WARN: No action will be performed as the --execute option is missing. In a future major release, the default behavior of this command will be to prompt the user before executing the reset rather than doing a dry run. You should add the --dry-run option explicitly if you are scripting this command and want to keep the current default behavior without prompting.");
            }
            if (!this.options.has(this.groupOpt) && !this.options.has(this.allGroupsOpt)) {
                CommandLineUtils.printUsageAndExit((OptionParser)this.parser, (String)("Option " + String.valueOf(this.resetOffsetsOpt) + " takes one of these options: " + this.allGroupSelectionScopeOpts.stream().map(Object::toString).collect(Collectors.joining(", "))));
            }
            CommandLineUtils.checkInvalidArgs((OptionParser)this.parser, (OptionSet)this.options, this.resetToOffsetOpt, ToolsUtils.minus(this.allResetOffsetScenarioOpts, this.resetToOffsetOpt));
            CommandLineUtils.checkInvalidArgs((OptionParser)this.parser, (OptionSet)this.options, this.resetToDatetimeOpt, ToolsUtils.minus(this.allResetOffsetScenarioOpts, this.resetToDatetimeOpt));
            CommandLineUtils.checkInvalidArgs((OptionParser)this.parser, (OptionSet)this.options, this.resetByDurationOpt, ToolsUtils.minus(this.allResetOffsetScenarioOpts, this.resetByDurationOpt));
            CommandLineUtils.checkInvalidArgs((OptionParser)this.parser, (OptionSet)this.options, this.resetToEarliestOpt, ToolsUtils.minus(this.allResetOffsetScenarioOpts, this.resetToEarliestOpt));
            CommandLineUtils.checkInvalidArgs((OptionParser)this.parser, (OptionSet)this.options, this.resetToLatestOpt, ToolsUtils.minus(this.allResetOffsetScenarioOpts, this.resetToLatestOpt));
            CommandLineUtils.checkInvalidArgs((OptionParser)this.parser, (OptionSet)this.options, this.resetToCurrentOpt, ToolsUtils.minus(this.allResetOffsetScenarioOpts, this.resetToCurrentOpt));
            CommandLineUtils.checkInvalidArgs((OptionParser)this.parser, (OptionSet)this.options, this.resetShiftByOpt, ToolsUtils.minus(this.allResetOffsetScenarioOpts, this.resetShiftByOpt));
            CommandLineUtils.checkInvalidArgs((OptionParser)this.parser, (OptionSet)this.options, this.resetFromFileOpt, ToolsUtils.minus(this.allResetOffsetScenarioOpts, this.resetFromFileOpt));
        }
        CommandLineUtils.checkInvalidArgs((OptionParser)this.parser, (OptionSet)this.options, this.groupOpt, ToolsUtils.minus(this.allGroupSelectionScopeOpts, this.groupOpt));
        CommandLineUtils.checkInvalidArgs((OptionParser)this.parser, (OptionSet)this.options, this.groupOpt, ToolsUtils.minus(this.allConsumerGroupLevelOpts, this.describeOpt, this.deleteOpt, this.resetOffsetsOpt));
        CommandLineUtils.checkInvalidArgs((OptionParser)this.parser, (OptionSet)this.options, this.topicOpt, ToolsUtils.minus(this.allConsumerGroupLevelOpts, this.deleteOpt, this.resetOffsetsOpt));
    }
}

