/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools.consumer.group;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.DescribeShareGroupsOptions;
import org.apache.kafka.clients.admin.GroupListing;
import org.apache.kafka.clients.admin.ListGroupsOptions;
import org.apache.kafka.clients.admin.ListGroupsResult;
import org.apache.kafka.clients.admin.ListOffsetsResult;
import org.apache.kafka.clients.admin.OffsetSpec;
import org.apache.kafka.clients.admin.ShareGroupDescription;
import org.apache.kafka.clients.admin.ShareMemberAssignment;
import org.apache.kafka.clients.admin.ShareMemberDescription;
import org.apache.kafka.common.GroupState;
import org.apache.kafka.common.GroupType;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.util.CommandDefaultOptions;
import org.apache.kafka.server.util.CommandLineUtils;
import org.apache.kafka.tools.consumer.group.ShareGroupCommandOptions;

public class ShareGroupCommand {
    public static void main(String[] args) {
        ShareGroupCommandOptions opts = new ShareGroupCommandOptions(args);
        try {
            opts.checkArgs();
            CommandLineUtils.maybePrintHelpOrVersion((CommandDefaultOptions)opts, (String)"This tool helps to list all share groups, describe a share group, delete share group info, or reset share group offsets.");
            long actions = Stream.of(opts.listOpt, opts.describeOpt, opts.deleteOpt, opts.resetOffsetsOpt, opts.deleteOffsetsOpt).filter(arg_0 -> ((OptionSet)opts.options).has(arg_0)).count();
            if (actions != 1L) {
                CommandLineUtils.printUsageAndExit((OptionParser)opts.parser, (String)"Command must include exactly one action: --list, --describe, --delete, --reset-offsets, --delete-offsets.");
            }
            ShareGroupCommand.run(opts);
        }
        catch (OptionException e) {
            CommandLineUtils.printUsageAndExit((OptionParser)opts.parser, (String)e.getMessage());
        }
    }

    public static void run(ShareGroupCommandOptions opts) {
        try (ShareGroupService shareGroupService = new ShareGroupService(opts, Map.of());){
            if (opts.options.has(opts.listOpt)) {
                shareGroupService.listGroups();
            } else if (opts.options.has(opts.describeOpt)) {
                shareGroupService.describeGroups();
            } else {
                if (opts.options.has(opts.deleteOpt)) {
                    throw new UnsupportedOperationException("--delete option is not yet implemented");
                }
                if (opts.options.has(opts.resetOffsetsOpt)) {
                    throw new UnsupportedOperationException("--reset-offsets option is not yet implemented");
                }
                if (opts.options.has(opts.deleteOffsetsOpt)) {
                    throw new UnsupportedOperationException("--delete-offsets option is not yet implemented");
                }
            }
        }
        catch (IllegalArgumentException e) {
            CommandLineUtils.printUsageAndExit((OptionParser)opts.parser, (String)e.getMessage());
        }
        catch (Throwable e) {
            ShareGroupCommand.printError("Executing share group command failed due to " + e.getMessage(), Optional.of(e));
        }
    }

    static Set<GroupState> groupStatesFromString(String input) {
        Set<GroupState> parsedStates = Arrays.stream(input.split(",")).map(s -> GroupState.parse((String)s.trim())).collect(Collectors.toSet());
        Set validStates = GroupState.groupStatesForType((GroupType)GroupType.SHARE);
        if (!validStates.containsAll(parsedStates)) {
            throw new IllegalArgumentException("Invalid state list '" + input + "'. Valid states are: " + validStates.stream().map(GroupState::toString).collect(Collectors.joining(", ")));
        }
        return parsedStates;
    }

    public static void printError(String msg, Optional<Throwable> e) {
        System.out.println("\nError: " + msg);
        e.ifPresent(Throwable::printStackTrace);
    }

    static class ShareGroupService
    implements AutoCloseable {
        final ShareGroupCommandOptions opts;
        private final Admin adminClient;

        public ShareGroupService(ShareGroupCommandOptions opts, Map<String, String> configOverrides) {
            this.opts = opts;
            try {
                this.adminClient = this.createAdminClient(configOverrides);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public ShareGroupService(ShareGroupCommandOptions opts, Admin adminClient) {
            this.opts = opts;
            this.adminClient = adminClient;
        }

        public void listGroups() throws ExecutionException, InterruptedException {
            if (this.opts.options.has(this.opts.stateOpt)) {
                String stateValue = (String)this.opts.options.valueOf(this.opts.stateOpt);
                Set<GroupState> states = stateValue == null || stateValue.isEmpty() ? Set.of() : ShareGroupCommand.groupStatesFromString(stateValue);
                List<GroupListing> listings = this.listShareGroupsInStates(states);
                this.printGroupInfo(listings);
            } else {
                this.listShareGroups().forEach(System.out::println);
            }
        }

        List<String> listShareGroups() {
            try {
                ListGroupsResult result = this.adminClient.listGroups(((ListGroupsOptions)new ListGroupsOptions().timeoutMs(Integer.valueOf(((Long)this.opts.options.valueOf(this.opts.timeoutMsOpt)).intValue()))).withTypes(Set.of(GroupType.SHARE)));
                Collection listings = (Collection)result.all().get();
                return listings.stream().map(GroupListing::groupId).collect(Collectors.toList());
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }

        List<GroupListing> listShareGroupsInStates(Set<GroupState> states) throws ExecutionException, InterruptedException {
            ListGroupsResult result = this.adminClient.listGroups(((ListGroupsOptions)new ListGroupsOptions().timeoutMs(Integer.valueOf(((Long)this.opts.options.valueOf(this.opts.timeoutMsOpt)).intValue()))).withTypes(Set.of(GroupType.SHARE)).inGroupStates(states));
            return new ArrayList<GroupListing>((Collection)result.all().get());
        }

        private void printGroupInfo(List<GroupListing> groups) {
            int maxGroupLen = 15;
            for (GroupListing group : groups) {
                maxGroupLen = Math.max(maxGroupLen, group.groupId().length());
            }
            System.out.printf("%" + -maxGroupLen + "s %s\n", "GROUP", "STATE");
            for (GroupListing group : groups) {
                String groupId = group.groupId();
                String state = group.groupState().orElse(GroupState.UNKNOWN).toString();
                System.out.printf("%" + -maxGroupLen + "s %s\n", groupId, state);
            }
        }

        public static boolean maybePrintEmptyGroupState(String group, GroupState state, int numRows) {
            if (state == GroupState.DEAD) {
                ShareGroupCommand.printError("Share group '" + group + "' does not exist.", Optional.empty());
            } else if (state == GroupState.EMPTY) {
                System.err.println("\nShare group '" + group + "' has no active members.");
            }
            return !state.equals((Object)GroupState.DEAD) && numRows > 0;
        }

        public void describeGroups() throws ExecutionException, InterruptedException {
            List groupIds;
            List list = groupIds = this.opts.options.has(this.opts.allGroupsOpt) ? this.listShareGroups() : this.opts.options.valuesOf(this.opts.groupOpt);
            if (this.opts.options.has(this.opts.membersOpt)) {
                TreeMap<String, ShareGroupDescription> members = this.collectGroupsDescription(groupIds);
                this.printMembers(members, this.opts.options.has(this.opts.verboseOpt));
            } else if (this.opts.options.has(this.opts.stateOpt)) {
                TreeMap<String, ShareGroupDescription> states = this.collectGroupsDescription(groupIds);
                this.printStates(states, this.opts.options.has(this.opts.verboseOpt));
            } else {
                TreeMap<String, Map.Entry<ShareGroupDescription, Collection<SharePartitionOffsetInformation>>> offsets = this.collectGroupsOffsets(groupIds);
                this.printOffsets(offsets);
            }
        }

        Map<String, ShareGroupDescription> describeShareGroups(Collection<String> groupIds) throws ExecutionException, InterruptedException {
            HashMap<String, ShareGroupDescription> res = new HashMap<String, ShareGroupDescription>();
            Map stringKafkaFutureMap = this.adminClient.describeShareGroups(groupIds, (DescribeShareGroupsOptions)new DescribeShareGroupsOptions().timeoutMs(Integer.valueOf(((Long)this.opts.options.valueOf(this.opts.timeoutMsOpt)).intValue()))).describedGroups();
            for (Map.Entry e : stringKafkaFutureMap.entrySet()) {
                res.put((String)e.getKey(), (ShareGroupDescription)((KafkaFuture)e.getValue()).get());
            }
            return res;
        }

        TreeMap<String, ShareGroupDescription> collectGroupsDescription(Collection<String> groupIds) throws ExecutionException, InterruptedException {
            Map<String, ShareGroupDescription> shareGroups = this.describeShareGroups(groupIds);
            TreeMap<String, ShareGroupDescription> res = new TreeMap<String, ShareGroupDescription>();
            shareGroups.forEach(res::put);
            return res;
        }

        TreeMap<String, Map.Entry<ShareGroupDescription, Collection<SharePartitionOffsetInformation>>> collectGroupsOffsets(Collection<String> groupIds) throws ExecutionException, InterruptedException {
            Map<String, ShareGroupDescription> shareGroups = this.describeShareGroups(groupIds);
            TreeMap<String, Map.Entry<ShareGroupDescription, Collection<SharePartitionOffsetInformation>>> groupOffsets = new TreeMap<String, Map.Entry<ShareGroupDescription, Collection<SharePartitionOffsetInformation>>>();
            shareGroups.forEach((groupId, shareGroup) -> {
                HashSet allTp = new HashSet();
                for (ShareMemberDescription memberDescription : shareGroup.members()) {
                    allTp.addAll(memberDescription.assignment().topicPartitions());
                }
                HashMap<TopicPartition, OffsetSpec> earliest = new HashMap<TopicPartition, OffsetSpec>();
                HashMap<TopicPartition, OffsetSpec> latest = new HashMap<TopicPartition, OffsetSpec>();
                for (TopicPartition tp : allTp) {
                    earliest.put(tp, OffsetSpec.earliest());
                    latest.put(tp, OffsetSpec.latest());
                }
                try {
                    Map earliestResult = (Map)this.adminClient.listOffsets(earliest).all().get();
                    Map latestResult = (Map)this.adminClient.listOffsets(latest).all().get();
                    HashSet<SharePartitionOffsetInformation> partitionOffsets = new HashSet<SharePartitionOffsetInformation>();
                    for (Map.Entry tp : earliestResult.entrySet()) {
                        SharePartitionOffsetInformation partitionOffsetInfo = new SharePartitionOffsetInformation((String)groupId, ((TopicPartition)tp.getKey()).topic(), ((TopicPartition)tp.getKey()).partition(), ((ListOffsetsResult.ListOffsetsResultInfo)latestResult.get(tp.getKey())).offset() - ((ListOffsetsResult.ListOffsetsResultInfo)earliestResult.get(tp.getKey())).offset());
                        partitionOffsets.add(partitionOffsetInfo);
                    }
                    groupOffsets.put((String)groupId, new AbstractMap.SimpleImmutableEntry((ShareGroupDescription)shareGroup, partitionOffsets));
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException(e);
                }
            });
            return groupOffsets;
        }

        private void printOffsets(TreeMap<String, Map.Entry<ShareGroupDescription, Collection<SharePartitionOffsetInformation>>> offsets) {
            offsets.forEach((groupId, tuple) -> {
                ShareGroupDescription description = (ShareGroupDescription)tuple.getKey();
                Collection offsetsInfo = (Collection)tuple.getValue();
                if (ShareGroupService.maybePrintEmptyGroupState(groupId, description.groupState(), offsetsInfo.size())) {
                    String fmt = ShareGroupService.printOffsetFormat(groupId, offsetsInfo);
                    System.out.printf(fmt, "GROUP", "TOPIC", "PARTITION", "START-OFFSET");
                    for (SharePartitionOffsetInformation info : offsetsInfo) {
                        System.out.printf(fmt, groupId, info.topic, info.partition, info.offset);
                    }
                    System.out.println();
                }
            });
        }

        private static String printOffsetFormat(String groupId, Collection<SharePartitionOffsetInformation> offsetsInfo) {
            int groupLen = Math.max(15, groupId.length());
            int maxTopicLen = 15;
            for (SharePartitionOffsetInformation info : offsetsInfo) {
                maxTopicLen = Math.max(maxTopicLen, info.topic.length());
            }
            return "\n%" + -groupLen + "s %" + -maxTopicLen + "s %-10s %s";
        }

        private void printStates(Map<String, ShareGroupDescription> descriptions, boolean verbose) {
            descriptions.forEach((groupId, description) -> {
                ShareGroupService.maybePrintEmptyGroupState(groupId, description.groupState(), 1);
                int groupLen = Math.max(15, groupId.length());
                String coordinator = description.coordinator().host() + ":" + description.coordinator().port() + "  (" + description.coordinator().idString() + ")";
                int coordinatorLen = Math.max(25, coordinator.length());
                if (verbose) {
                    String fmt = "\n%" + -groupLen + "s %" + -coordinatorLen + "s %-15s %-12s %-17s %s";
                    System.out.printf(fmt, "GROUP", "COORDINATOR (ID)", "STATE", "GROUP-EPOCH", "ASSIGNMENT-EPOCH", "#MEMBERS");
                    System.out.printf(fmt, groupId, coordinator, description.groupState().toString(), description.groupEpoch(), description.targetAssignmentEpoch(), description.members().size());
                } else {
                    String fmt = "\n%" + -groupLen + "s %" + -coordinatorLen + "s %-15s %s";
                    System.out.printf(fmt, "GROUP", "COORDINATOR (ID)", "STATE", "#MEMBERS");
                    System.out.printf(fmt, groupId, coordinator, description.groupState().toString(), description.members().size());
                }
                System.out.println();
            });
        }

        private void printMembers(TreeMap<String, ShareGroupDescription> descriptions, boolean verbose) {
            descriptions.forEach((groupId, description) -> {
                int groupLen = Math.max(15, groupId.length());
                int maxConsumerIdLen = 15;
                int maxHostLen = 15;
                int maxClientIdLen = 15;
                Collection members = description.members();
                if (ShareGroupService.maybePrintEmptyGroupState(groupId, description.groupState(), description.members().size())) {
                    for (ShareMemberDescription member : members) {
                        maxConsumerIdLen = Math.max(maxConsumerIdLen, member.consumerId().length());
                        maxHostLen = Math.max(maxHostLen, member.host().length());
                        maxClientIdLen = Math.max(maxClientIdLen, member.clientId().length());
                    }
                    if (verbose) {
                        fmt = "\n%" + -groupLen + "s %" + -maxConsumerIdLen + "s %" + -maxHostLen + "s %" + -maxClientIdLen + "s %-13s %s";
                        System.out.printf(fmt, "GROUP", "CONSUMER-ID", "HOST", "CLIENT-ID", "MEMBER-EPOCH", "ASSIGNMENT");
                        for (ShareMemberDescription member : members) {
                            System.out.printf(fmt, groupId, member.consumerId(), member.host(), member.clientId(), member.memberEpoch(), this.getAssignmentString(member.assignment()));
                        }
                    } else {
                        fmt = "\n%" + -groupLen + "s %" + -maxConsumerIdLen + "s %" + -maxHostLen + "s %" + -maxClientIdLen + "s %s";
                        System.out.printf(fmt, "GROUP", "CONSUMER-ID", "HOST", "CLIENT-ID", "ASSIGNMENT");
                        for (ShareMemberDescription member : members) {
                            System.out.printf(fmt, groupId, member.consumerId(), member.host(), member.clientId(), this.getAssignmentString(member.assignment()));
                        }
                    }
                    System.out.println();
                }
            });
        }

        private String getAssignmentString(ShareMemberAssignment assignment) {
            HashMap grouped = new HashMap();
            assignment.topicPartitions().forEach(tp -> grouped.computeIfAbsent(tp.topic(), key -> new ArrayList()).add(tp));
            return grouped.entrySet().stream().map(entry -> {
                String topicName = (String)entry.getKey();
                List topicPartitions = (List)entry.getValue();
                return topicPartitions.stream().map(TopicPartition::partition).map(Object::toString).sorted().collect(Collectors.joining(",", topicName + ":", ""));
            }).sorted().collect(Collectors.joining(";"));
        }

        @Override
        public void close() {
            this.adminClient.close();
        }

        protected Admin createAdminClient(Map<String, String> configOverrides) throws IOException {
            Properties props = this.opts.options.has(this.opts.commandConfigOpt) ? Utils.loadProps((String)((String)this.opts.options.valueOf(this.opts.commandConfigOpt))) : new Properties();
            props.put("bootstrap.servers", this.opts.options.valueOf(this.opts.bootstrapServerOpt));
            props.putAll(configOverrides);
            return Admin.create((Properties)props);
        }
    }

    static class SharePartitionOffsetInformation {
        final String group;
        final String topic;
        final int partition;
        final long offset;

        SharePartitionOffsetInformation(String group, String topic, int partition, long offset) {
            this.group = group;
            this.topic = topic;
            this.partition = partition;
            this.offset = offset;
        }
    }
}

