/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools.consumer.group.share;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.MessageFormatter;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.coordinator.share.generated.CoordinatorRecordType;
import org.apache.kafka.coordinator.share.generated.ShareSnapshotKey;
import org.apache.kafka.coordinator.share.generated.ShareSnapshotKeyJsonConverter;
import org.apache.kafka.coordinator.share.generated.ShareSnapshotValue;
import org.apache.kafka.coordinator.share.generated.ShareSnapshotValueJsonConverter;
import org.apache.kafka.coordinator.share.generated.ShareUpdateKey;
import org.apache.kafka.coordinator.share.generated.ShareUpdateKeyJsonConverter;
import org.apache.kafka.coordinator.share.generated.ShareUpdateValue;
import org.apache.kafka.coordinator.share.generated.ShareUpdateValueJsonConverter;

public class ShareGroupStateMessageFormatter
implements MessageFormatter {
    private static final String VERSION = "version";
    private static final String DATA = "data";
    private static final String KEY = "key";
    private static final String VALUE = "value";
    private static final String UNKNOWN = "unknown";

    public void writeTo(ConsumerRecord<byte[], byte[]> consumerRecord, PrintStream output) {
        ObjectNode json = new ObjectNode(JsonNodeFactory.instance);
        byte[] key = (byte[])consumerRecord.key();
        short keyVersion = -1;
        if (Objects.nonNull(key)) {
            keyVersion = ByteBuffer.wrap(key).getShort();
            JsonNode dataNode = this.readToKeyJson(ByteBuffer.wrap(key), keyVersion);
            if (dataNode instanceof NullNode) {
                return;
            }
            json.putObject(KEY).put(VERSION, keyVersion).set(DATA, dataNode);
        } else {
            json.set(KEY, (JsonNode)NullNode.getInstance());
        }
        byte[] value = (byte[])consumerRecord.value();
        if (Objects.nonNull(value)) {
            short valueVersion = ByteBuffer.wrap(value).getShort();
            JsonNode dataNode = this.readToValueJson(ByteBuffer.wrap(value), keyVersion, valueVersion);
            json.putObject(VALUE).put(VERSION, valueVersion).set(DATA, dataNode);
        } else {
            json.set(VALUE, (JsonNode)NullNode.getInstance());
        }
        try {
            output.write(json.toString().getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private JsonNode readToKeyJson(ByteBuffer byteBuffer, short version) {
        return this.readToSnapshotMessageKey(byteBuffer).map(logKey -> this.transferKeyMessageToJsonNode((ApiMessage)logKey, version)).orElseGet(() -> new TextNode(UNKNOWN));
    }

    private Optional<ApiMessage> readToSnapshotMessageKey(ByteBuffer byteBuffer) {
        short version = byteBuffer.getShort();
        try {
            switch (CoordinatorRecordType.fromId((short)version)) {
                case SHARE_SNAPSHOT: {
                    return Optional.of(new ShareSnapshotKey((Readable)new ByteBufferAccessor(byteBuffer), version));
                }
                case SHARE_UPDATE: {
                    return Optional.of(new ShareUpdateKey((Readable)new ByteBufferAccessor(byteBuffer), version));
                }
            }
            return Optional.empty();
        }
        catch (UnsupportedVersionException ex) {
            return Optional.empty();
        }
    }

    private JsonNode transferKeyMessageToJsonNode(ApiMessage logKey, short keyVersion) {
        if (logKey instanceof ShareSnapshotKey) {
            return ShareSnapshotKeyJsonConverter.write((ShareSnapshotKey)((ShareSnapshotKey)logKey), (short)keyVersion);
        }
        if (logKey instanceof ShareUpdateKey) {
            return ShareUpdateKeyJsonConverter.write((ShareUpdateKey)((ShareUpdateKey)logKey), (short)keyVersion);
        }
        return new TextNode(UNKNOWN);
    }

    protected JsonNode readToValueJson(ByteBuffer byteBuffer, short keyVersion, short valueVersion) {
        return this.readToSnapshotMessageValue(byteBuffer, keyVersion).map(logValue -> this.transferValueMessageToJsonNode((ApiMessage)logValue, valueVersion)).orElseGet(() -> new TextNode(UNKNOWN));
    }

    private JsonNode transferValueMessageToJsonNode(ApiMessage logValue, short version) {
        if (logValue instanceof ShareSnapshotValue) {
            return ShareSnapshotValueJsonConverter.write((ShareSnapshotValue)((ShareSnapshotValue)logValue), (short)version);
        }
        if (logValue instanceof ShareUpdateValue) {
            return ShareUpdateValueJsonConverter.write((ShareUpdateValue)((ShareUpdateValue)logValue), (short)version);
        }
        return new TextNode(UNKNOWN);
    }

    private Optional<ApiMessage> readToSnapshotMessageValue(ByteBuffer byteBuffer, short keyVersion) {
        short version = byteBuffer.getShort();
        try {
            switch (CoordinatorRecordType.fromId((short)keyVersion)) {
                case SHARE_SNAPSHOT: {
                    return Optional.of(new ShareSnapshotValue((Readable)new ByteBufferAccessor(byteBuffer), version));
                }
                case SHARE_UPDATE: {
                    return Optional.of(new ShareUpdateValue((Readable)new ByteBufferAccessor(byteBuffer), version));
                }
            }
            return Optional.empty();
        }
        catch (UnsupportedVersionException ex) {
            return Optional.empty();
        }
    }
}

