/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools.tenantplacementadvisor;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.kafka.tools.tenantplacementadvisor.Cell;
import org.apache.kafka.tools.tenantplacementadvisor.CellLoadResolver;
import org.apache.kafka.tools.tenantplacementadvisor.PerMetricCellLoadResolver;
import org.apache.kafka.tools.tenantplacementadvisor.Plan;
import org.apache.kafka.tools.tenantplacementadvisor.Tenant;
import org.apache.kafka.tools.tenantplacementadvisor.TenantLoad;
import org.apache.kafka.tools.tenantplacementadvisor.TenantLoadFunction;

public class TenantPlacementAdvisor {
    private final Map<Cell, Set<Tenant>> cellToTenantPlacement;
    private final CellLoadResolver cellLoadResolver;
    private final TenantLoadFunction tenantLoadFunction;

    public TenantPlacementAdvisor(Map<Integer, Set<String>> cellToTenantIdPlacement, TenantLoadFunction tenantLoadFunction, CellLoadResolver cellLoadResolver, List<Predicate<Cell>> cellFilters, List<Predicate<Tenant>> tenantFilters) {
        this.tenantLoadFunction = tenantLoadFunction;
        this.cellLoadResolver = cellLoadResolver;
        HashMap<Cell, Set<Tenant>> cellToTenantPlacement = new HashMap<Cell, Set<Tenant>>();
        for (Integer cellId : cellToTenantIdPlacement.keySet()) {
            if (this.reduceFilter(cellFilters).test(new Cell(cellId))) continue;
            Set tenantsInCell = cellToTenantIdPlacement.get(cellId).stream().map(Tenant::new).filter(this.reduceFilter(tenantFilters).negate()).collect(Collectors.toSet());
            cellToTenantPlacement.put(new Cell(cellId), tenantsInCell);
        }
        this.cellToTenantPlacement = cellToTenantPlacement;
        cellLoadResolver.initialize(this.cellToTenantPlacement.keySet().stream().map(Cell::getCellID).collect(Collectors.toSet()));
    }

    public Plan getPlan(Cell sourceCell, double goalLoad) throws CellLoadResolver.MismatchedMetricsException {
        Map<Cell, Set<TenantLoad>> cellToTenantLoads;
        int sourceCellId = sourceCell.getCellID();
        double sourceCellLoad = this.cellLoadResolver.resolveCellLoadFromTenants(sourceCellId, (cellToTenantLoads = this.cellToTenantPlacement.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Set)entry.getValue()).stream().map(tenant -> this.tenantLoadFunction.getTenantLoad(tenant.getTenantID()).get()).collect(Collectors.toSet())))).get(sourceCell));
        if (sourceCellLoad <= goalLoad) {
            throw new RuntimeException(String.format("Source cell load is determined to be <= provided goalLoad. Source cell load is calculated as %.2f, goalLoad is %.2f.", sourceCellLoad, goalLoad));
        }
        double sourceLoadBeforeRebalance = sourceCellLoad;
        Map<Cell, Set<TenantLoad>> cellToTenantLoadsBeforeRebalance = this.deepCopyMap(cellToTenantLoads);
        LinkedList<TenantLoad> sourceCellTenantQueue = new LinkedList<TenantLoad>(cellToTenantLoads.get(sourceCell));
        HashSet<Tenant> tenantsTried = new HashSet<Tenant>();
        while (sourceCellLoad > goalLoad && !tenantsTried.contains(((TenantLoad)sourceCellTenantQueue.peek()).getTenant())) {
            TenantLoad tenantToTryMove = (TenantLoad)sourceCellTenantQueue.remove();
            tenantsTried.add(tenantToTryMove.getTenant());
            CellLoad lowestLoadAfterTenantPlacement = new CellLoad(null, Double.MAX_VALUE);
            for (Cell cellToConsiderTenantPlacement : cellToTenantLoads.keySet()) {
                if (cellToConsiderTenantPlacement.equals(sourceCell)) continue;
                Set<TenantLoad> candidateCellTenantLoads = cellToTenantLoads.get(cellToConsiderTenantPlacement);
                candidateCellTenantLoads.add(tenantToTryMove);
                CellLoad candidateCellLoad = new CellLoad(cellToConsiderTenantPlacement, this.cellLoadResolver.resolveCellLoadFromTenants(cellToConsiderTenantPlacement.getCellID(), candidateCellTenantLoads));
                if (candidateCellLoad.totalLoad < lowestLoadAfterTenantPlacement.totalLoad) {
                    lowestLoadAfterTenantPlacement = candidateCellLoad;
                }
                candidateCellTenantLoads.remove(tenantToTryMove);
            }
            if (lowestLoadAfterTenantPlacement.totalLoad > 1.0) {
                sourceCellTenantQueue.add(tenantToTryMove);
                continue;
            }
            cellToTenantLoads.get(lowestLoadAfterTenantPlacement.cell).add(tenantToTryMove);
            sourceCellLoad = this.cellLoadResolver.resolveCellLoadFromTenants(sourceCellId, sourceCellTenantQueue);
        }
        cellToTenantLoads.put(sourceCell, new HashSet(sourceCellTenantQueue));
        Map<Tenant, Cell> tenantMovements = this.getTenantMovements(cellToTenantLoadsBeforeRebalance, cellToTenantLoads);
        if (this.cellLoadResolver instanceof PerMetricCellLoadResolver) {
            return new Plan(tenantMovements, sourceLoadBeforeRebalance - sourceCellLoad, this.computePerMetricCellLoads(cellToTenantLoadsBeforeRebalance), this.computePerMetricCellLoads(cellToTenantLoads));
        }
        return new Plan(tenantMovements, sourceLoadBeforeRebalance - sourceCellLoad, this.computeCellLoads(cellToTenantLoadsBeforeRebalance), this.computeCellLoads(cellToTenantLoads));
    }

    private <E> Predicate<E> reduceFilter(Collection<Predicate<E>> inp) {
        return inp.stream().reduce(e -> false, Predicate::or);
    }

    private Map<Cell, CellLoad> computeCellLoads(Map<Cell, Set<TenantLoad>> cellToTenantLoads) {
        return cellToTenantLoads.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            try {
                return new CellLoad((Cell)entry.getKey(), this.cellLoadResolver.resolveCellLoadFromTenants(((Cell)entry.getKey()).getCellID(), (Collection)entry.getValue()));
            }
            catch (CellLoadResolver.MismatchedMetricsException e) {
                throw new RuntimeException(e);
            }
        }));
    }

    private Map<Cell, CellLoad> computePerMetricCellLoads(Map<Cell, Set<TenantLoad>> cellToTenantLoads) {
        return cellToTenantLoads.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            Cell cell = (Cell)entry.getKey();
            try {
                return new CellLoad(cell, this.cellLoadResolver.resolveCellLoadFromTenants(cell.getCellID(), (Collection)entry.getValue()), ((PerMetricCellLoadResolver)this.cellLoadResolver).resolvePerMetricCellLoadFromTenants(cell.getCellID(), (Collection)entry.getValue()));
            }
            catch (CellLoadResolver.MismatchedMetricsException e) {
                throw new RuntimeException(e);
            }
        }));
    }

    private <K, V> Map<K, Set<V>> deepCopyMap(Map<K, Set<V>> mapToCopy) {
        return mapToCopy.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new HashSet((Collection)entry.getValue())));
    }

    private Map<Tenant, Cell> getTenantMovements(Map<Cell, Set<TenantLoad>> before, Map<Cell, Set<TenantLoad>> after) {
        if (!before.keySet().equals(after.keySet())) {
            throw new IllegalStateException("Unexpected state in TenantPlacementAdvisor: keysets representing cells in PKC should be consistent before and after placements");
        }
        HashMap<Tenant, Cell> movements = new HashMap<Tenant, Cell>();
        for (Map.Entry<Cell, Set<TenantLoad>> entry : after.entrySet()) {
            Cell cell = entry.getKey();
            HashSet tenantLoads = new HashSet(entry.getValue());
            tenantLoads.removeAll((Collection)before.get(cell));
            for (TenantLoad load : tenantLoads) {
                movements.put(load.getTenant(), cell);
            }
        }
        return movements;
    }

    public static class CellLoad
    implements Comparable<CellLoad> {
        Cell cell;
        double totalLoad;
        Optional<Map<String, Double>> perMetricLoads = Optional.empty();

        public CellLoad(Cell cell, double totalLoad) {
            this.cell = cell;
            this.totalLoad = totalLoad;
        }

        public CellLoad(Cell cell, double totalLoad, Map<String, Double> perMetricLoads) {
            this(cell, totalLoad);
            this.perMetricLoads = Optional.of(perMetricLoads);
        }

        @Override
        public int compareTo(CellLoad other) {
            return Double.compare(this.totalLoad, other.totalLoad);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CellLoad)) {
                return false;
            }
            CellLoad cellLoad = (CellLoad)o;
            if (Double.compare(cellLoad.totalLoad, this.totalLoad) != 0) {
                return false;
            }
            return this.cell.equals(cellLoad.cell);
        }

        public int hashCode() {
            int result = this.cell.hashCode();
            long temp = Double.doubleToLongBits(this.totalLoad);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            return result;
        }

        public String toString() {
            return String.format("CellLoad{%d}", this.cell.getCellID());
        }

        public Cell getCell() {
            return this.cell;
        }

        public double getTotalLoad() {
            return this.totalLoad;
        }

        public Optional<Map<String, Double>> getPerMetricLoads() {
            return this.perMetricLoads;
        }
    }
}

