/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client.rest.entities.requests;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.client.rest.entities.Metadata;
import io.confluent.kafka.schemaregistry.client.rest.entities.RuleSet;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaTags;
import io.confluent.kafka.schemaregistry.utils.JacksonMapper;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
@io.swagger.v3.oas.annotations.media.Schema(description="Schema register request")
public class RegisterSchemaRequest {
    private Integer version;
    private Integer id;
    private String schemaType;
    private List<SchemaReference> references = null;
    private Metadata metadata = null;
    private RuleSet ruleSet = null;
    private String schema;
    private List<SchemaTags> schemaTagsToAdd;
    private List<SchemaTags> schemaTagsToRemove;
    private Boolean propagateSchemaTags;

    public RegisterSchemaRequest() {
    }

    public RegisterSchemaRequest(ParsedSchema schema) {
        this.schemaType = schema.schemaType();
        this.references = schema.references();
        this.metadata = schema.metadata();
        this.ruleSet = schema.ruleSet();
        this.schema = schema.canonicalString();
    }

    public RegisterSchemaRequest(Schema schema) {
        this.version = schema.getVersion();
        this.id = schema.getId();
        this.schemaType = schema.getSchemaType();
        this.references = schema.getReferences();
        this.metadata = schema.getMetadata();
        this.ruleSet = schema.getRuleSet();
        this.schema = schema.getSchema();
    }

    public static RegisterSchemaRequest fromJson(String json) throws IOException {
        return (RegisterSchemaRequest)JacksonMapper.INSTANCE.readValue(json, RegisterSchemaRequest.class);
    }

    @io.swagger.v3.oas.annotations.media.Schema(description="Version number")
    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    public void setVersion(Integer version) {
        this.version = version;
    }

    @io.swagger.v3.oas.annotations.media.Schema(description="Globally unique identifier of the schema")
    @JsonProperty(value="id")
    public Integer getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setId(Integer id) {
        this.id = id;
    }

    @io.swagger.v3.oas.annotations.media.Schema(description="Schema type")
    @JsonProperty(value="schemaType")
    public String getSchemaType() {
        return this.schemaType;
    }

    @JsonProperty(value="schemaType")
    public void setSchemaType(String schemaType) {
        this.schemaType = schemaType;
    }

    @io.swagger.v3.oas.annotations.media.Schema(description="References to other schemas")
    @JsonProperty(value="references")
    public List<SchemaReference> getReferences() {
        return this.references;
    }

    @JsonProperty(value="references")
    public void setReferences(List<SchemaReference> references) {
        this.references = references;
    }

    @io.swagger.v3.oas.annotations.media.Schema(description="User-defined metadata")
    @JsonProperty(value="metadata")
    public Metadata getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    @io.swagger.v3.oas.annotations.media.Schema(description="Schema rule set")
    @JsonProperty(value="ruleSet")
    public RuleSet getRuleSet() {
        return this.ruleSet;
    }

    @JsonProperty(value="ruleSet")
    public void setRuleSet(RuleSet ruleSet) {
        this.ruleSet = ruleSet;
    }

    @io.swagger.v3.oas.annotations.media.Schema(description="Schema definition string")
    @JsonProperty(value="schema")
    public String getSchema() {
        return this.schema;
    }

    @JsonProperty(value="schema")
    public void setSchema(String schema) {
        this.schema = schema;
    }

    @JsonProperty(value="schemaTagsToAdd")
    public List<SchemaTags> getSchemaTagsToAdd() {
        return this.schemaTagsToAdd;
    }

    @JsonProperty(value="schemaTagsToAdd")
    public void setSchemaTagsToAdd(List<SchemaTags> schemaTagsToAdd) {
        this.schemaTagsToAdd = schemaTagsToAdd;
    }

    @JsonProperty(value="schemaTagsToRemove")
    public List<SchemaTags> getSchemaTagsToRemove() {
        return this.schemaTagsToRemove;
    }

    @JsonProperty(value="schemaTagsToRemove")
    public void setSchemaTagsToRemove(List<SchemaTags> schemaTagsToRemove) {
        this.schemaTagsToRemove = schemaTagsToRemove;
    }

    @JsonProperty(value="propagateSchemaTags")
    public Boolean isPropagateSchemaTags() {
        return this.propagateSchemaTags;
    }

    @JsonProperty(value="propagateSchemaTags")
    public void setPropagateSchemaTags(Boolean propagateSchemaTags) {
        this.propagateSchemaTags = propagateSchemaTags;
    }

    @JsonIgnore
    public boolean hasSchemaTagsToAddOrRemove() {
        return this.schemaTagsToAdd != null && !this.schemaTagsToAdd.isEmpty() || this.schemaTagsToRemove != null && !this.schemaTagsToRemove.isEmpty();
    }

    @JsonIgnore
    public boolean doPropagateSchemaTags() {
        return Boolean.TRUE.equals(this.propagateSchemaTags);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegisterSchemaRequest that = (RegisterSchemaRequest)o;
        return Objects.equals(this.version, that.version) && Objects.equals(this.id, that.id) && Objects.equals(this.schemaType, that.schemaType) && Objects.equals(this.references, that.references) && Objects.equals(this.metadata, that.metadata) && Objects.equals(this.ruleSet, that.ruleSet) && Objects.equals(this.schema, that.schema) && Objects.equals(this.schemaTagsToAdd, that.schemaTagsToAdd) && Objects.equals(this.schemaTagsToRemove, that.schemaTagsToRemove) && Objects.equals(this.propagateSchemaTags, that.propagateSchemaTags);
    }

    public int hashCode() {
        return Objects.hash(this.schemaType, this.references, this.metadata, this.ruleSet, this.version, this.id, this.schema, this.schemaTagsToAdd, this.schemaTagsToRemove, this.propagateSchemaTags);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("{");
        if (this.version != null) {
            buf.append("version=").append(this.version).append(", ");
        }
        if (this.id != null) {
            buf.append("id=").append(this.id).append(", ");
        }
        buf.append("schemaType=").append(this.schemaType).append(", ");
        buf.append("references=").append(this.references).append(", ");
        buf.append("metadata=").append(this.metadata).append(", ");
        buf.append("ruleSet=").append(this.ruleSet).append(", ");
        buf.append("schema=").append(this.schema).append(", ");
        buf.append("schemaTagsToAdd=").append(this.schemaTagsToAdd).append(", ");
        buf.append("schemaTagsToRemove=").append(this.schemaTagsToRemove).append(", ");
        buf.append("propagateSchemaTags=").append(this.propagateSchemaTags).append("}");
        return buf.toString();
    }

    public String toJson() throws IOException {
        return JacksonMapper.INSTANCE.writeValueAsString((Object)this);
    }
}

