/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.resourcemanager.api.client;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.confluent.resourcemanager.api.client.ClientImpl;
import io.confluent.resourcemanager.api.client.GroupVersionResource;
import io.confluent.resourcemanager.api.client.Request;
import io.confluent.resourcemanager.api.model.HasMetadata;
import io.confluent.resourcemanager.api.model.ObjectList;
import io.confluent.resourcemanager.api.model.location.Location;
import io.confluent.resourcemanager.api.model.scope.Scoping;
import io.confluent.resourcemanager.api.openapi.Adapter;
import io.confluent.resourcemanager.protobuf.apis.meta.v1.ScopeAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import okhttp3.OkHttpClient;

public final class ListRequest<T extends HasMetadata>
extends Request<ObjectList<T>> {
    ListRequest(String baseUrl, OkHttpClient httpClient, Class<T> objClass) {
        this(baseUrl, httpClient, ClientImpl.OBJECT_MAPPER.constructType(objClass), HasMetadata.getGVR(objClass).orElseThrow(), Location.Default(), HasMetadata.getScoping(objClass).orElseThrow(), ClientImpl.OBJECT_MAPPER.getTypeFactory());
        this.kind = HasMetadata.getKind(objClass);
    }

    public static <U, V extends Adapter<U>> ListRequest<V> fromAdapter(String baseUrl, OkHttpClient httpClient, Adapter<?> adapter) {
        ListRequest req = new ListRequest(baseUrl, httpClient, adapter.getJavaType(), adapter.getGroupVersionResource(), Location.Default(), adapter.getScoping(), ClientImpl.OBJECT_MAPPER.getTypeFactory());
        req.kind = adapter.getKind();
        return req;
    }

    private ListRequest(String baseUrl, OkHttpClient httpClient, JavaType elementType, GroupVersionResource gvr, Location location, Scoping scoping, TypeFactory typeFactory) {
        super(baseUrl, httpClient, typeFactory.constructParametricType(ObjectList.class, new JavaType[]{elementType}), gvr, Objects.requireNonNull(location), scoping, new ArrayList<ScopeAttribute>());
    }

    public ListRequest<T> location(Location location) {
        this.location = Objects.requireNonNull(location);
        return this;
    }

    public ListRequest<T> scope(List<ScopeAttribute> scope) {
        this.scope = Objects.requireNonNull(scope);
        return this;
    }

    public ListRequest<T> labelSelector(String labelSelector) {
        this.urlBuilder.setQueryParameter("labelSelector", Objects.requireNonNull(labelSelector));
        return this;
    }

    public ListRequest<T> fieldSelector(String fieldSelector) {
        this.urlBuilder.setQueryParameter("fieldSelector", Objects.requireNonNull(fieldSelector));
        return this;
    }

    public ListRequest<T> limit(int limit) {
        this.urlBuilder.setQueryParameter("limit", String.valueOf(limit));
        return this;
    }

    public ListRequest<T> continueToken(String continueToken) {
        this.urlBuilder.setQueryParameter("continueToken", Objects.requireNonNull(continueToken));
        return this;
    }

    public ListRequest<T> eventuallyConsistent(boolean eventuallyConsistent) {
        this.urlBuilder.setQueryParameter("eventuallyConsistent", String.valueOf(eventuallyConsistent));
        return this;
    }

    @Override
    public CompletableFuture<ObjectList<T>> execute() {
        return this.exec(b -> b);
    }
}

