/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.resourcemanager.api.generated.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.confluent.resourcemanager.api.generated.model.SqlV1Column;
import io.confluent.resourcemanager.api.generated.model.SqlV2RayModelSpec;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"comment", "defaultVersion", "inputSchema", "modelKind", "modelTask", "modelVersions", "outputSchema", "rayModelSpec"})
public class SqlV2ModelSpec
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_COMMENT = "comment";
    private String comment;
    public static final String JSON_PROPERTY_DEFAULT_VERSION = "defaultVersion";
    private String defaultVersion = "";
    public static final String JSON_PROPERTY_INPUT_SCHEMA = "inputSchema";
    private List<SqlV1Column> inputSchema = new ArrayList<SqlV1Column>();
    public static final String JSON_PROPERTY_MODEL_KIND = "modelKind";
    private String modelKind = "";
    public static final String JSON_PROPERTY_MODEL_TASK = "modelTask";
    private String modelTask = "";
    public static final String JSON_PROPERTY_MODEL_VERSIONS = "modelVersions";
    private Map<String, Map<String, String>> modelVersions = new HashMap<String, Map<String, String>>();
    public static final String JSON_PROPERTY_OUTPUT_SCHEMA = "outputSchema";
    private List<SqlV1Column> outputSchema = new ArrayList<SqlV1Column>();
    public static final String JSON_PROPERTY_RAY_MODEL_SPEC = "rayModelSpec";
    private SqlV2RayModelSpec rayModelSpec;
    private Map<String, Object> additionalProperties;

    public SqlV2ModelSpec comment(String comment) {
        this.comment = comment;
        return this;
    }

    @Nullable
    @JsonProperty(value="comment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getComment() {
        return this.comment;
    }

    @JsonProperty(value="comment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setComment(String comment) {
        this.comment = comment;
    }

    public SqlV2ModelSpec defaultVersion(String defaultVersion) {
        this.defaultVersion = defaultVersion;
        return this;
    }

    @Nonnull
    @JsonProperty(value="defaultVersion")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDefaultVersion() {
        return this.defaultVersion;
    }

    @JsonProperty(value="defaultVersion")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDefaultVersion(String defaultVersion) {
        this.defaultVersion = defaultVersion;
    }

    public SqlV2ModelSpec inputSchema(List<SqlV1Column> inputSchema) {
        this.inputSchema = inputSchema;
        return this;
    }

    public SqlV2ModelSpec addInputSchemaItem(SqlV1Column inputSchemaItem) {
        if (this.inputSchema == null) {
            this.inputSchema = new ArrayList<SqlV1Column>();
        }
        this.inputSchema.add(inputSchemaItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="inputSchema")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SqlV1Column> getInputSchema() {
        return this.inputSchema;
    }

    @JsonProperty(value="inputSchema")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInputSchema(List<SqlV1Column> inputSchema) {
        this.inputSchema = inputSchema;
    }

    public SqlV2ModelSpec modelKind(String modelKind) {
        this.modelKind = modelKind;
        return this;
    }

    @Nonnull
    @JsonProperty(value="modelKind")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getModelKind() {
        return this.modelKind;
    }

    @JsonProperty(value="modelKind")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setModelKind(String modelKind) {
        this.modelKind = modelKind;
    }

    public SqlV2ModelSpec modelTask(String modelTask) {
        this.modelTask = modelTask;
        return this;
    }

    @Nonnull
    @JsonProperty(value="modelTask")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getModelTask() {
        return this.modelTask;
    }

    @JsonProperty(value="modelTask")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setModelTask(String modelTask) {
        this.modelTask = modelTask;
    }

    public SqlV2ModelSpec modelVersions(Map<String, Map<String, String>> modelVersions) {
        this.modelVersions = modelVersions;
        return this;
    }

    public SqlV2ModelSpec putModelVersionsItem(String key, Map<String, String> modelVersionsItem) {
        if (this.modelVersions == null) {
            this.modelVersions = new HashMap<String, Map<String, String>>();
        }
        this.modelVersions.put(key, modelVersionsItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="modelVersions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Map<String, Map<String, String>> getModelVersions() {
        return this.modelVersions;
    }

    @JsonProperty(value="modelVersions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setModelVersions(Map<String, Map<String, String>> modelVersions) {
        this.modelVersions = modelVersions;
    }

    public SqlV2ModelSpec outputSchema(List<SqlV1Column> outputSchema) {
        this.outputSchema = outputSchema;
        return this;
    }

    public SqlV2ModelSpec addOutputSchemaItem(SqlV1Column outputSchemaItem) {
        if (this.outputSchema == null) {
            this.outputSchema = new ArrayList<SqlV1Column>();
        }
        this.outputSchema.add(outputSchemaItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="outputSchema")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SqlV1Column> getOutputSchema() {
        return this.outputSchema;
    }

    @JsonProperty(value="outputSchema")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOutputSchema(List<SqlV1Column> outputSchema) {
        this.outputSchema = outputSchema;
    }

    public SqlV2ModelSpec rayModelSpec(SqlV2RayModelSpec rayModelSpec) {
        this.rayModelSpec = rayModelSpec;
        return this;
    }

    @Nullable
    @JsonProperty(value="rayModelSpec")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SqlV2RayModelSpec getRayModelSpec() {
        return this.rayModelSpec;
    }

    @JsonProperty(value="rayModelSpec")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRayModelSpec(SqlV2RayModelSpec rayModelSpec) {
        this.rayModelSpec = rayModelSpec;
    }

    @JsonAnySetter
    public SqlV2ModelSpec putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlV2ModelSpec sqlV2ModelSpec = (SqlV2ModelSpec)o;
        return Objects.equals(this.comment, sqlV2ModelSpec.comment) && Objects.equals(this.defaultVersion, sqlV2ModelSpec.defaultVersion) && Objects.equals(this.inputSchema, sqlV2ModelSpec.inputSchema) && Objects.equals(this.modelKind, sqlV2ModelSpec.modelKind) && Objects.equals(this.modelTask, sqlV2ModelSpec.modelTask) && Objects.equals(this.modelVersions, sqlV2ModelSpec.modelVersions) && Objects.equals(this.outputSchema, sqlV2ModelSpec.outputSchema) && Objects.equals(this.rayModelSpec, sqlV2ModelSpec.rayModelSpec) && Objects.equals(this.additionalProperties, sqlV2ModelSpec.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.comment, this.defaultVersion, this.inputSchema, this.modelKind, this.modelTask, this.modelVersions, this.outputSchema, this.rayModelSpec, super.hashCode(), this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SqlV2ModelSpec {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    comment: ").append(this.toIndentedString(this.comment)).append("\n");
        sb.append("    defaultVersion: ").append(this.toIndentedString(this.defaultVersion)).append("\n");
        sb.append("    inputSchema: ").append(this.toIndentedString(this.inputSchema)).append("\n");
        sb.append("    modelKind: ").append(this.toIndentedString(this.modelKind)).append("\n");
        sb.append("    modelTask: ").append(this.toIndentedString(this.modelTask)).append("\n");
        sb.append("    modelVersions: ").append(this.toIndentedString(this.modelVersions)).append("\n");
        sb.append("    outputSchema: ").append(this.toIndentedString(this.outputSchema)).append("\n");
        sb.append("    rayModelSpec: ").append(this.toIndentedString(this.rayModelSpec)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

