/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.corretto.crypto.provider;

import com.amazon.corretto.crypto.provider.AccessibleByteArrayOutputStream;
import com.amazon.corretto.crypto.provider.AmazonCorrettoCryptoProvider;
import com.amazon.corretto.crypto.provider.ConstantTime;
import com.amazon.corretto.crypto.provider.LibCryptoRng;
import com.amazon.corretto.crypto.provider.Loader;
import com.amazon.corretto.crypto.provider.NativeEvpCipherCtx;
import com.amazon.corretto.crypto.provider.NativeResource;
import com.amazon.corretto.crypto.provider.Utils;
import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import javax.crypto.AEADBadTagException;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;

final class AesGcmSpi
extends CipherSpi {
    private static final int DEFAULT_TAG_LENGTH = 128;
    private static final int DEFAULT_IV_LENGTH_BYTES = 12;
    private static final int NATIVE_MODE_ENCRYPT = 1;
    private static final int NATIVE_MODE_DECRYPT = 0;
    private static final int BLOCK_SIZE = 16;
    private final AmazonCorrettoCryptoProvider provider;
    private NativeResource context = null;
    private boolean sameKey = false;
    private Key lastKey = null;
    private byte[] iv;
    private byte[] key;
    private int tagLength = 16;
    private int opMode = -1;
    private boolean hasConsumedData = false;
    private boolean needReset = false;
    private boolean contextInitialized = false;
    private final AccessibleByteArrayOutputStream decryptInputBuf = new AccessibleByteArrayOutputStream(0, Integer.MAX_VALUE);
    private final AccessibleByteArrayOutputStream decryptAADBuf = new AccessibleByteArrayOutputStream(0, Integer.MAX_VALUE);

    private static native int oneShotEncrypt(long var0, boolean var2, long[] var3, byte[] var4, int var5, int var6, byte[] var7, int var8, int var9, byte[] var10, byte[] var11);

    private static native int oneShotDecrypt(long var0, boolean var2, long[] var3, byte[] var4, int var5, int var6, byte[] var7, int var8, int var9, byte[] var10, byte[] var11, byte[] var12, int var13) throws AEADBadTagException;

    private static native long encryptInit(long var0, boolean var2, byte[] var3, byte[] var4);

    private static native int encryptUpdate(long var0, byte[] var2, int var3, int var4, byte[] var5, int var6);

    private static native void encryptUpdateAAD(long var0, byte[] var2, int var3, int var4);

    private static native int encryptDoFinal(long var0, boolean var2, byte[] var3, int var4, int var5, byte[] var6, int var7, int var8);

    AesGcmSpi(AmazonCorrettoCryptoProvider amazonCorrettoCryptoProvider) {
        Loader.checkNativeLibraryAvailability();
        this.provider = amazonCorrettoCryptoProvider;
    }

    private boolean saveNativeContext() {
        switch (this.provider.getNativeContextReleaseStrategy()) {
            case HYBRID: {
                return this.sameKey;
            }
            case LAZY: {
                return true;
            }
            case EAGER: {
                return false;
            }
        }
        throw new AssertionError((Object)"This should not be reachable.");
    }

    @Override
    protected void engineSetMode(String string) throws NoSuchAlgorithmException {
        if (!"GCM".equalsIgnoreCase(string)) {
            throw new NoSuchAlgorithmException();
        }
    }

    @Override
    protected void engineSetPadding(String string) throws NoSuchPaddingException {
        if (!"NoPadding".equalsIgnoreCase(string)) {
            throw new NoSuchPaddingException();
        }
    }

    @Override
    protected int engineGetBlockSize() {
        return 16;
    }

    @Override
    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        return key.getEncoded().length * 8;
    }

    @Override
    protected int engineGetOutputSize(int n) {
        switch (this.opMode) {
            case 1: {
                return this.getUpdateOutputSize(n) + this.tagLength;
            }
            case 0: {
                return Math.max(0, this.decryptInputBuf.size() + n - this.tagLength);
            }
        }
        throw new IllegalStateException("Cipher not initialized");
    }

    private int getUpdateOutputSize(int n) {
        switch (this.opMode) {
            case 1: {
                return n;
            }
            case 0: {
                return 0;
            }
        }
        throw new IllegalStateException("Cipher not initialized");
    }

    @Override
    protected byte[] engineGetIV() {
        return this.iv == null ? null : (byte[])this.iv.clone();
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        try {
            AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance("GCM");
            byte[] byArray = this.iv;
            if (byArray == null) {
                byArray = new byte[12];
                new LibCryptoRng().nextBytes(byArray);
            }
            algorithmParameters.init(new GCMParameterSpec(this.tagLength * 8, byArray));
            return algorithmParameters;
        }
        catch (NoSuchAlgorithmException | InvalidParameterSpecException generalSecurityException) {
            throw new Error("Unexpected error", generalSecurityException);
        }
    }

    @Override
    protected void engineInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        if (n != 1 && n != 3) {
            throw new InvalidKeyException("IV required for decrypt");
        }
        byte[] byArray = new byte[12];
        secureRandom.nextBytes(byArray);
        try {
            this.engineInit(n, key, new GCMParameterSpec(128, byArray), secureRandom);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new AssertionError((Object)invalidAlgorithmParameterException);
        }
    }

    @Override
    protected void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        int n2 = AesGcmSpi.checkOperation(n);
        GCMParameterSpec gCMParameterSpec = AesGcmSpi.checkSpecAndTag(algorithmParameterSpec);
        byte[] byArray = AesGcmSpi.checkIv(gCMParameterSpec);
        byte[] byArray2 = AesGcmSpi.checkKey(key, this.lastKey, this.key);
        boolean bl = AesGcmSpi.checkKeyIvPair(n2, this.key, byArray2, this.iv, byArray);
        this.opMode = n2;
        this.sameKey = bl;
        this.iv = byArray;
        this.tagLength = gCMParameterSpec.getTLen() / 8;
        this.key = byArray2;
        this.lastKey = key;
        this.needReset = false;
        this.stateReset();
    }

    private static int checkOperation(int n) throws InvalidAlgorithmParameterException {
        switch (n) {
            case 1: 
            case 3: {
                return 1;
            }
            case 2: 
            case 4: {
                return 0;
            }
        }
        throw new InvalidAlgorithmParameterException("Unsupported cipher mode " + n);
    }

    private static GCMParameterSpec checkSpecAndTag(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        if (algorithmParameterSpec instanceof GCMParameterSpec) {
            GCMParameterSpec gCMParameterSpec = (GCMParameterSpec)algorithmParameterSpec;
            if (gCMParameterSpec.getTLen() % 8 != 0 || gCMParameterSpec.getTLen() > 128 || gCMParameterSpec.getTLen() < 96) {
                throw new InvalidAlgorithmParameterException("Unsupported TLen value; must be one of {128, 120, 112, 104, 96}");
            }
            return gCMParameterSpec;
        }
        if (algorithmParameterSpec instanceof IvParameterSpec) {
            return new GCMParameterSpec(128, ((IvParameterSpec)algorithmParameterSpec).getIV());
        }
        throw new InvalidAlgorithmParameterException("I don't know how to handle a " + algorithmParameterSpec.getClass());
    }

    private static byte[] checkIv(GCMParameterSpec gCMParameterSpec) throws InvalidAlgorithmParameterException {
        byte[] byArray = gCMParameterSpec.getIV();
        if (byArray == null || byArray.length == 0) {
            throw new InvalidAlgorithmParameterException("IV must be at least one byte long");
        }
        return byArray;
    }

    private static byte[] checkKey(Key key, Key key2, byte[] byArray) throws InvalidKeyException {
        if (key == null) {
            throw new InvalidKeyException("Key can't be null");
        }
        if (key == key2) {
            return byArray;
        }
        return Utils.checkAesKey(key);
    }

    private static boolean checkKeyIvPair(int n, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) throws InvalidAlgorithmParameterException {
        boolean bl = ConstantTime.equals(byArray, byArray2);
        if (bl && (n == 1 || n == 3) && Arrays.equals(byArray4, byArray3)) {
            throw new InvalidAlgorithmParameterException("Cannot reuse same iv and key for GCM encryption");
        }
        return bl;
    }

    @Override
    protected void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        try {
            this.engineInit(n, key, algorithmParameters.getParameterSpec(GCMParameterSpec.class), secureRandom);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new InvalidAlgorithmParameterException(invalidParameterSpecException);
        }
    }

    @Override
    protected byte[] engineUpdate(byte[] byArray, int n, int n2) {
        int n3;
        byte[] byArray2 = new byte[this.getUpdateOutputSize(n2)];
        try {
            n3 = this.engineUpdate(byArray, n, n2, byArray2, 0);
        }
        catch (ShortBufferException shortBufferException) {
            throw new AssertionError((Object)shortBufferException);
        }
        if (n3 == byArray2.length) {
            return byArray2;
        }
        return Arrays.copyOf(byArray2, n3);
    }

    @Override
    protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
        Utils.checkArrayLimits(byArray, n, n2);
        this.hasConsumedData = true;
        switch (this.opMode) {
            case 0: {
                this.decryptInputBuf.write(byArray, n, n2);
                return 0;
            }
            case 1: {
                int n4;
                byte[] byArray3;
                this.checkOutputBuffer(n2, byArray2, n3, false);
                this.lazyInit();
                if (Utils.outputClobbersInput(byArray, n, n2, byArray2, n3)) {
                    byArray3 = Arrays.copyOfRange(byArray, n, n + n2);
                    n4 = 0;
                } else {
                    byArray3 = byArray;
                    n4 = n;
                }
                return this.context.use(l -> AesGcmSpi.encryptUpdate(l, byArray3, n4, n2, byArray2, n3));
            }
        }
        throw new IllegalStateException("Cipher not initialized");
    }

    @Override
    protected void engineUpdateAAD(byte[] byArray, int n, int n2) {
        Utils.checkArrayLimits(byArray, n, n2);
        if (this.hasConsumedData) {
            throw new IllegalStateException("AAD data cannot be updated after calling update()");
        }
        if (this.opMode == 0) {
            this.decryptAADBuf.write(byArray, n, n2);
            return;
        }
        this.lazyInit();
        this.internalUpdateAAD(byArray, n, n2);
    }

    private void internalUpdateAAD(byte[] byArray, int n, int n2) {
        while (n2 > 0) {
            int n3 = Math.min(n2, 524288);
            int n4 = n;
            this.context.useVoid(l -> AesGcmSpi.encryptUpdateAAD(l, byArray, n4, n3));
            n += n3;
            n2 -= n3;
        }
    }

    @Override
    protected void engineUpdateAAD(ByteBuffer byteBuffer) {
        if (byteBuffer.hasArray()) {
            this.engineUpdateAAD(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
        } else {
            byte[] byArray = new byte[byteBuffer.remaining()];
            byteBuffer.get(byArray);
            this.engineUpdateAAD(byArray, 0, byArray.length);
        }
        byteBuffer.position(byteBuffer.limit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int engineEncryptFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
        if (this.opMode != 1) {
            throw new IllegalStateException("Cipher not initialized for encryption");
        }
        if (byArray == null) {
            byArray = Utils.EMPTY_ARRAY;
        }
        this.checkOutputBuffer(n2, byArray2, n3, true);
        Utils.checkArrayLimits(byArray, n, n2);
        try {
            int n4;
            boolean bl = Utils.outputClobbersInput(byArray, n, n2, byArray2, n3);
            int n5 = 0;
            if (bl) {
                n5 = this.engineUpdate(byArray, n, n2, byArray2, n3);
                n3 += n5;
                n2 = 0;
            }
            this.checkNeedReset();
            this.needReset = true;
            byte[] byArray3 = byArray;
            int n6 = n2;
            int n7 = n3;
            if (!this.contextInitialized) {
                if (this.context != null) {
                    int n8 = this.context.use(l -> AesGcmSpi.oneShotEncrypt(l, this.sameKey, null, byArray3, n, n6, byArray2, n7, this.tagLength, this.key, this.iv));
                    return n8;
                }
                if (this.saveNativeContext()) {
                    long[] lArray = new long[1];
                    int n9 = AesGcmSpi.oneShotEncrypt(0L, false, lArray, byArray3, n, n6, byArray2, n7, this.tagLength, this.key, this.iv);
                    this.context = new NativeEvpCipherCtx(lArray[0]);
                    int n10 = n9;
                    return n10;
                }
                int n11 = AesGcmSpi.oneShotEncrypt(0L, false, null, byArray3, n, n6, byArray2, n7, this.tagLength, this.key, this.iv);
                return n11;
            }
            if (this.saveNativeContext()) {
                n4 = this.context.use(l -> AesGcmSpi.encryptDoFinal(l, false, byArray3, n, n6, byArray2, n7, this.tagLength));
            } else {
                n4 = AesGcmSpi.encryptDoFinal(this.context.take(), true, byArray, n, n6, byArray2, n7, this.tagLength);
                this.context = null;
            }
            int n12 = n5 + n4;
            return n12;
        }
        finally {
            this.stateReset();
        }
    }

    private int engineDecryptFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws AEADBadTagException, ShortBufferException {
        int n4;
        int n5;
        if (this.opMode != 0) {
            throw new IllegalStateException("Cipher not initialized for decryption");
        }
        if (byArray == null) {
            byArray = Utils.EMPTY_ARRAY;
        }
        this.checkOutputBuffer(n2, byArray2, n3, true);
        Utils.checkArrayLimits(byArray, n, n2);
        try {
            byte[] byArray3;
            if (this.decryptInputBuf.isEmpty() && !Utils.outputClobbersInput(byArray, n, n2, byArray2, n3)) {
                byArray3 = byArray;
                n5 = n;
                n4 = n2;
            } else {
                this.decryptInputBuf.finalWrite(byArray, n, n2);
                byArray3 = this.decryptInputBuf.getDataBuffer();
                n4 = this.decryptInputBuf.size();
                n5 = 0;
            }
            if (n4 < this.tagLength) {
                throw new AEADBadTagException("Input too short - need tag");
            }
            if (this.context != null) {
                int n6 = this.context.use(l -> AesGcmSpi.oneShotDecrypt(l, this.sameKey, null, byArray3, n5, n4, byArray2, n3, this.tagLength, this.key, this.iv, this.decryptAADBuf.isEmpty() ? Utils.EMPTY_ARRAY : this.decryptAADBuf.getDataBuffer(), this.decryptAADBuf.size()));
                return n6;
            }
            if (this.saveNativeContext()) {
                long[] lArray = new long[1];
                int n7 = AesGcmSpi.oneShotDecrypt(0L, false, lArray, byArray3, n5, n4, byArray2, n3, this.tagLength, this.key, this.iv, this.decryptAADBuf.isEmpty() ? Utils.EMPTY_ARRAY : this.decryptAADBuf.getDataBuffer(), this.decryptAADBuf.size());
                this.context = new NativeEvpCipherCtx(lArray[0]);
                int n8 = n7;
                return n8;
            }
            int n9 = AesGcmSpi.oneShotDecrypt(0L, false, null, byArray3, n5, n4, byArray2, n3, this.tagLength, this.key, this.iv, this.decryptAADBuf.isEmpty() ? Utils.EMPTY_ARRAY : this.decryptAADBuf.getDataBuffer(), this.decryptAADBuf.size());
            return n9;
        }
        catch (AEADBadTagException aEADBadTagException) {
            n5 = byArray2.length - n3;
            n4 = n3 + Math.min(n5, this.engineGetOutputSize(n2));
            Arrays.fill(byArray2, n3, n4, (byte)0);
            throw aEADBadTagException;
        }
        finally {
            this.stateReset();
        }
    }

    @Override
    protected byte[] engineDoFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
        int n3;
        byte[] byArray2 = new byte[this.engineGetOutputSize(n2)];
        try {
            switch (this.opMode) {
                case 1: {
                    n3 = this.engineEncryptFinal(byArray, n, n2, byArray2, 0);
                    break;
                }
                case 0: {
                    n3 = this.engineDecryptFinal(byArray, n, n2, byArray2, 0);
                    break;
                }
                default: {
                    throw new IllegalStateException("Cipher not initialized");
                }
            }
        }
        catch (ShortBufferException shortBufferException) {
            throw new AssertionError((Object)shortBufferException);
        }
        if (n3 == byArray2.length) {
            return byArray2;
        }
        return Arrays.copyOf(byArray2, n3);
    }

    @Override
    protected int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        if (this.opMode == 0) {
            return this.engineDecryptFinal(byArray, n, n2, byArray2, n3);
        }
        if (this.opMode == 1) {
            return this.engineEncryptFinal(byArray, n, n2, byArray2, n3);
        }
        throw new IllegalStateException("Cipher not initialized");
    }

    @Override
    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        if (this.opMode != 1) {
            throw new IllegalStateException("Cipher must be in WRAP_MODE");
        }
        try {
            byte[] byArray = Utils.encodeForWrapping(this.provider, key);
            return this.engineDoFinal(byArray, 0, byArray.length);
        }
        catch (BadPaddingException badPaddingException) {
            throw new InvalidKeyException("Wrapping failed", badPaddingException);
        }
    }

    @Override
    protected Key engineUnwrap(byte[] byArray, String string, int n) throws InvalidKeyException, NoSuchAlgorithmException {
        if (this.opMode != 0) {
            throw new IllegalStateException("Cipher must be in UNWRAP_MODE");
        }
        try {
            byte[] byArray2 = this.engineDoFinal(byArray, 0, byArray.length);
            return Utils.buildUnwrappedKey(this.provider, byArray2, string, n);
        }
        catch (InvalidKeySpecException | BadPaddingException | IllegalBlockSizeException generalSecurityException) {
            throw new InvalidKeyException("Unwrapping failed", generalSecurityException);
        }
    }

    @Override
    protected int engineUpdate(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws ShortBufferException {
        switch (this.opMode) {
            case 0: {
                this.decryptInputBuf.write(byteBuffer);
                return 0;
            }
            case 1: {
                ByteBuffer byteBuffer3 = null;
                int n = byteBuffer2.position();
                if (byteBuffer2.remaining() < this.engineGetOutputSize(byteBuffer.remaining())) {
                    throw new ShortBufferException();
                }
                if (Utils.outputClobbersInput(byteBuffer, byteBuffer2)) {
                    ByteBuffer byteBuffer4 = ByteBuffer.allocate(byteBuffer.remaining());
                    byteBuffer4.put(byteBuffer);
                    byteBuffer4.flip();
                    byteBuffer3 = byteBuffer = byteBuffer4;
                }
                while (byteBuffer.hasRemaining()) {
                    int n2 = Math.min(byteBuffer.remaining(), 65536);
                    ShimArray shimArray = new ShimArray(byteBuffer, n2);
                    ShimArray shimArray2 = new ShimArray(byteBuffer2, this.engineGetOutputSize(n2));
                    int n3 = this.engineUpdate(shimArray.array, shimArray.offset, shimArray.length, shimArray2.array, shimArray2.offset);
                    shimArray2.writeback();
                    byteBuffer.position(byteBuffer.position() + n2);
                    byteBuffer2.position(byteBuffer2.position() + n3);
                }
                if (byteBuffer3 != null) {
                    Utils.zeroByteBuffer(byteBuffer3);
                }
                return byteBuffer2.position() - n;
            }
        }
        throw new IllegalStateException("Cipher not initialized");
    }

    private void checkOutputBuffer(int n, byte[] byArray, int n2, boolean bl) throws ShortBufferException {
        int n3;
        int n4 = byArray.length - n2;
        int n5 = n3 = bl ? this.engineGetOutputSize(n) : this.getUpdateOutputSize(n);
        if (n < 0 || n2 < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (n2 > byArray.length || n2 == byArray.length && n3 > 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (n4 < n3) {
            throw new ShortBufferException(String.format("Expected a buffer of at least %d bytes; got %d", n3, n4));
        }
    }

    private void lazyInit() {
        if (this.contextInitialized) {
            return;
        }
        this.contextInitialized = true;
        if (this.opMode < 0) {
            throw new IllegalStateException("Cipher not initialized");
        }
        this.checkNeedReset();
        if (this.context != null) {
            this.context.useVoid(l -> AesGcmSpi.encryptInit(l, this.sameKey, this.key, this.iv));
        } else {
            this.context = new NativeEvpCipherCtx(AesGcmSpi.encryptInit(0L, false, this.key, this.iv));
        }
    }

    private void checkNeedReset() {
        if (this.needReset) {
            throw new IllegalStateException("Must change key or IV for GCM mode encryption");
        }
    }

    private void stateReset() {
        if (this.context != null && this.context.isReleased()) {
            this.context = null;
        }
        this.decryptInputBuf.reset();
        this.decryptAADBuf.reset();
        this.hasConsumedData = false;
        this.contextInitialized = false;
    }

    static {
        Loader.load();
    }

    private static final class ShimArray {
        private final ByteBuffer backingBuffer;
        private final boolean doWriteback;
        public final byte[] array;
        public final int offset;
        public final int length;

        private ShimArray(ByteBuffer byteBuffer, int n) {
            byte[] byArray;
            this.backingBuffer = byteBuffer.duplicate();
            boolean bl = this.backingBuffer.hasArray();
            byte[] byArray2 = byArray = bl ? this.backingBuffer.array() : null;
            if (byArray == null) {
                byArray = new byte[n];
                this.backingBuffer.duplicate().get(byArray);
                this.doWriteback = true;
                this.offset = 0;
            } else {
                this.doWriteback = false;
                this.offset = this.backingBuffer.arrayOffset() + this.backingBuffer.position();
            }
            this.array = byArray;
            this.length = n;
        }

        private void writeback() {
            if (this.doWriteback) {
                this.backingBuffer.duplicate().put(this.array);
            }
        }
    }
}

