/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.corretto.crypto.provider;

import java.nio.ByteBuffer;

class ShimByteBuffer {
    public final ByteBuffer directByteBuffer;
    public final byte[] array;
    public final int offset;
    private final ByteBuffer backingByteBuffer;

    ShimByteBuffer(ByteBuffer byteBuffer, boolean bl) {
        if (byteBuffer.hasArray()) {
            this.backingByteBuffer = null;
            this.directByteBuffer = null;
            this.array = byteBuffer.array();
            this.offset = byteBuffer.arrayOffset() + byteBuffer.position();
            return;
        }
        if (byteBuffer.isDirect()) {
            this.backingByteBuffer = null;
            this.directByteBuffer = byteBuffer;
            this.array = null;
            this.offset = byteBuffer.position();
            return;
        }
        this.backingByteBuffer = byteBuffer.duplicate();
        this.directByteBuffer = null;
        this.array = new byte[byteBuffer.remaining()];
        if (bl) {
            this.backingByteBuffer.duplicate().get(this.array);
        }
        this.offset = 0;
    }

    void writeBack(int n) {
        if (this.backingByteBuffer != null) {
            this.backingByteBuffer.put(this.array, 0, n);
        }
    }
}

