/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.replicator.monitoring;

import io.confluent.connect.replicator.monitoring.connect.ConnectorDetailsProvider;
import io.confluent.connect.replicator.monitoring.entities.Connector;
import io.confluent.connect.replicator.monitoring.entities.ReplicatorMetrics;
import io.confluent.connect.replicator.monitoring.entities.Task;
import io.confluent.connect.replicator.monitoring.entities.WorkerMetrics;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MultivaluedMap;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Path(value="/ReplicatorMetrics")
@Produces(value={"application/json"})
public class ReplicatorMetricsResource {
    public static final String TASK_ID_KEY = "task.id";
    public static final String STATE_KEY = "state";
    public static final String WORKER_ID_KEY = "worker_id";
    public static final String CLASS_CONFIG = "connector.class";
    public static final String REPLICATOR_CLASS = "io.confluent.connect.replicator.ReplicatorSourceConnector";
    public static final String SRC_BOOTSTRAP_SERVER_CONFIG = "src.kafka.bootstrap.servers";
    public static final String DEST_BOOTSTRAP_SERVER_CONFIG = "dest.kafka.bootstrap.servers";
    private ConnectorDetailsProvider connectorDetailsProvider = null;

    @GET
    public ReplicatorMetrics getReplicatorMetrics(@Context ContainerRequestContext requestContext) throws IOException {
        ReplicatorMetrics replicatorMetrics = new ReplicatorMetrics();
        this.setupConnectorDetailsProvider(requestContext);
        List<String> connectorNames = this.connectorDetailsProvider.getConnectorNames();
        for (String connectorName : connectorNames) {
            Map<String, String> connectorConfigs;
            try {
                connectorConfigs = this.connectorDetailsProvider.getConnectorConfig(connectorName);
            }
            catch (Exception e) {
                continue;
            }
            if (!connectorConfigs.get(CLASS_CONFIG).equals(REPLICATOR_CLASS)) continue;
            Connector connector = new Connector(connectorName, connectorConfigs.get(SRC_BOOTSTRAP_SERVER_CONFIG), connectorConfigs.get(DEST_BOOTSTRAP_SERVER_CONFIG));
            Map<String, Map<String, String>> taskConfigs = this.connectorDetailsProvider.getTaskConfigs(connectorName);
            Map<String, String> taskIdMappings = this.mapConnectTaskIdsToReplicator(taskConfigs);
            HashMap<String, Task> fetchedTasks = new HashMap<String, Task>();
            String srcClusterId = "";
            String destClusterId = "";
            for (String taskId : taskConfigs.keySet()) {
                Map<String, String> taskStatuses = this.connectorDetailsProvider.getTaskStatus(connectorName, taskId);
                String taskStatus = taskStatuses.get(STATE_KEY);
                String workerId = taskStatuses.get(WORKER_ID_KEY);
                Task task = new Task(taskId, workerId, taskStatus);
                if (!fetchedTasks.containsKey(connectorName + "-" + taskId) && taskStatus.equals("RUNNING")) {
                    WorkerMetrics workerMetrics = this.connectorDetailsProvider.getWorkerMetrics(workerId, connectorName);
                    fetchedTasks.putAll(this.tasksFromWorkerMetrics(connectorName, workerMetrics.tasks, taskIdMappings, workerId));
                    srcClusterId = workerMetrics.srcClusterId;
                    destClusterId = workerMetrics.destClusterId;
                }
                if (fetchedTasks.containsKey(connectorName + "-" + taskId)) {
                    task = (Task)fetchedTasks.get(connectorName + "-" + taskId);
                }
                task.state = taskStatus;
                connector.addTask(task);
                connector.srcClusterId = srcClusterId;
                connector.destClusterId = destClusterId;
            }
            replicatorMetrics.addConnector(connector);
        }
        return replicatorMetrics;
    }

    private void setupConnectorDetailsProvider(@Context ContainerRequestContext requestContext) {
        if (this.connectorDetailsProvider == null) {
            this.connectorDetailsProvider = new ConnectorDetailsProvider(requestContext);
        } else if (this.connectorDetailsProvider.getBaseUri().equals(requestContext.getUriInfo().getBaseUri().toString())) {
            this.connectorDetailsProvider.setHeaders((MultivaluedMap<String, String>)requestContext.getHeaders());
        } else {
            this.connectorDetailsProvider = new ConnectorDetailsProvider(requestContext);
        }
    }

    private Map<String, String> mapConnectTaskIdsToReplicator(Map<String, Map<String, String>> taskConfigs) {
        HashMap<String, String> taskMappings = new HashMap<String, String>();
        for (String connectTaskId : taskConfigs.keySet()) {
            taskMappings.put(connectTaskId, taskConfigs.get(connectTaskId).get(TASK_ID_KEY));
            taskMappings.put(taskConfigs.get(connectTaskId).get(TASK_ID_KEY), connectTaskId);
        }
        return taskMappings;
    }

    private Map<String, Task> tasksFromWorkerMetrics(String connectorName, List<Task> tasks, Map<String, String> taskMappings, String workerId) {
        HashMap<String, Task> workerTasks = new HashMap<String, Task>();
        for (Task task : tasks) {
            String mappedTaskId;
            task.id = mappedTaskId = taskMappings.get(task.id);
            task.workerId = workerId;
            workerTasks.put(connectorName + "-" + task.id, task);
        }
        return workerTasks;
    }

    public void setConnectorDetailsProvider(ConnectorDetailsProvider connectorDetailsProvider) {
        this.connectorDetailsProvider = connectorDetailsProvider;
    }
}

