/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.replicator.monitoring.connect;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.connect.replicator.monitoring.entities.WorkerMetrics;
import io.confluent.connect.replicator.monitoring.util.HttpStatusCodeMapper;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.MultivaluedMap;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectorDetailsProvider {
    private static Logger log = LoggerFactory.getLogger(ConnectorDetailsProvider.class);
    private String urlPrefix;
    private Map<String, String> headers = new HashMap<String, String>();
    private String baseUri;

    public ConnectorDetailsProvider(ContainerRequestContext requestContext) {
        String scheme = this.getValue((MultivaluedMap<String, String>)requestContext.getHeaders(), "X-Forwarded-Proto");
        String port = this.getValue((MultivaluedMap<String, String>)requestContext.getHeaders(), "X-Forwarded-Port");
        if (scheme != null && port != null) {
            URI uri = requestContext.getUriInfo().getBaseUriBuilder().build(new Object[0]);
            this.urlPrefix = scheme + "://";
            this.baseUri = this.urlPrefix + uri.getHost() + ":" + port + "/";
        } else {
            this.urlPrefix = requestContext.getUriInfo().getRequestUri().getScheme() + "://";
            this.baseUri = requestContext.getUriInfo().getBaseUri().toString();
        }
        this.setHeaders((MultivaluedMap<String, String>)requestContext.getHeaders());
    }

    private String getValue(MultivaluedMap<String, String> headers, String header) {
        List values = (List)headers.get((Object)header);
        if (values == null || values.isEmpty()) {
            return null;
        }
        return (String)values.get(0);
    }

    public void setHeaders(MultivaluedMap<String, String> headers) {
        for (Map.Entry header : headers.entrySet()) {
            this.headers.put((String)header.getKey(), String.join((CharSequence)",", (Iterable)header.getValue()));
        }
    }

    public WorkerMetrics getWorkerMetrics(String workerUrl, String connectorName) throws IOException {
        String metricsUrl = this.urlPrefix + workerUrl + "/WorkerMetrics/" + connectorName;
        ObjectMapper mapper = new ObjectMapper();
        return (WorkerMetrics)mapper.readValue(this.doRequest(metricsUrl), WorkerMetrics.class);
    }

    public List<String> getConnectorNames() throws IOException {
        String connectorsUrl = this.baseUri + "connectors";
        ObjectMapper mapper = new ObjectMapper();
        JsonNode connectorsNode = mapper.readTree(this.doRequest(connectorsUrl));
        ArrayList<String> connectors = new ArrayList<String>();
        for (JsonNode connector : connectorsNode) {
            connectors.add(connector.asText());
        }
        return connectors;
    }

    public Map<String, String> getConnectorConfig(String connectorName) throws IOException {
        String connectorConfigUrl = this.baseUri + "connectors/" + connectorName;
        ObjectMapper mapper = new ObjectMapper();
        JsonNode configNode = mapper.readTree(this.doRequest(connectorConfigUrl)).get("config");
        HashMap<String, String> connectorConfig = new HashMap<String, String>();
        configNode.fieldNames().forEachRemaining(f -> connectorConfig.put((String)f, configNode.get(f).asText()));
        return connectorConfig;
    }

    public Map<String, String> getTaskStatus(String connectorName, String taskId) throws IOException {
        String connectorConfigUrl = this.baseUri + "connectors/" + connectorName + "/tasks/" + taskId + "/status";
        ObjectMapper mapper = new ObjectMapper();
        JsonNode statusNode = mapper.readTree(this.doRequest(connectorConfigUrl));
        HashMap<String, String> taskStatus = new HashMap<String, String>();
        statusNode.fieldNames().forEachRemaining(f -> taskStatus.put((String)f, statusNode.get(f).asText()));
        return taskStatus;
    }

    public Map<String, Map<String, String>> getTaskConfigs(String connectorName) throws IOException {
        String connectorTasksUrl = this.baseUri + "connectors/" + connectorName + "/tasks";
        ObjectMapper mapper = new ObjectMapper();
        JsonNode tasksNode = mapper.readTree(this.doRequest(connectorTasksUrl));
        HashMap<String, Map<String, String>> taskConfigs = new HashMap<String, Map<String, String>>();
        for (JsonNode taskNode : tasksNode) {
            String id = taskNode.get("id").get("task").asText();
            HashMap taskConfig = new HashMap();
            JsonNode configNode = taskNode.get("config");
            configNode.fieldNames().forEachRemaining(f -> taskConfig.put(f, configNode.get(f).asText()));
            taskConfigs.put(id, taskConfig);
        }
        return taskConfigs;
    }

    private InputStream doRequest(String url) throws IOException {
        log.debug("Url to connect to worker: {}", (Object)url);
        URL workerUrl = new URL(url);
        HttpURLConnection con = (HttpURLConnection)workerUrl.openConnection();
        con.setRequestMethod("GET");
        for (Map.Entry<String, String> header : this.headers.entrySet()) {
            con.setRequestProperty(header.getKey(), header.getValue());
        }
        con.setDoOutput(true);
        int responseCode = con.getResponseCode();
        if (responseCode == 200) {
            return con.getInputStream();
        }
        throw HttpStatusCodeMapper.mapStatusCode(responseCode);
    }

    public String getBaseUri() {
        return this.baseUri;
    }
}

