/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server.plugins.auth.oauth;

import io.confluent.kafka.server.plugins.auth.oauth.JwtAuthenticatorConfig;
import io.confluent.security.authentication.oauthbearer.ConstrainedVerificationKeyResolver;
import io.confluent.security.authentication.oauthbearer.JwtAuthenticationConfig;
import io.confluent.security.authentication.oauthbearer.SpireVerificationKeyResolver;
import io.confluent.security.util.SecurityContext;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JwtAuthenticatorConfigTest {
    private static final String SPIRE_WITH_DEFAULT_ISSUER_SUFFIX = "SpireWithDefaultIssuerSuffix";
    private static final String SPIRE_WITH_CUSTOM_ISSUER_SUFFIX = "SpireWithCustomIssuerSuffix";
    private static final String SPIRE_CUSTOM_SUFFIX = "spire.custom.suffix";

    @Test
    public void testSpireIssuerSuffixFromProperties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        this.addToMapWithPrefix(properties, "kind", "jwt");
        this.addToMapWithPrefix(properties, "algorithmWhitelist.1", "RS256");
        this.addToMapWithPrefix(properties, "spireAgentSocketEndpoint", "localhost:8080");
        this.addToMapWithPrefix(properties, "issuers.1.name", SPIRE_WITH_CUSTOM_ISSUER_SUFFIX);
        this.addToMapWithPrefix(properties, "issuers.1.verifier", "io.confluent.security.authentication.oauthbearer.JwtIssuerSpire");
        this.addToMapWithPrefix(properties, "issuers.1.audience.1", "rapt");
        this.addToMapWithPrefix(properties, "issuers.1.spireIssuerSuffix", SPIRE_CUSTOM_SUFFIX);
        this.addToMapWithPrefix(properties, "issuers.2.name", SPIRE_WITH_DEFAULT_ISSUER_SUFFIX);
        this.addToMapWithPrefix(properties, "issuers.2.verifier", "io.confluent.security.authentication.oauthbearer.JwtIssuerSpire");
        this.addToMapWithPrefix(properties, "issuers.2.audience.1", "inattentive");
        JwtAuthenticatorConfig config = JwtAuthenticatorConfig.newInstance(properties);
        JwtAuthenticatorConfigTest.validateSpireIssuerSuffix(config, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreationFromYamlConfigFile() throws IOException {
        File yamlConfigFile = TestUtils.tempFile();
        try {
            String configFileContent = this.getYamlConfig();
            Files.write(yamlConfigFile.toPath(), configFileContent.getBytes(), new OpenOption[0]);
            Map<String, Object> properties = Collections.singletonMap(JwtAuthenticatorConfig.JWT_AUTHENTICATOR_CONFIG_URL, yamlConfigFile.getPath());
            JwtAuthenticatorConfig config = JwtAuthenticatorConfig.newInstance(properties);
            JwtAuthenticatorConfigTest.validateSpireIssuerSuffix(config, properties);
        }
        finally {
            Files.deleteIfExists(yamlConfigFile.toPath());
        }
    }

    private String getYamlConfig() {
        return "kind: jwt\nalgorithmWhitelist:\n  - RS256\nspireAgentSocketEndpoint: localhost:8080\nissuers:\n  - name: SpireWithCustomIssuerSuffix\n    verifier: io.confluent.security.authentication.oauthbearer.JwtIssuerSpire\n    audience:\n      - rapt\n    spireIssuerSuffix: spire.custom.suffix\n  - name: SpireWithDefaultIssuerSuffix\n    verifier: io.confluent.security.authentication.oauthbearer.JwtIssuerSpire\n    audience:\n      - inattentive\n";
    }

    private static void validateSpireIssuerSuffix(JwtAuthenticatorConfig config, Map<String, Object> properties) {
        JwtAuthenticationConfig authenticationConfig = config.createAuthenticationConfig(properties);
        List issuers = authenticationConfig.issuers();
        Assertions.assertEquals((int)2, (int)issuers.size());
        issuers.forEach(issuer -> {
            String expectedSpireSuffix = issuer.name().equals(SPIRE_WITH_CUSTOM_ISSUER_SUFFIX) ? SPIRE_CUSTOM_SUFFIX : "spire.internal.confluent.cloud";
            ConstrainedVerificationKeyResolver resolver = issuer.keyResolver(Collections.emptyList(), new SecurityContext());
            SpireVerificationKeyResolver keyResolver = (SpireVerificationKeyResolver)resolver.getDelegate();
            Assertions.assertEquals((Object)expectedSpireSuffix, (Object)keyResolver.getSpireIssuerSuffix());
        });
    }

    private void addToMapWithPrefix(Map<String, Object> properties, String key, Object value) {
        properties.put("authenticator.jwt." + key, value);
    }
}

