/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.reactivex.internal.operators.maybe;

import io.confluent.shaded.io.reactivex.Maybe;
import io.confluent.shaded.io.reactivex.MaybeObserver;
import io.confluent.shaded.io.reactivex.disposables.Disposables;
import io.confluent.shaded.io.reactivex.exceptions.Exceptions;
import io.confluent.shaded.io.reactivex.internal.functions.ObjectHelper;
import java.util.concurrent.Callable;

public final class MaybeErrorCallable<T>
extends Maybe<T> {
    final Callable<? extends Throwable> errorSupplier;

    public MaybeErrorCallable(Callable<? extends Throwable> errorSupplier) {
        this.errorSupplier = errorSupplier;
    }

    @Override
    protected void subscribeActual(MaybeObserver<? super T> observer) {
        Throwable ex;
        observer.onSubscribe(Disposables.disposed());
        try {
            ex = ObjectHelper.requireNonNull(this.errorSupplier.call(), "Callable returned null throwable. Null values are generally not allowed in 2.x operators and sources.");
        }
        catch (Throwable ex1) {
            Exceptions.throwIfFatal(ex1);
            ex = ex1;
        }
        observer.onError(ex);
    }
}

