/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common.security.jetty;

import io.confluent.common.security.auth.RestUserPrincipal;
import io.confluent.common.security.jetty.OAuthBearerAuthenticator;
import io.confluent.common.security.jetty.OAuthRequestData;
import io.confluent.common.security.jetty.OAuthRequestDataFactory;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import javax.security.auth.Subject;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.security.AuthenticationState;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.security.UserIdentity;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.security.authentication.LoginAuthenticator;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthOrBasicAuthenticator
extends LoginAuthenticator {
    private static final Logger log = LoggerFactory.getLogger(OAuthOrBasicAuthenticator.class);
    public static final String USE_JWT_LOGIN_SERVICE = "io.confluent.useJWTLoginService";
    public static final String METADATA_RESOURCE_URI = "/v1/metadata/id";
    private final OAuthBearerAuthenticator oauth = new OAuthBearerAuthenticator();
    private final BasicAuthenticator basic;
    private final List<String> allowedNoAuthEndpoints = new ArrayList<String>();

    public OAuthOrBasicAuthenticator() {
        this(new BasicAuthenticator());
    }

    public OAuthOrBasicAuthenticator(BasicAuthenticator basicAuthenticator) {
        this(basicAuthenticator, Collections.emptyList());
    }

    public OAuthOrBasicAuthenticator(BasicAuthenticator basicAuthenticator, List<String> additionalNoAuthEndpoints) {
        this.basic = basicAuthenticator;
        this.allowedNoAuthEndpoints.add(METADATA_RESOURCE_URI);
        this.allowedNoAuthEndpoints.addAll(additionalNoAuthEndpoints);
    }

    public String getAuthenticationType() {
        return "BEARER+BASIC";
    }

    public AuthenticationState validateRequest(Request request, Response response, Callback callback) throws ServerAuthException {
        OAuthRequestDataFactory oAuthRequestDataFactory;
        OAuthRequestData authRequestData;
        boolean requestIsForNoAuthEndpoint = this.allowedNoAuthEndpoints.stream().anyMatch(noAuthEndpoint -> request.getHttpURI().getPath().equalsIgnoreCase((String)noAuthEndpoint));
        if (requestIsForNoAuthEndpoint) {
            UserIdentity userIdentity = this._identityService.newUserIdentity(new Subject(), (Principal)new RestUserPrincipal(""), new String[0]);
            return new LoginAuthenticator.UserAuthenticationSucceeded(this.getAuthenticationType(), userIdentity);
        }
        if (log.isDebugEnabled() && !(authRequestData = (oAuthRequestDataFactory = OAuthRequestDataFactory.getInstance()).getOAuthRequestData(request)).authInfoExists()) {
            log.debug("Authentication Header/token information missing in the request");
        }
        if (this.oauth.requestIsOAuth(request)) {
            request.setAttribute(USE_JWT_LOGIN_SERVICE, (Object)true);
            return this.oauth.validateRequest(request, response, callback);
        }
        return this.validateBasicAuth(request, response, callback);
    }

    public void setConfiguration(Authenticator.Configuration configuration) {
        super.setConfiguration(configuration);
        this.basic.setConfiguration(configuration);
        this.oauth.setConfiguration(configuration);
    }

    private AuthenticationState validateBasicAuth(Request request, Response response, Callback callback) throws ServerAuthException {
        String method;
        int space;
        String credentials = request.getHeaders().get(HttpHeader.AUTHORIZATION);
        if (credentials != null && (space = credentials.indexOf(32)) > 0 && "Basic".equalsIgnoreCase(method = credentials.substring(0, space))) {
            credentials = credentials.substring(space + 1);
            try {
                Base64.getDecoder().decode(credentials);
            }
            catch (IllegalArgumentException e) {
                log.warn("Invalid Base64 encoding in Authorization header");
                if (!response.isCommitted()) {
                    response.getHeaders().put(HttpHeader.WWW_AUTHENTICATE, "Basic realm=\"" + this.getLoginService().getName() + "\"");
                }
                Response.writeError((Request)request, (Response)response, (Callback)callback, (int)401);
                return AuthenticationState.CHALLENGE;
            }
        }
        return this.basic.validateRequest(request, response, callback);
    }
}

