/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.resourcemanager.api.client;

import com.fasterxml.jackson.databind.JavaType;
import io.confluent.resourcemanager.api.client.ClientImpl;
import io.confluent.resourcemanager.api.client.Request;
import io.confluent.resourcemanager.api.model.HasMetadata;
import io.confluent.resourcemanager.api.model.identifier.ObjectIdentifier;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import okhttp3.OkHttpClient;

public final class DeleteRequest<T extends HasMetadata>
extends Request<Optional<T>> {
    DeleteRequest(String baseUrl, OkHttpClient httpClient, ObjectIdentifier<T> objectIdentifier) {
        super(baseUrl, httpClient, ClientImpl.OBJECT_MAPPER.getTypeFactory().constructParametricType(Optional.class, new JavaType[]{objectIdentifier.getJavaType()}), objectIdentifier.getGroupVersionResource(), objectIdentifier.getLocation(), objectIdentifier.getScoping(), objectIdentifier.getScope());
        this.objectName = objectIdentifier.getName();
        this.kind = objectIdentifier.getKind();
    }

    public DeleteRequest<T> resourceVersion(String resourceVersion) {
        this.urlBuilder.setQueryParameter("resourceVersion", Objects.requireNonNull(resourceVersion));
        return this;
    }

    public DeleteRequest<T> uid(UUID uid) {
        this.urlBuilder.setQueryParameter("uid", Objects.requireNonNull(uid).toString());
        return this;
    }

    public DeleteRequest<T> foreground(boolean foreground) {
        this.urlBuilder.setQueryParameter("propagationPolicy", foreground ? "Foreground" : "Background");
        return this;
    }

    @Override
    public CompletableFuture<Optional<T>> execute() {
        return this.exec(builder -> builder.delete());
    }
}

