/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common.security.jetty;

import io.confluent.common.security.jetty.OAuthRequestData;
import io.confluent.common.security.jetty.OAuthRequestDataFactory;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.security.AuthenticationState;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.security.UserIdentity;
import org.eclipse.jetty.security.authentication.LoginAuthenticator;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthBearerAuthenticator
extends LoginAuthenticator {
    public static final String ACCESS_TOKEN = "access_token";
    public static final String BEARER_KEYWORD = "Bearer";
    public static final String AUTH_TOKEN = "auth_token";
    private static final Logger log = LoggerFactory.getLogger(OAuthBearerAuthenticator.class);
    private final JwtConsumer jwtConsumer = new JwtConsumerBuilder().setSkipSignatureVerification().setDisableRequireSignature().setSkipAllValidators().build();

    public String getAuthenticationType() {
        return "BEARER";
    }

    public AuthenticationState validateRequest(Request request, Response response, Callback callback) throws ServerAuthException {
        String tokenToUse;
        OAuthRequestData authRequestData = this.extractAuthRequestData(request);
        String tokenFromHeader = authRequestData.tokenFromAuthHeader();
        String tokenFromCookie = authRequestData.tokenFromCookie();
        String tokenFromQueryParam = authRequestData.tokenFromQueryParam();
        String string = tokenToUse = tokenFromHeader != null ? tokenFromHeader : tokenFromCookie;
        if (tokenToUse == null) {
            if (tokenFromQueryParam == null) {
                log.debug("Authentication failed: Request does not have a token.");
                return this.sendError(request, response, callback, ErrorCode.INVALID_REQUEST_TOKEN_NOT_FOUND);
            }
            tokenToUse = tokenFromQueryParam;
            if (authRequestData.authHeaderSpecifiesSomeOtherAuthType()) {
                log.debug("Authentication failed: Request has an Authorization header, but it does not specify Bearer.");
                return this.sendError(request, response, callback, ErrorCode.INVALID_REQUEST_BEARER_NOT_FOUND);
            }
        } else if (tokenFromQueryParam != null && !tokenToUse.equals(tokenFromQueryParam)) {
            log.debug("Authentication failed: Request has a token in the Authorization header, but it does not match the token in the query parameter.");
            return this.sendError(request, response, callback, ErrorCode.INVALID_REQUEST_INCORRECT_QUERY_PARAM_TOKEN);
        }
        if (tokenFromQueryParam != null && !response.isCommitted()) {
            response.getHeaders().put(HttpHeader.CACHE_CONTROL, "private");
        }
        return this.authenticateUser(request, response, callback, tokenToUse);
    }

    private OAuthRequestData extractAuthRequestData(Request request) {
        OAuthRequestDataFactory oAuthRequestDataFactory = OAuthRequestDataFactory.getInstance();
        return oAuthRequestDataFactory.getOAuthRequestData(request);
    }

    private AuthenticationState authenticateUser(Request request, Response response, Callback callback, String tokenToUse) throws ServerAuthException {
        JwtClaims jwtClaims = this.parseJwtToken(tokenToUse);
        try {
            if (jwtClaims != null && jwtClaims.getExpirationTime() != null && jwtClaims.getExpirationTime().getValue() * 1000L < System.currentTimeMillis()) {
                log.debug("Invalid Token: Token has expired.");
                return this.sendError(request, response, callback, ErrorCode.INVALID_TOKEN_EXPIRED);
            }
        }
        catch (ServerAuthException | MalformedClaimException e) {
            log.error("exp claim not present in JwtClaims");
        }
        UserIdentity user = this.getLoginService().login(null, (Object)tokenToUse, request, arg_0 -> ((Request)request).getSession(arg_0));
        ErrorCode validityResult = this.getUserValidityResult(user);
        if (validityResult == null) {
            return new LoginAuthenticator.UserAuthenticationSucceeded(this.getAuthenticationType(), user);
        }
        if (!AuthenticationState.Deferred.isDeferred((Response)response)) {
            log.debug("Authentication failed: {}", (Object)validityResult.message);
            return this.sendError(request, response, callback, validityResult);
        }
        return AuthenticationState.SEND_FAILURE;
    }

    private JwtClaims parseJwtToken(Object credentials) {
        JwtClaims jwtClaims = null;
        try {
            jwtClaims = this.jwtConsumer.processToClaims((String)credentials);
        }
        catch (Exception e) {
            log.error("Found an invalid JWT token, letting the underlying login service handle it.");
        }
        return jwtClaims;
    }

    public boolean requestIsOAuth(Request request) {
        OAuthRequestDataFactory oAuthRequestDataFactory = OAuthRequestDataFactory.getInstance();
        OAuthRequestData authRequestData = oAuthRequestDataFactory.getOAuthRequestData(request);
        return authRequestData.isOAuthRequest();
    }

    private AuthenticationState sendError(Request request, Response response, Callback callback, ErrorCode error) throws ServerAuthException {
        StringBuilder value = new StringBuilder().append("Bearer realm=\"").append(this.getLoginService().getName()).append('\"');
        if (error != null) {
            value.append(',').append(error.asHeaderAttribute());
        }
        response.setStatus(HttpStatus.Code.UNAUTHORIZED.getCode());
        if (!response.isCommitted()) {
            response.getHeaders().put(HttpHeader.CONTENT_TYPE, "text/plain");
        }
        Response.writeError((Request)request, (Response)response, (Callback)callback, (int)HttpStatus.Code.UNAUTHORIZED.getCode(), (String)value.toString());
        return AuthenticationState.SEND_FAILURE;
    }

    private ErrorCode getUserValidityResult(UserIdentity user) {
        if (user == null) {
            return ErrorCode.INVALID_TOKEN_UNDEFINED_USER;
        }
        if (user.getUserPrincipal() == null) {
            return ErrorCode.INVALID_TOKEN_UNDEFINED_PRINCIPAL;
        }
        String name = user.getUserPrincipal().getName();
        if (name == null || name.isEmpty()) {
            return ErrorCode.INVALID_TOKEN_UNDEFINED_SUBCLAIM_OR_PRINCIPAL;
        }
        return null;
    }

    public static enum ErrorCode {
        INVALID_REQUEST_TOKEN_NOT_FOUND("Invalid_Request", "Token is not present"),
        INVALID_REQUEST_BEARER_NOT_FOUND("Invalid_Request", "Authorization Header specifies Auth type other than Bearer"),
        INVALID_REQUEST_INCORRECT_QUERY_PARAM_TOKEN("Invalid_Request", "Query param token does not match with token present in header or cookie."),
        INVALID_TOKEN_UNDEFINED_USER("Invalid Token", "User Identity not found"),
        INVALID_TOKEN_UNDEFINED_PRINCIPAL("Invalid Token", "Unable to extract Principal"),
        INVALID_TOKEN_UNDEFINED_SUBCLAIM_OR_PRINCIPAL("Invalid Token", "Unable to extract SubClaim or Principal Name"),
        INVALID_TOKEN_EXPIRED("Invalid Token", "Token has expired");

        final String error;
        final String message;

        private ErrorCode(String error, String message) {
            this.error = error;
            this.message = message;
        }

        public String asHeaderAttribute() {
            return "error=\"" + this.error + " : " + this.message + "\"";
        }
    }
}

