/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common.security.util;

import io.confluent.common.security.auth.JwtPrincipal;
import io.confluent.common.security.util.JwtUtils;
import java.security.Principal;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.common.security.auth.ConfluentPrincipal;
import org.apache.kafka.common.security.auth.KafkaPrincipal;

public class AuthorizerUtils {
    public static KafkaPrincipal kafkaPrincipalFor(Principal userPrincipal) {
        Set<String> groups;
        Objects.requireNonNull(userPrincipal, "Principal may not be null");
        if (userPrincipal instanceof JwtPrincipal && !(groups = JwtUtils.getGroupsFromJwtPrincipal((JwtPrincipal)userPrincipal)).isEmpty()) {
            return new ConfluentPrincipal("User", userPrincipal.getName(), userPrincipal.getName(), Optional.empty(), false, groups);
        }
        return new KafkaPrincipal("User", userPrincipal.getName());
    }
}

