/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.storage.tier.serdes;

import com.google.flatbuffers.BaseVector;
import com.google.flatbuffers.ByteVector;
import com.google.flatbuffers.Constants;
import com.google.flatbuffers.FlatBufferBuilder;
import com.google.flatbuffers.Table;
import io.confluent.kafka.storage.tier.serdes.FragmentDescription;
import io.confluent.kafka.storage.tier.serdes.OffsetAndEpoch;
import io.confluent.kafka.storage.tier.serdes.OpaqueDataField;
import io.confluent.kafka.storage.tier.serdes.UUID;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class SegmentUploadInitiate
extends Table {
    public static void ValidateVersion() {
        Constants.FLATBUFFERS_2_0_8();
    }

    public static SegmentUploadInitiate getRootAsSegmentUploadInitiate(ByteBuffer _bb) {
        return SegmentUploadInitiate.getRootAsSegmentUploadInitiate(_bb, new SegmentUploadInitiate());
    }

    public static SegmentUploadInitiate getRootAsSegmentUploadInitiate(ByteBuffer _bb, SegmentUploadInitiate obj) {
        _bb.order(ByteOrder.LITTLE_ENDIAN);
        return obj.__assign(_bb.getInt(_bb.position()) + _bb.position(), _bb);
    }

    public void __init(int _i, ByteBuffer _bb) {
        this.__reset(_i, _bb);
    }

    public SegmentUploadInitiate __assign(int _i, ByteBuffer _bb) {
        this.__init(_i, _bb);
        return this;
    }

    public byte version() {
        int o = this.__offset(4);
        return o != 0 ? this.bb.get(o + this.bb_pos) : (byte)0;
    }

    public int tierEpoch() {
        int o = this.__offset(6);
        return o != 0 ? this.bb.getInt(o + this.bb_pos) : 0;
    }

    public UUID objectId() {
        return this.objectId(new UUID());
    }

    public UUID objectId(UUID obj) {
        int o = this.__offset(8);
        return o != 0 ? obj.__assign(o + this.bb_pos, this.bb) : null;
    }

    public long baseOffset() {
        int o = this.__offset(10);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : 0L;
    }

    public int endOffsetDelta() {
        int o = this.__offset(12);
        return o != 0 ? this.bb.getInt(o + this.bb_pos) : 0;
    }

    public long maxTimestamp() {
        int o = this.__offset(14);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : 0L;
    }

    public int size() {
        int o = this.__offset(16);
        return o != 0 ? this.bb.getInt(o + this.bb_pos) : 0;
    }

    public boolean hasEpochState() {
        int o = this.__offset(18);
        return o != 0 ? 0 != this.bb.get(o + this.bb_pos) : false;
    }

    public boolean hasAbortedTxns() {
        int o = this.__offset(20);
        return o != 0 ? 0 != this.bb.get(o + this.bb_pos) : false;
    }

    public boolean hasProducerState() {
        int o = this.__offset(22);
        return o != 0 ? 0 != this.bb.get(o + this.bb_pos) : false;
    }

    public OffsetAndEpoch stateOffsetAndEpoch() {
        return this.stateOffsetAndEpoch(new OffsetAndEpoch());
    }

    public OffsetAndEpoch stateOffsetAndEpoch(OffsetAndEpoch obj) {
        int o = this.__offset(24);
        return o != 0 ? obj.__assign(o + this.bb_pos, this.bb) : null;
    }

    public OpaqueDataField opaqueData() {
        return this.opaqueData(new OpaqueDataField());
    }

    public OpaqueDataField opaqueData(OpaqueDataField obj) {
        int o = this.__offset(26);
        return o != 0 ? obj.__assign(o + this.bb_pos, this.bb) : null;
    }

    public long firstBatchTimestamp() {
        int o = this.__offset(28);
        return o != 0 ? this.bb.getLong(o + this.bb_pos) : -1L;
    }

    public byte uploadType() {
        int o = this.__offset(30);
        return o != 0 ? this.bb.get(o + this.bb_pos) : (byte)0;
    }

    public UUID previousObjectId() {
        return this.previousObjectId(new UUID());
    }

    public UUID previousObjectId(UUID obj) {
        int o = this.__offset(32);
        return o != 0 ? obj.__assign(o + this.bb_pos, this.bb) : null;
    }

    public FragmentDescription segmentAndMetadataLayout(int j) {
        return this.segmentAndMetadataLayout(new FragmentDescription(), j);
    }

    public FragmentDescription segmentAndMetadataLayout(FragmentDescription obj, int j) {
        int o = this.__offset(34);
        return o != 0 ? obj.__assign(this.__indirect(this.__vector(o) + j * 4), this.bb) : null;
    }

    public int segmentAndMetadataLayoutLength() {
        int o = this.__offset(34);
        return o != 0 ? this.__vector_len(o) : 0;
    }

    public FragmentDescription.Vector segmentAndMetadataLayoutVector() {
        return this.segmentAndMetadataLayoutVector(new FragmentDescription.Vector());
    }

    public FragmentDescription.Vector segmentAndMetadataLayoutVector(FragmentDescription.Vector obj) {
        int o = this.__offset(34);
        return o != 0 ? obj.__assign(this.__vector(o), 4, this.bb) : null;
    }

    public byte encryptedDek(int j) {
        int o = this.__offset(36);
        return o != 0 ? this.bb.get(this.__vector(o) + j * 1) : (byte)0;
    }

    public int encryptedDekLength() {
        int o = this.__offset(36);
        return o != 0 ? this.__vector_len(o) : 0;
    }

    public ByteVector encryptedDekVector() {
        return this.encryptedDekVector(new ByteVector());
    }

    public ByteVector encryptedDekVector(ByteVector obj) {
        int o = this.__offset(36);
        return o != 0 ? obj.__assign(this.__vector(o), this.bb) : null;
    }

    public ByteBuffer encryptedDekAsByteBuffer() {
        return this.__vector_as_bytebuffer(36, 1);
    }

    public ByteBuffer encryptedDekInByteBuffer(ByteBuffer _bb) {
        return this.__vector_in_bytebuffer(_bb, 36, 1);
    }

    public static void startSegmentUploadInitiate(FlatBufferBuilder builder) {
        builder.startTable(17);
    }

    public static void addVersion(FlatBufferBuilder builder, byte version) {
        builder.addByte(0, version, 0);
    }

    public static void addTierEpoch(FlatBufferBuilder builder, int tierEpoch) {
        builder.addInt(1, tierEpoch, 0);
    }

    public static void addObjectId(FlatBufferBuilder builder, int objectIdOffset) {
        builder.addStruct(2, objectIdOffset, 0);
    }

    public static void addBaseOffset(FlatBufferBuilder builder, long baseOffset) {
        builder.addLong(3, baseOffset, 0L);
    }

    public static void addEndOffsetDelta(FlatBufferBuilder builder, int endOffsetDelta) {
        builder.addInt(4, endOffsetDelta, 0);
    }

    public static void addMaxTimestamp(FlatBufferBuilder builder, long maxTimestamp) {
        builder.addLong(5, maxTimestamp, 0L);
    }

    public static void addSize(FlatBufferBuilder builder, int size) {
        builder.addInt(6, size, 0);
    }

    public static void addHasEpochState(FlatBufferBuilder builder, boolean hasEpochState) {
        builder.addBoolean(7, hasEpochState, false);
    }

    public static void addHasAbortedTxns(FlatBufferBuilder builder, boolean hasAbortedTxns) {
        builder.addBoolean(8, hasAbortedTxns, false);
    }

    public static void addHasProducerState(FlatBufferBuilder builder, boolean hasProducerState) {
        builder.addBoolean(9, hasProducerState, false);
    }

    public static void addStateOffsetAndEpoch(FlatBufferBuilder builder, int stateOffsetAndEpochOffset) {
        builder.addStruct(10, stateOffsetAndEpochOffset, 0);
    }

    public static void addOpaqueData(FlatBufferBuilder builder, int opaqueDataOffset) {
        builder.addStruct(11, opaqueDataOffset, 0);
    }

    public static void addFirstBatchTimestamp(FlatBufferBuilder builder, long firstBatchTimestamp) {
        builder.addLong(12, firstBatchTimestamp, -1L);
    }

    public static void addUploadType(FlatBufferBuilder builder, byte uploadType) {
        builder.addByte(13, uploadType, 0);
    }

    public static void addPreviousObjectId(FlatBufferBuilder builder, int previousObjectIdOffset) {
        builder.addStruct(14, previousObjectIdOffset, 0);
    }

    public static void addSegmentAndMetadataLayout(FlatBufferBuilder builder, int segmentAndMetadataLayoutOffset) {
        builder.addOffset(15, segmentAndMetadataLayoutOffset, 0);
    }

    public static int createSegmentAndMetadataLayoutVector(FlatBufferBuilder builder, int[] data) {
        builder.startVector(4, data.length, 4);
        for (int i = data.length - 1; i >= 0; --i) {
            builder.addOffset(data[i]);
        }
        return builder.endVector();
    }

    public static void startSegmentAndMetadataLayoutVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(4, numElems, 4);
    }

    public static void addEncryptedDek(FlatBufferBuilder builder, int encryptedDekOffset) {
        builder.addOffset(16, encryptedDekOffset, 0);
    }

    public static int createEncryptedDekVector(FlatBufferBuilder builder, byte[] data) {
        return builder.createByteVector(data);
    }

    public static int createEncryptedDekVector(FlatBufferBuilder builder, ByteBuffer data) {
        return builder.createByteVector(data);
    }

    public static void startEncryptedDekVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(1, numElems, 1);
    }

    public static int endSegmentUploadInitiate(FlatBufferBuilder builder) {
        int o = builder.endTable();
        return o;
    }

    public static void finishSegmentUploadInitiateBuffer(FlatBufferBuilder builder, int offset) {
        builder.finish(offset);
    }

    public static void finishSizePrefixedSegmentUploadInitiateBuffer(FlatBufferBuilder builder, int offset) {
        builder.finishSizePrefixed(offset);
    }

    public static final class Vector
    extends BaseVector {
        public Vector __assign(int _vector, int _element_size, ByteBuffer _bb) {
            this.__reset(_vector, _element_size, _bb);
            return this;
        }

        public SegmentUploadInitiate get(int j) {
            return this.get(new SegmentUploadInitiate(), j);
        }

        public SegmentUploadInitiate get(SegmentUploadInitiate obj, int j) {
            return obj.__assign(SegmentUploadInitiate.__indirect((int)this.__element(j), (ByteBuffer)this.bb), this.bb);
        }
    }
}

