/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.flink.apiserver.client;

import com.google.gson.reflect.TypeToken;
import io.confluent.flink.apiserver.client.ApiCallback;
import io.confluent.flink.apiserver.client.ApiClient;
import io.confluent.flink.apiserver.client.ApiException;
import io.confluent.flink.apiserver.client.ApiResponse;
import io.confluent.flink.apiserver.client.Configuration;
import io.confluent.flink.apiserver.client.Pair;
import io.confluent.flink.apiserver.client.model.ClusterlinkV1LogicalKafkaCluster;
import io.confluent.flink.apiserver.client.model.ClusterlinkV1LogicalKafkaClusterList;
import io.confluent.flink.apiserver.client.model.ClusterlinkV1Site;
import io.confluent.flink.apiserver.client.model.ClusterlinkV1SiteList;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class ClusterlinkV1Api {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ClusterlinkV1Api() {
        this(Configuration.getDefaultApiClient());
    }

    public ClusterlinkV1Api(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createClusterlinkV1LogicalKafkaClusterCall(String environment, String org, ClusterlinkV1LogicalKafkaCluster clusterlinkV1LogicalKafkaCluster, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ClusterlinkV1LogicalKafkaCluster localVarPostBody = clusterlinkV1LogicalKafkaCluster;
        String localVarPath = "/apis/clusterlink/v1/orgs/{org}/environments/{environment}/logicalkafkaclusters".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createClusterlinkV1LogicalKafkaClusterValidateBeforeCall(String environment, String org, ClusterlinkV1LogicalKafkaCluster clusterlinkV1LogicalKafkaCluster, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling createClusterlinkV1LogicalKafkaCluster(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling createClusterlinkV1LogicalKafkaCluster(Async)");
        }
        if (clusterlinkV1LogicalKafkaCluster == null) {
            throw new ApiException("Missing the required parameter 'clusterlinkV1LogicalKafkaCluster' when calling createClusterlinkV1LogicalKafkaCluster(Async)");
        }
        return this.createClusterlinkV1LogicalKafkaClusterCall(environment, org, clusterlinkV1LogicalKafkaCluster, _callback);
    }

    public ClusterlinkV1LogicalKafkaCluster createClusterlinkV1LogicalKafkaCluster(String environment, String org, ClusterlinkV1LogicalKafkaCluster clusterlinkV1LogicalKafkaCluster) throws ApiException {
        ApiResponse<ClusterlinkV1LogicalKafkaCluster> localVarResp = this.createClusterlinkV1LogicalKafkaClusterWithHttpInfo(environment, org, clusterlinkV1LogicalKafkaCluster);
        return localVarResp.getData();
    }

    public ApiResponse<ClusterlinkV1LogicalKafkaCluster> createClusterlinkV1LogicalKafkaClusterWithHttpInfo(String environment, String org, ClusterlinkV1LogicalKafkaCluster clusterlinkV1LogicalKafkaCluster) throws ApiException {
        Call localVarCall = this.createClusterlinkV1LogicalKafkaClusterValidateBeforeCall(environment, org, clusterlinkV1LogicalKafkaCluster, null);
        Type localVarReturnType = new TypeToken<ClusterlinkV1LogicalKafkaCluster>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createClusterlinkV1LogicalKafkaClusterAsync(String environment, String org, ClusterlinkV1LogicalKafkaCluster clusterlinkV1LogicalKafkaCluster, ApiCallback<ClusterlinkV1LogicalKafkaCluster> _callback) throws ApiException {
        Call localVarCall = this.createClusterlinkV1LogicalKafkaClusterValidateBeforeCall(environment, org, clusterlinkV1LogicalKafkaCluster, _callback);
        Type localVarReturnType = new TypeToken<ClusterlinkV1LogicalKafkaCluster>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createClusterlinkV1SiteCall(String environment, String org, ClusterlinkV1Site clusterlinkV1Site, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ClusterlinkV1Site localVarPostBody = clusterlinkV1Site;
        String localVarPath = "/apis/clusterlink/v1/orgs/{org}/environments/{environment}/sites".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createClusterlinkV1SiteValidateBeforeCall(String environment, String org, ClusterlinkV1Site clusterlinkV1Site, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling createClusterlinkV1Site(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling createClusterlinkV1Site(Async)");
        }
        if (clusterlinkV1Site == null) {
            throw new ApiException("Missing the required parameter 'clusterlinkV1Site' when calling createClusterlinkV1Site(Async)");
        }
        return this.createClusterlinkV1SiteCall(environment, org, clusterlinkV1Site, _callback);
    }

    public ClusterlinkV1Site createClusterlinkV1Site(String environment, String org, ClusterlinkV1Site clusterlinkV1Site) throws ApiException {
        ApiResponse<ClusterlinkV1Site> localVarResp = this.createClusterlinkV1SiteWithHttpInfo(environment, org, clusterlinkV1Site);
        return localVarResp.getData();
    }

    public ApiResponse<ClusterlinkV1Site> createClusterlinkV1SiteWithHttpInfo(String environment, String org, ClusterlinkV1Site clusterlinkV1Site) throws ApiException {
        Call localVarCall = this.createClusterlinkV1SiteValidateBeforeCall(environment, org, clusterlinkV1Site, null);
        Type localVarReturnType = new TypeToken<ClusterlinkV1Site>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createClusterlinkV1SiteAsync(String environment, String org, ClusterlinkV1Site clusterlinkV1Site, ApiCallback<ClusterlinkV1Site> _callback) throws ApiException {
        Call localVarCall = this.createClusterlinkV1SiteValidateBeforeCall(environment, org, clusterlinkV1Site, _callback);
        Type localVarReturnType = new TypeToken<ClusterlinkV1Site>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteClusterlinkV1LogicalKafkaClusterCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/clusterlink/v1/orgs/{org}/environments/{environment}/logicalkafkaclusters/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (uid != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("uid", uid));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteClusterlinkV1LogicalKafkaClusterValidateBeforeCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling deleteClusterlinkV1LogicalKafkaCluster(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteClusterlinkV1LogicalKafkaCluster(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling deleteClusterlinkV1LogicalKafkaCluster(Async)");
        }
        return this.deleteClusterlinkV1LogicalKafkaClusterCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
    }

    public ClusterlinkV1LogicalKafkaCluster deleteClusterlinkV1LogicalKafkaCluster(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        ApiResponse<ClusterlinkV1LogicalKafkaCluster> localVarResp = this.deleteClusterlinkV1LogicalKafkaClusterWithHttpInfo(environment, name, org, propagationPolicy, resourceVersion, uid);
        return localVarResp.getData();
    }

    public ApiResponse<ClusterlinkV1LogicalKafkaCluster> deleteClusterlinkV1LogicalKafkaClusterWithHttpInfo(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        Call localVarCall = this.deleteClusterlinkV1LogicalKafkaClusterValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, null);
        Type localVarReturnType = new TypeToken<ClusterlinkV1LogicalKafkaCluster>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteClusterlinkV1LogicalKafkaClusterAsync(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback<ClusterlinkV1LogicalKafkaCluster> _callback) throws ApiException {
        Call localVarCall = this.deleteClusterlinkV1LogicalKafkaClusterValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
        Type localVarReturnType = new TypeToken<ClusterlinkV1LogicalKafkaCluster>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteClusterlinkV1SiteCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/clusterlink/v1/orgs/{org}/environments/{environment}/sites/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (uid != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("uid", uid));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteClusterlinkV1SiteValidateBeforeCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling deleteClusterlinkV1Site(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteClusterlinkV1Site(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling deleteClusterlinkV1Site(Async)");
        }
        return this.deleteClusterlinkV1SiteCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
    }

    public ClusterlinkV1Site deleteClusterlinkV1Site(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        ApiResponse<ClusterlinkV1Site> localVarResp = this.deleteClusterlinkV1SiteWithHttpInfo(environment, name, org, propagationPolicy, resourceVersion, uid);
        return localVarResp.getData();
    }

    public ApiResponse<ClusterlinkV1Site> deleteClusterlinkV1SiteWithHttpInfo(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        Call localVarCall = this.deleteClusterlinkV1SiteValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, null);
        Type localVarReturnType = new TypeToken<ClusterlinkV1Site>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteClusterlinkV1SiteAsync(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback<ClusterlinkV1Site> _callback) throws ApiException {
        Call localVarCall = this.deleteClusterlinkV1SiteValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
        Type localVarReturnType = new TypeToken<ClusterlinkV1Site>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listClusterlinkV1LogicalKafkaClustersCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/clusterlink/v1/orgs/{org}/environments/{environment}/logicalkafkaclusters".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listClusterlinkV1LogicalKafkaClustersValidateBeforeCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling listClusterlinkV1LogicalKafkaClusters(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listClusterlinkV1LogicalKafkaClusters(Async)");
        }
        return this.listClusterlinkV1LogicalKafkaClustersCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public ClusterlinkV1LogicalKafkaClusterList listClusterlinkV1LogicalKafkaClusters(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<ClusterlinkV1LogicalKafkaClusterList> localVarResp = this.listClusterlinkV1LogicalKafkaClustersWithHttpInfo(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<ClusterlinkV1LogicalKafkaClusterList> listClusterlinkV1LogicalKafkaClustersWithHttpInfo(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listClusterlinkV1LogicalKafkaClustersValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<ClusterlinkV1LogicalKafkaClusterList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listClusterlinkV1LogicalKafkaClustersAsync(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<ClusterlinkV1LogicalKafkaClusterList> _callback) throws ApiException {
        Call localVarCall = this.listClusterlinkV1LogicalKafkaClustersValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<ClusterlinkV1LogicalKafkaClusterList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listClusterlinkV1LogicalKafkaClustersForAllEnvironmentsCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/clusterlink/v1/orgs/{org}/logicalkafkaclusters".replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listClusterlinkV1LogicalKafkaClustersForAllEnvironmentsValidateBeforeCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listClusterlinkV1LogicalKafkaClustersForAllEnvironments(Async)");
        }
        return this.listClusterlinkV1LogicalKafkaClustersForAllEnvironmentsCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public ClusterlinkV1LogicalKafkaClusterList listClusterlinkV1LogicalKafkaClustersForAllEnvironments(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<ClusterlinkV1LogicalKafkaClusterList> localVarResp = this.listClusterlinkV1LogicalKafkaClustersForAllEnvironmentsWithHttpInfo(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<ClusterlinkV1LogicalKafkaClusterList> listClusterlinkV1LogicalKafkaClustersForAllEnvironmentsWithHttpInfo(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listClusterlinkV1LogicalKafkaClustersForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<ClusterlinkV1LogicalKafkaClusterList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listClusterlinkV1LogicalKafkaClustersForAllEnvironmentsAsync(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<ClusterlinkV1LogicalKafkaClusterList> _callback) throws ApiException {
        Call localVarCall = this.listClusterlinkV1LogicalKafkaClustersForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<ClusterlinkV1LogicalKafkaClusterList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listClusterlinkV1SitesCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/clusterlink/v1/orgs/{org}/environments/{environment}/sites".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listClusterlinkV1SitesValidateBeforeCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling listClusterlinkV1Sites(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listClusterlinkV1Sites(Async)");
        }
        return this.listClusterlinkV1SitesCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public ClusterlinkV1SiteList listClusterlinkV1Sites(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<ClusterlinkV1SiteList> localVarResp = this.listClusterlinkV1SitesWithHttpInfo(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<ClusterlinkV1SiteList> listClusterlinkV1SitesWithHttpInfo(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listClusterlinkV1SitesValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<ClusterlinkV1SiteList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listClusterlinkV1SitesAsync(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<ClusterlinkV1SiteList> _callback) throws ApiException {
        Call localVarCall = this.listClusterlinkV1SitesValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<ClusterlinkV1SiteList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listClusterlinkV1SitesForAllEnvironmentsCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/clusterlink/v1/orgs/{org}/sites".replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listClusterlinkV1SitesForAllEnvironmentsValidateBeforeCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listClusterlinkV1SitesForAllEnvironments(Async)");
        }
        return this.listClusterlinkV1SitesForAllEnvironmentsCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public ClusterlinkV1SiteList listClusterlinkV1SitesForAllEnvironments(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<ClusterlinkV1SiteList> localVarResp = this.listClusterlinkV1SitesForAllEnvironmentsWithHttpInfo(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<ClusterlinkV1SiteList> listClusterlinkV1SitesForAllEnvironmentsWithHttpInfo(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listClusterlinkV1SitesForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<ClusterlinkV1SiteList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listClusterlinkV1SitesForAllEnvironmentsAsync(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<ClusterlinkV1SiteList> _callback) throws ApiException {
        Call localVarCall = this.listClusterlinkV1SitesForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<ClusterlinkV1SiteList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchClusterlinkV1LogicalKafkaClusterCall(String environment, String name, String org, ClusterlinkV1LogicalKafkaCluster clusterlinkV1LogicalKafkaCluster, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ClusterlinkV1LogicalKafkaCluster localVarPostBody = clusterlinkV1LogicalKafkaCluster;
        String localVarPath = "/apis/clusterlink/v1/orgs/{org}/environments/{environment}/logicalkafkaclusters/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchClusterlinkV1LogicalKafkaClusterValidateBeforeCall(String environment, String name, String org, ClusterlinkV1LogicalKafkaCluster clusterlinkV1LogicalKafkaCluster, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchClusterlinkV1LogicalKafkaCluster(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchClusterlinkV1LogicalKafkaCluster(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchClusterlinkV1LogicalKafkaCluster(Async)");
        }
        if (clusterlinkV1LogicalKafkaCluster == null) {
            throw new ApiException("Missing the required parameter 'clusterlinkV1LogicalKafkaCluster' when calling patchClusterlinkV1LogicalKafkaCluster(Async)");
        }
        return this.patchClusterlinkV1LogicalKafkaClusterCall(environment, name, org, clusterlinkV1LogicalKafkaCluster, _callback);
    }

    public ClusterlinkV1LogicalKafkaCluster patchClusterlinkV1LogicalKafkaCluster(String environment, String name, String org, ClusterlinkV1LogicalKafkaCluster clusterlinkV1LogicalKafkaCluster) throws ApiException {
        ApiResponse<ClusterlinkV1LogicalKafkaCluster> localVarResp = this.patchClusterlinkV1LogicalKafkaClusterWithHttpInfo(environment, name, org, clusterlinkV1LogicalKafkaCluster);
        return localVarResp.getData();
    }

    public ApiResponse<ClusterlinkV1LogicalKafkaCluster> patchClusterlinkV1LogicalKafkaClusterWithHttpInfo(String environment, String name, String org, ClusterlinkV1LogicalKafkaCluster clusterlinkV1LogicalKafkaCluster) throws ApiException {
        Call localVarCall = this.patchClusterlinkV1LogicalKafkaClusterValidateBeforeCall(environment, name, org, clusterlinkV1LogicalKafkaCluster, null);
        Type localVarReturnType = new TypeToken<ClusterlinkV1LogicalKafkaCluster>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchClusterlinkV1LogicalKafkaClusterAsync(String environment, String name, String org, ClusterlinkV1LogicalKafkaCluster clusterlinkV1LogicalKafkaCluster, ApiCallback<ClusterlinkV1LogicalKafkaCluster> _callback) throws ApiException {
        Call localVarCall = this.patchClusterlinkV1LogicalKafkaClusterValidateBeforeCall(environment, name, org, clusterlinkV1LogicalKafkaCluster, _callback);
        Type localVarReturnType = new TypeToken<ClusterlinkV1LogicalKafkaCluster>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchClusterlinkV1SiteCall(String environment, String name, String org, ClusterlinkV1Site clusterlinkV1Site, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ClusterlinkV1Site localVarPostBody = clusterlinkV1Site;
        String localVarPath = "/apis/clusterlink/v1/orgs/{org}/environments/{environment}/sites/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchClusterlinkV1SiteValidateBeforeCall(String environment, String name, String org, ClusterlinkV1Site clusterlinkV1Site, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchClusterlinkV1Site(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchClusterlinkV1Site(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchClusterlinkV1Site(Async)");
        }
        if (clusterlinkV1Site == null) {
            throw new ApiException("Missing the required parameter 'clusterlinkV1Site' when calling patchClusterlinkV1Site(Async)");
        }
        return this.patchClusterlinkV1SiteCall(environment, name, org, clusterlinkV1Site, _callback);
    }

    public ClusterlinkV1Site patchClusterlinkV1Site(String environment, String name, String org, ClusterlinkV1Site clusterlinkV1Site) throws ApiException {
        ApiResponse<ClusterlinkV1Site> localVarResp = this.patchClusterlinkV1SiteWithHttpInfo(environment, name, org, clusterlinkV1Site);
        return localVarResp.getData();
    }

    public ApiResponse<ClusterlinkV1Site> patchClusterlinkV1SiteWithHttpInfo(String environment, String name, String org, ClusterlinkV1Site clusterlinkV1Site) throws ApiException {
        Call localVarCall = this.patchClusterlinkV1SiteValidateBeforeCall(environment, name, org, clusterlinkV1Site, null);
        Type localVarReturnType = new TypeToken<ClusterlinkV1Site>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchClusterlinkV1SiteAsync(String environment, String name, String org, ClusterlinkV1Site clusterlinkV1Site, ApiCallback<ClusterlinkV1Site> _callback) throws ApiException {
        Call localVarCall = this.patchClusterlinkV1SiteValidateBeforeCall(environment, name, org, clusterlinkV1Site, _callback);
        Type localVarReturnType = new TypeToken<ClusterlinkV1Site>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readClusterlinkV1LogicalKafkaClusterCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/clusterlink/v1/orgs/{org}/environments/{environment}/logicalkafkaclusters/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readClusterlinkV1LogicalKafkaClusterValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readClusterlinkV1LogicalKafkaCluster(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readClusterlinkV1LogicalKafkaCluster(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readClusterlinkV1LogicalKafkaCluster(Async)");
        }
        return this.readClusterlinkV1LogicalKafkaClusterCall(environment, name, org, resourceVersion, _callback);
    }

    public ClusterlinkV1LogicalKafkaCluster readClusterlinkV1LogicalKafkaCluster(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<ClusterlinkV1LogicalKafkaCluster> localVarResp = this.readClusterlinkV1LogicalKafkaClusterWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<ClusterlinkV1LogicalKafkaCluster> readClusterlinkV1LogicalKafkaClusterWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readClusterlinkV1LogicalKafkaClusterValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<ClusterlinkV1LogicalKafkaCluster>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readClusterlinkV1LogicalKafkaClusterAsync(String environment, String name, String org, String resourceVersion, ApiCallback<ClusterlinkV1LogicalKafkaCluster> _callback) throws ApiException {
        Call localVarCall = this.readClusterlinkV1LogicalKafkaClusterValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<ClusterlinkV1LogicalKafkaCluster>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readClusterlinkV1SiteCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/clusterlink/v1/orgs/{org}/environments/{environment}/sites/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readClusterlinkV1SiteValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readClusterlinkV1Site(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readClusterlinkV1Site(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readClusterlinkV1Site(Async)");
        }
        return this.readClusterlinkV1SiteCall(environment, name, org, resourceVersion, _callback);
    }

    public ClusterlinkV1Site readClusterlinkV1Site(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<ClusterlinkV1Site> localVarResp = this.readClusterlinkV1SiteWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<ClusterlinkV1Site> readClusterlinkV1SiteWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readClusterlinkV1SiteValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<ClusterlinkV1Site>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readClusterlinkV1SiteAsync(String environment, String name, String org, String resourceVersion, ApiCallback<ClusterlinkV1Site> _callback) throws ApiException {
        Call localVarCall = this.readClusterlinkV1SiteValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<ClusterlinkV1Site>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateClusterlinkV1LogicalKafkaClusterCall(String environment, String name, String org, ClusterlinkV1LogicalKafkaCluster clusterlinkV1LogicalKafkaCluster, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ClusterlinkV1LogicalKafkaCluster localVarPostBody = clusterlinkV1LogicalKafkaCluster;
        String localVarPath = "/apis/clusterlink/v1/orgs/{org}/environments/{environment}/logicalkafkaclusters/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateClusterlinkV1LogicalKafkaClusterValidateBeforeCall(String environment, String name, String org, ClusterlinkV1LogicalKafkaCluster clusterlinkV1LogicalKafkaCluster, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateClusterlinkV1LogicalKafkaCluster(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateClusterlinkV1LogicalKafkaCluster(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateClusterlinkV1LogicalKafkaCluster(Async)");
        }
        if (clusterlinkV1LogicalKafkaCluster == null) {
            throw new ApiException("Missing the required parameter 'clusterlinkV1LogicalKafkaCluster' when calling updateClusterlinkV1LogicalKafkaCluster(Async)");
        }
        return this.updateClusterlinkV1LogicalKafkaClusterCall(environment, name, org, clusterlinkV1LogicalKafkaCluster, _callback);
    }

    public ClusterlinkV1LogicalKafkaCluster updateClusterlinkV1LogicalKafkaCluster(String environment, String name, String org, ClusterlinkV1LogicalKafkaCluster clusterlinkV1LogicalKafkaCluster) throws ApiException {
        ApiResponse<ClusterlinkV1LogicalKafkaCluster> localVarResp = this.updateClusterlinkV1LogicalKafkaClusterWithHttpInfo(environment, name, org, clusterlinkV1LogicalKafkaCluster);
        return localVarResp.getData();
    }

    public ApiResponse<ClusterlinkV1LogicalKafkaCluster> updateClusterlinkV1LogicalKafkaClusterWithHttpInfo(String environment, String name, String org, ClusterlinkV1LogicalKafkaCluster clusterlinkV1LogicalKafkaCluster) throws ApiException {
        Call localVarCall = this.updateClusterlinkV1LogicalKafkaClusterValidateBeforeCall(environment, name, org, clusterlinkV1LogicalKafkaCluster, null);
        Type localVarReturnType = new TypeToken<ClusterlinkV1LogicalKafkaCluster>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateClusterlinkV1LogicalKafkaClusterAsync(String environment, String name, String org, ClusterlinkV1LogicalKafkaCluster clusterlinkV1LogicalKafkaCluster, ApiCallback<ClusterlinkV1LogicalKafkaCluster> _callback) throws ApiException {
        Call localVarCall = this.updateClusterlinkV1LogicalKafkaClusterValidateBeforeCall(environment, name, org, clusterlinkV1LogicalKafkaCluster, _callback);
        Type localVarReturnType = new TypeToken<ClusterlinkV1LogicalKafkaCluster>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateClusterlinkV1SiteCall(String environment, String name, String org, ClusterlinkV1Site clusterlinkV1Site, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ClusterlinkV1Site localVarPostBody = clusterlinkV1Site;
        String localVarPath = "/apis/clusterlink/v1/orgs/{org}/environments/{environment}/sites/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateClusterlinkV1SiteValidateBeforeCall(String environment, String name, String org, ClusterlinkV1Site clusterlinkV1Site, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateClusterlinkV1Site(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateClusterlinkV1Site(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateClusterlinkV1Site(Async)");
        }
        if (clusterlinkV1Site == null) {
            throw new ApiException("Missing the required parameter 'clusterlinkV1Site' when calling updateClusterlinkV1Site(Async)");
        }
        return this.updateClusterlinkV1SiteCall(environment, name, org, clusterlinkV1Site, _callback);
    }

    public ClusterlinkV1Site updateClusterlinkV1Site(String environment, String name, String org, ClusterlinkV1Site clusterlinkV1Site) throws ApiException {
        ApiResponse<ClusterlinkV1Site> localVarResp = this.updateClusterlinkV1SiteWithHttpInfo(environment, name, org, clusterlinkV1Site);
        return localVarResp.getData();
    }

    public ApiResponse<ClusterlinkV1Site> updateClusterlinkV1SiteWithHttpInfo(String environment, String name, String org, ClusterlinkV1Site clusterlinkV1Site) throws ApiException {
        Call localVarCall = this.updateClusterlinkV1SiteValidateBeforeCall(environment, name, org, clusterlinkV1Site, null);
        Type localVarReturnType = new TypeToken<ClusterlinkV1Site>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateClusterlinkV1SiteAsync(String environment, String name, String org, ClusterlinkV1Site clusterlinkV1Site, ApiCallback<ClusterlinkV1Site> _callback) throws ApiException {
        Call localVarCall = this.updateClusterlinkV1SiteValidateBeforeCall(environment, name, org, clusterlinkV1Site, _callback);
        Type localVarReturnType = new TypeToken<ClusterlinkV1Site>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

