/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.flink.apiserver.client;

import com.google.gson.reflect.TypeToken;
import io.confluent.flink.apiserver.client.ApiCallback;
import io.confluent.flink.apiserver.client.ApiClient;
import io.confluent.flink.apiserver.client.ApiException;
import io.confluent.flink.apiserver.client.ApiResponse;
import io.confluent.flink.apiserver.client.Configuration;
import io.confluent.flink.apiserver.client.Pair;
import io.confluent.flink.apiserver.client.model.ComputeV1FlinkUdfTask;
import io.confluent.flink.apiserver.client.model.ComputeV1FlinkUdfTaskList;
import io.confluent.flink.apiserver.client.model.ComputeV1ServiceInstance;
import io.confluent.flink.apiserver.client.model.ComputeV1ServiceInstanceList;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class ComputeV1Api {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ComputeV1Api() {
        this(Configuration.getDefaultApiClient());
    }

    public ComputeV1Api(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createComputeV1FlinkUdfTaskCall(String environment, String org, ComputeV1FlinkUdfTask computeV1FlinkUdfTask, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ComputeV1FlinkUdfTask localVarPostBody = computeV1FlinkUdfTask;
        String localVarPath = "/apis/compute/v1/orgs/{org}/environments/{environment}/flinkudftasks".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createComputeV1FlinkUdfTaskValidateBeforeCall(String environment, String org, ComputeV1FlinkUdfTask computeV1FlinkUdfTask, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling createComputeV1FlinkUdfTask(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling createComputeV1FlinkUdfTask(Async)");
        }
        if (computeV1FlinkUdfTask == null) {
            throw new ApiException("Missing the required parameter 'computeV1FlinkUdfTask' when calling createComputeV1FlinkUdfTask(Async)");
        }
        return this.createComputeV1FlinkUdfTaskCall(environment, org, computeV1FlinkUdfTask, _callback);
    }

    public ComputeV1FlinkUdfTask createComputeV1FlinkUdfTask(String environment, String org, ComputeV1FlinkUdfTask computeV1FlinkUdfTask) throws ApiException {
        ApiResponse<ComputeV1FlinkUdfTask> localVarResp = this.createComputeV1FlinkUdfTaskWithHttpInfo(environment, org, computeV1FlinkUdfTask);
        return localVarResp.getData();
    }

    public ApiResponse<ComputeV1FlinkUdfTask> createComputeV1FlinkUdfTaskWithHttpInfo(String environment, String org, ComputeV1FlinkUdfTask computeV1FlinkUdfTask) throws ApiException {
        Call localVarCall = this.createComputeV1FlinkUdfTaskValidateBeforeCall(environment, org, computeV1FlinkUdfTask, null);
        Type localVarReturnType = new TypeToken<ComputeV1FlinkUdfTask>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createComputeV1FlinkUdfTaskAsync(String environment, String org, ComputeV1FlinkUdfTask computeV1FlinkUdfTask, ApiCallback<ComputeV1FlinkUdfTask> _callback) throws ApiException {
        Call localVarCall = this.createComputeV1FlinkUdfTaskValidateBeforeCall(environment, org, computeV1FlinkUdfTask, _callback);
        Type localVarReturnType = new TypeToken<ComputeV1FlinkUdfTask>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createComputeV1ServiceInstanceCall(String environment, String org, ComputeV1ServiceInstance computeV1ServiceInstance, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ComputeV1ServiceInstance localVarPostBody = computeV1ServiceInstance;
        String localVarPath = "/apis/compute/v1/orgs/{org}/environments/{environment}/serviceinstances".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createComputeV1ServiceInstanceValidateBeforeCall(String environment, String org, ComputeV1ServiceInstance computeV1ServiceInstance, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling createComputeV1ServiceInstance(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling createComputeV1ServiceInstance(Async)");
        }
        if (computeV1ServiceInstance == null) {
            throw new ApiException("Missing the required parameter 'computeV1ServiceInstance' when calling createComputeV1ServiceInstance(Async)");
        }
        return this.createComputeV1ServiceInstanceCall(environment, org, computeV1ServiceInstance, _callback);
    }

    public ComputeV1ServiceInstance createComputeV1ServiceInstance(String environment, String org, ComputeV1ServiceInstance computeV1ServiceInstance) throws ApiException {
        ApiResponse<ComputeV1ServiceInstance> localVarResp = this.createComputeV1ServiceInstanceWithHttpInfo(environment, org, computeV1ServiceInstance);
        return localVarResp.getData();
    }

    public ApiResponse<ComputeV1ServiceInstance> createComputeV1ServiceInstanceWithHttpInfo(String environment, String org, ComputeV1ServiceInstance computeV1ServiceInstance) throws ApiException {
        Call localVarCall = this.createComputeV1ServiceInstanceValidateBeforeCall(environment, org, computeV1ServiceInstance, null);
        Type localVarReturnType = new TypeToken<ComputeV1ServiceInstance>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createComputeV1ServiceInstanceAsync(String environment, String org, ComputeV1ServiceInstance computeV1ServiceInstance, ApiCallback<ComputeV1ServiceInstance> _callback) throws ApiException {
        Call localVarCall = this.createComputeV1ServiceInstanceValidateBeforeCall(environment, org, computeV1ServiceInstance, _callback);
        Type localVarReturnType = new TypeToken<ComputeV1ServiceInstance>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteComputeV1FlinkUdfTaskCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/compute/v1/orgs/{org}/environments/{environment}/flinkudftasks/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (uid != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("uid", uid));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteComputeV1FlinkUdfTaskValidateBeforeCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling deleteComputeV1FlinkUdfTask(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteComputeV1FlinkUdfTask(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling deleteComputeV1FlinkUdfTask(Async)");
        }
        return this.deleteComputeV1FlinkUdfTaskCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
    }

    public ComputeV1FlinkUdfTask deleteComputeV1FlinkUdfTask(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        ApiResponse<ComputeV1FlinkUdfTask> localVarResp = this.deleteComputeV1FlinkUdfTaskWithHttpInfo(environment, name, org, propagationPolicy, resourceVersion, uid);
        return localVarResp.getData();
    }

    public ApiResponse<ComputeV1FlinkUdfTask> deleteComputeV1FlinkUdfTaskWithHttpInfo(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        Call localVarCall = this.deleteComputeV1FlinkUdfTaskValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, null);
        Type localVarReturnType = new TypeToken<ComputeV1FlinkUdfTask>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteComputeV1FlinkUdfTaskAsync(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback<ComputeV1FlinkUdfTask> _callback) throws ApiException {
        Call localVarCall = this.deleteComputeV1FlinkUdfTaskValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
        Type localVarReturnType = new TypeToken<ComputeV1FlinkUdfTask>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteComputeV1ServiceInstanceCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/compute/v1/orgs/{org}/environments/{environment}/serviceinstances/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (uid != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("uid", uid));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteComputeV1ServiceInstanceValidateBeforeCall(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling deleteComputeV1ServiceInstance(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteComputeV1ServiceInstance(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling deleteComputeV1ServiceInstance(Async)");
        }
        return this.deleteComputeV1ServiceInstanceCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
    }

    public ComputeV1ServiceInstance deleteComputeV1ServiceInstance(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        ApiResponse<ComputeV1ServiceInstance> localVarResp = this.deleteComputeV1ServiceInstanceWithHttpInfo(environment, name, org, propagationPolicy, resourceVersion, uid);
        return localVarResp.getData();
    }

    public ApiResponse<ComputeV1ServiceInstance> deleteComputeV1ServiceInstanceWithHttpInfo(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid) throws ApiException {
        Call localVarCall = this.deleteComputeV1ServiceInstanceValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, null);
        Type localVarReturnType = new TypeToken<ComputeV1ServiceInstance>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteComputeV1ServiceInstanceAsync(String environment, String name, String org, String propagationPolicy, String resourceVersion, String uid, ApiCallback<ComputeV1ServiceInstance> _callback) throws ApiException {
        Call localVarCall = this.deleteComputeV1ServiceInstanceValidateBeforeCall(environment, name, org, propagationPolicy, resourceVersion, uid, _callback);
        Type localVarReturnType = new TypeToken<ComputeV1ServiceInstance>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listComputeV1FlinkUdfTasksCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/compute/v1/orgs/{org}/environments/{environment}/flinkudftasks".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listComputeV1FlinkUdfTasksValidateBeforeCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling listComputeV1FlinkUdfTasks(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listComputeV1FlinkUdfTasks(Async)");
        }
        return this.listComputeV1FlinkUdfTasksCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public ComputeV1FlinkUdfTaskList listComputeV1FlinkUdfTasks(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<ComputeV1FlinkUdfTaskList> localVarResp = this.listComputeV1FlinkUdfTasksWithHttpInfo(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<ComputeV1FlinkUdfTaskList> listComputeV1FlinkUdfTasksWithHttpInfo(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listComputeV1FlinkUdfTasksValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<ComputeV1FlinkUdfTaskList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listComputeV1FlinkUdfTasksAsync(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<ComputeV1FlinkUdfTaskList> _callback) throws ApiException {
        Call localVarCall = this.listComputeV1FlinkUdfTasksValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<ComputeV1FlinkUdfTaskList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listComputeV1FlinkUdfTasksForAllEnvironmentsCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/compute/v1/orgs/{org}/flinkudftasks".replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listComputeV1FlinkUdfTasksForAllEnvironmentsValidateBeforeCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listComputeV1FlinkUdfTasksForAllEnvironments(Async)");
        }
        return this.listComputeV1FlinkUdfTasksForAllEnvironmentsCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public ComputeV1FlinkUdfTaskList listComputeV1FlinkUdfTasksForAllEnvironments(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<ComputeV1FlinkUdfTaskList> localVarResp = this.listComputeV1FlinkUdfTasksForAllEnvironmentsWithHttpInfo(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<ComputeV1FlinkUdfTaskList> listComputeV1FlinkUdfTasksForAllEnvironmentsWithHttpInfo(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listComputeV1FlinkUdfTasksForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<ComputeV1FlinkUdfTaskList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listComputeV1FlinkUdfTasksForAllEnvironmentsAsync(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<ComputeV1FlinkUdfTaskList> _callback) throws ApiException {
        Call localVarCall = this.listComputeV1FlinkUdfTasksForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<ComputeV1FlinkUdfTaskList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listComputeV1ServiceInstancesCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/compute/v1/orgs/{org}/environments/{environment}/serviceinstances".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listComputeV1ServiceInstancesValidateBeforeCall(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling listComputeV1ServiceInstances(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listComputeV1ServiceInstances(Async)");
        }
        return this.listComputeV1ServiceInstancesCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public ComputeV1ServiceInstanceList listComputeV1ServiceInstances(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<ComputeV1ServiceInstanceList> localVarResp = this.listComputeV1ServiceInstancesWithHttpInfo(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<ComputeV1ServiceInstanceList> listComputeV1ServiceInstancesWithHttpInfo(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listComputeV1ServiceInstancesValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<ComputeV1ServiceInstanceList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listComputeV1ServiceInstancesAsync(String environment, String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<ComputeV1ServiceInstanceList> _callback) throws ApiException {
        Call localVarCall = this.listComputeV1ServiceInstancesValidateBeforeCall(environment, org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<ComputeV1ServiceInstanceList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listComputeV1ServiceInstancesForAllEnvironmentsCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/compute/v1/orgs/{org}/serviceinstances".replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (eventuallyConsistent != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("eventuallyConsistent", eventuallyConsistent));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listComputeV1ServiceInstancesForAllEnvironmentsValidateBeforeCall(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback _callback) throws ApiException {
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling listComputeV1ServiceInstancesForAllEnvironments(Async)");
        }
        return this.listComputeV1ServiceInstancesForAllEnvironmentsCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
    }

    public ComputeV1ServiceInstanceList listComputeV1ServiceInstancesForAllEnvironments(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        ApiResponse<ComputeV1ServiceInstanceList> localVarResp = this.listComputeV1ServiceInstancesForAllEnvironmentsWithHttpInfo(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit);
        return localVarResp.getData();
    }

    public ApiResponse<ComputeV1ServiceInstanceList> listComputeV1ServiceInstancesForAllEnvironmentsWithHttpInfo(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit) throws ApiException {
        Call localVarCall = this.listComputeV1ServiceInstancesForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, null);
        Type localVarReturnType = new TypeToken<ComputeV1ServiceInstanceList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listComputeV1ServiceInstancesForAllEnvironmentsAsync(String org, String _continue, Boolean eventuallyConsistent, String fieldSelector, String labelSelector, Integer limit, ApiCallback<ComputeV1ServiceInstanceList> _callback) throws ApiException {
        Call localVarCall = this.listComputeV1ServiceInstancesForAllEnvironmentsValidateBeforeCall(org, _continue, eventuallyConsistent, fieldSelector, labelSelector, limit, _callback);
        Type localVarReturnType = new TypeToken<ComputeV1ServiceInstanceList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchComputeV1FlinkUdfTaskCall(String environment, String name, String org, ComputeV1FlinkUdfTask computeV1FlinkUdfTask, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ComputeV1FlinkUdfTask localVarPostBody = computeV1FlinkUdfTask;
        String localVarPath = "/apis/compute/v1/orgs/{org}/environments/{environment}/flinkudftasks/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchComputeV1FlinkUdfTaskValidateBeforeCall(String environment, String name, String org, ComputeV1FlinkUdfTask computeV1FlinkUdfTask, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchComputeV1FlinkUdfTask(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchComputeV1FlinkUdfTask(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchComputeV1FlinkUdfTask(Async)");
        }
        if (computeV1FlinkUdfTask == null) {
            throw new ApiException("Missing the required parameter 'computeV1FlinkUdfTask' when calling patchComputeV1FlinkUdfTask(Async)");
        }
        return this.patchComputeV1FlinkUdfTaskCall(environment, name, org, computeV1FlinkUdfTask, _callback);
    }

    public ComputeV1FlinkUdfTask patchComputeV1FlinkUdfTask(String environment, String name, String org, ComputeV1FlinkUdfTask computeV1FlinkUdfTask) throws ApiException {
        ApiResponse<ComputeV1FlinkUdfTask> localVarResp = this.patchComputeV1FlinkUdfTaskWithHttpInfo(environment, name, org, computeV1FlinkUdfTask);
        return localVarResp.getData();
    }

    public ApiResponse<ComputeV1FlinkUdfTask> patchComputeV1FlinkUdfTaskWithHttpInfo(String environment, String name, String org, ComputeV1FlinkUdfTask computeV1FlinkUdfTask) throws ApiException {
        Call localVarCall = this.patchComputeV1FlinkUdfTaskValidateBeforeCall(environment, name, org, computeV1FlinkUdfTask, null);
        Type localVarReturnType = new TypeToken<ComputeV1FlinkUdfTask>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchComputeV1FlinkUdfTaskAsync(String environment, String name, String org, ComputeV1FlinkUdfTask computeV1FlinkUdfTask, ApiCallback<ComputeV1FlinkUdfTask> _callback) throws ApiException {
        Call localVarCall = this.patchComputeV1FlinkUdfTaskValidateBeforeCall(environment, name, org, computeV1FlinkUdfTask, _callback);
        Type localVarReturnType = new TypeToken<ComputeV1FlinkUdfTask>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchComputeV1FlinkUdfTaskFinalizersCall(String environment, String name, String org, ComputeV1FlinkUdfTask computeV1FlinkUdfTask, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ComputeV1FlinkUdfTask localVarPostBody = computeV1FlinkUdfTask;
        String localVarPath = "/apis/compute/v1/orgs/{org}/environments/{environment}/flinkudftasks/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchComputeV1FlinkUdfTaskFinalizersValidateBeforeCall(String environment, String name, String org, ComputeV1FlinkUdfTask computeV1FlinkUdfTask, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchComputeV1FlinkUdfTaskFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchComputeV1FlinkUdfTaskFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchComputeV1FlinkUdfTaskFinalizers(Async)");
        }
        if (computeV1FlinkUdfTask == null) {
            throw new ApiException("Missing the required parameter 'computeV1FlinkUdfTask' when calling patchComputeV1FlinkUdfTaskFinalizers(Async)");
        }
        return this.patchComputeV1FlinkUdfTaskFinalizersCall(environment, name, org, computeV1FlinkUdfTask, _callback);
    }

    public ComputeV1FlinkUdfTask patchComputeV1FlinkUdfTaskFinalizers(String environment, String name, String org, ComputeV1FlinkUdfTask computeV1FlinkUdfTask) throws ApiException {
        ApiResponse<ComputeV1FlinkUdfTask> localVarResp = this.patchComputeV1FlinkUdfTaskFinalizersWithHttpInfo(environment, name, org, computeV1FlinkUdfTask);
        return localVarResp.getData();
    }

    public ApiResponse<ComputeV1FlinkUdfTask> patchComputeV1FlinkUdfTaskFinalizersWithHttpInfo(String environment, String name, String org, ComputeV1FlinkUdfTask computeV1FlinkUdfTask) throws ApiException {
        Call localVarCall = this.patchComputeV1FlinkUdfTaskFinalizersValidateBeforeCall(environment, name, org, computeV1FlinkUdfTask, null);
        Type localVarReturnType = new TypeToken<ComputeV1FlinkUdfTask>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchComputeV1FlinkUdfTaskFinalizersAsync(String environment, String name, String org, ComputeV1FlinkUdfTask computeV1FlinkUdfTask, ApiCallback<ComputeV1FlinkUdfTask> _callback) throws ApiException {
        Call localVarCall = this.patchComputeV1FlinkUdfTaskFinalizersValidateBeforeCall(environment, name, org, computeV1FlinkUdfTask, _callback);
        Type localVarReturnType = new TypeToken<ComputeV1FlinkUdfTask>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchComputeV1FlinkUdfTaskStatusCall(String environment, String name, String org, ComputeV1FlinkUdfTask computeV1FlinkUdfTask, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ComputeV1FlinkUdfTask localVarPostBody = computeV1FlinkUdfTask;
        String localVarPath = "/apis/compute/v1/orgs/{org}/environments/{environment}/flinkudftasks/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchComputeV1FlinkUdfTaskStatusValidateBeforeCall(String environment, String name, String org, ComputeV1FlinkUdfTask computeV1FlinkUdfTask, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchComputeV1FlinkUdfTaskStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchComputeV1FlinkUdfTaskStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchComputeV1FlinkUdfTaskStatus(Async)");
        }
        if (computeV1FlinkUdfTask == null) {
            throw new ApiException("Missing the required parameter 'computeV1FlinkUdfTask' when calling patchComputeV1FlinkUdfTaskStatus(Async)");
        }
        return this.patchComputeV1FlinkUdfTaskStatusCall(environment, name, org, computeV1FlinkUdfTask, _callback);
    }

    public ComputeV1FlinkUdfTask patchComputeV1FlinkUdfTaskStatus(String environment, String name, String org, ComputeV1FlinkUdfTask computeV1FlinkUdfTask) throws ApiException {
        ApiResponse<ComputeV1FlinkUdfTask> localVarResp = this.patchComputeV1FlinkUdfTaskStatusWithHttpInfo(environment, name, org, computeV1FlinkUdfTask);
        return localVarResp.getData();
    }

    public ApiResponse<ComputeV1FlinkUdfTask> patchComputeV1FlinkUdfTaskStatusWithHttpInfo(String environment, String name, String org, ComputeV1FlinkUdfTask computeV1FlinkUdfTask) throws ApiException {
        Call localVarCall = this.patchComputeV1FlinkUdfTaskStatusValidateBeforeCall(environment, name, org, computeV1FlinkUdfTask, null);
        Type localVarReturnType = new TypeToken<ComputeV1FlinkUdfTask>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchComputeV1FlinkUdfTaskStatusAsync(String environment, String name, String org, ComputeV1FlinkUdfTask computeV1FlinkUdfTask, ApiCallback<ComputeV1FlinkUdfTask> _callback) throws ApiException {
        Call localVarCall = this.patchComputeV1FlinkUdfTaskStatusValidateBeforeCall(environment, name, org, computeV1FlinkUdfTask, _callback);
        Type localVarReturnType = new TypeToken<ComputeV1FlinkUdfTask>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchComputeV1ServiceInstanceCall(String environment, String name, String org, ComputeV1ServiceInstance computeV1ServiceInstance, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ComputeV1ServiceInstance localVarPostBody = computeV1ServiceInstance;
        String localVarPath = "/apis/compute/v1/orgs/{org}/environments/{environment}/serviceinstances/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchComputeV1ServiceInstanceValidateBeforeCall(String environment, String name, String org, ComputeV1ServiceInstance computeV1ServiceInstance, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchComputeV1ServiceInstance(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchComputeV1ServiceInstance(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchComputeV1ServiceInstance(Async)");
        }
        if (computeV1ServiceInstance == null) {
            throw new ApiException("Missing the required parameter 'computeV1ServiceInstance' when calling patchComputeV1ServiceInstance(Async)");
        }
        return this.patchComputeV1ServiceInstanceCall(environment, name, org, computeV1ServiceInstance, _callback);
    }

    public ComputeV1ServiceInstance patchComputeV1ServiceInstance(String environment, String name, String org, ComputeV1ServiceInstance computeV1ServiceInstance) throws ApiException {
        ApiResponse<ComputeV1ServiceInstance> localVarResp = this.patchComputeV1ServiceInstanceWithHttpInfo(environment, name, org, computeV1ServiceInstance);
        return localVarResp.getData();
    }

    public ApiResponse<ComputeV1ServiceInstance> patchComputeV1ServiceInstanceWithHttpInfo(String environment, String name, String org, ComputeV1ServiceInstance computeV1ServiceInstance) throws ApiException {
        Call localVarCall = this.patchComputeV1ServiceInstanceValidateBeforeCall(environment, name, org, computeV1ServiceInstance, null);
        Type localVarReturnType = new TypeToken<ComputeV1ServiceInstance>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchComputeV1ServiceInstanceAsync(String environment, String name, String org, ComputeV1ServiceInstance computeV1ServiceInstance, ApiCallback<ComputeV1ServiceInstance> _callback) throws ApiException {
        Call localVarCall = this.patchComputeV1ServiceInstanceValidateBeforeCall(environment, name, org, computeV1ServiceInstance, _callback);
        Type localVarReturnType = new TypeToken<ComputeV1ServiceInstance>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchComputeV1ServiceInstanceFinalizersCall(String environment, String name, String org, ComputeV1ServiceInstance computeV1ServiceInstance, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ComputeV1ServiceInstance localVarPostBody = computeV1ServiceInstance;
        String localVarPath = "/apis/compute/v1/orgs/{org}/environments/{environment}/serviceinstances/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchComputeV1ServiceInstanceFinalizersValidateBeforeCall(String environment, String name, String org, ComputeV1ServiceInstance computeV1ServiceInstance, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchComputeV1ServiceInstanceFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchComputeV1ServiceInstanceFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchComputeV1ServiceInstanceFinalizers(Async)");
        }
        if (computeV1ServiceInstance == null) {
            throw new ApiException("Missing the required parameter 'computeV1ServiceInstance' when calling patchComputeV1ServiceInstanceFinalizers(Async)");
        }
        return this.patchComputeV1ServiceInstanceFinalizersCall(environment, name, org, computeV1ServiceInstance, _callback);
    }

    public ComputeV1ServiceInstance patchComputeV1ServiceInstanceFinalizers(String environment, String name, String org, ComputeV1ServiceInstance computeV1ServiceInstance) throws ApiException {
        ApiResponse<ComputeV1ServiceInstance> localVarResp = this.patchComputeV1ServiceInstanceFinalizersWithHttpInfo(environment, name, org, computeV1ServiceInstance);
        return localVarResp.getData();
    }

    public ApiResponse<ComputeV1ServiceInstance> patchComputeV1ServiceInstanceFinalizersWithHttpInfo(String environment, String name, String org, ComputeV1ServiceInstance computeV1ServiceInstance) throws ApiException {
        Call localVarCall = this.patchComputeV1ServiceInstanceFinalizersValidateBeforeCall(environment, name, org, computeV1ServiceInstance, null);
        Type localVarReturnType = new TypeToken<ComputeV1ServiceInstance>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchComputeV1ServiceInstanceFinalizersAsync(String environment, String name, String org, ComputeV1ServiceInstance computeV1ServiceInstance, ApiCallback<ComputeV1ServiceInstance> _callback) throws ApiException {
        Call localVarCall = this.patchComputeV1ServiceInstanceFinalizersValidateBeforeCall(environment, name, org, computeV1ServiceInstance, _callback);
        Type localVarReturnType = new TypeToken<ComputeV1ServiceInstance>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call patchComputeV1ServiceInstanceStatusCall(String environment, String name, String org, ComputeV1ServiceInstance computeV1ServiceInstance, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ComputeV1ServiceInstance localVarPostBody = computeV1ServiceInstance;
        String localVarPath = "/apis/compute/v1/orgs/{org}/environments/{environment}/serviceinstances/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json-patch+json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchComputeV1ServiceInstanceStatusValidateBeforeCall(String environment, String name, String org, ComputeV1ServiceInstance computeV1ServiceInstance, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling patchComputeV1ServiceInstanceStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchComputeV1ServiceInstanceStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling patchComputeV1ServiceInstanceStatus(Async)");
        }
        if (computeV1ServiceInstance == null) {
            throw new ApiException("Missing the required parameter 'computeV1ServiceInstance' when calling patchComputeV1ServiceInstanceStatus(Async)");
        }
        return this.patchComputeV1ServiceInstanceStatusCall(environment, name, org, computeV1ServiceInstance, _callback);
    }

    public ComputeV1ServiceInstance patchComputeV1ServiceInstanceStatus(String environment, String name, String org, ComputeV1ServiceInstance computeV1ServiceInstance) throws ApiException {
        ApiResponse<ComputeV1ServiceInstance> localVarResp = this.patchComputeV1ServiceInstanceStatusWithHttpInfo(environment, name, org, computeV1ServiceInstance);
        return localVarResp.getData();
    }

    public ApiResponse<ComputeV1ServiceInstance> patchComputeV1ServiceInstanceStatusWithHttpInfo(String environment, String name, String org, ComputeV1ServiceInstance computeV1ServiceInstance) throws ApiException {
        Call localVarCall = this.patchComputeV1ServiceInstanceStatusValidateBeforeCall(environment, name, org, computeV1ServiceInstance, null);
        Type localVarReturnType = new TypeToken<ComputeV1ServiceInstance>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call patchComputeV1ServiceInstanceStatusAsync(String environment, String name, String org, ComputeV1ServiceInstance computeV1ServiceInstance, ApiCallback<ComputeV1ServiceInstance> _callback) throws ApiException {
        Call localVarCall = this.patchComputeV1ServiceInstanceStatusValidateBeforeCall(environment, name, org, computeV1ServiceInstance, _callback);
        Type localVarReturnType = new TypeToken<ComputeV1ServiceInstance>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readComputeV1FlinkUdfTaskCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/compute/v1/orgs/{org}/environments/{environment}/flinkudftasks/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readComputeV1FlinkUdfTaskValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readComputeV1FlinkUdfTask(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readComputeV1FlinkUdfTask(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readComputeV1FlinkUdfTask(Async)");
        }
        return this.readComputeV1FlinkUdfTaskCall(environment, name, org, resourceVersion, _callback);
    }

    public ComputeV1FlinkUdfTask readComputeV1FlinkUdfTask(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<ComputeV1FlinkUdfTask> localVarResp = this.readComputeV1FlinkUdfTaskWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<ComputeV1FlinkUdfTask> readComputeV1FlinkUdfTaskWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readComputeV1FlinkUdfTaskValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<ComputeV1FlinkUdfTask>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readComputeV1FlinkUdfTaskAsync(String environment, String name, String org, String resourceVersion, ApiCallback<ComputeV1FlinkUdfTask> _callback) throws ApiException {
        Call localVarCall = this.readComputeV1FlinkUdfTaskValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<ComputeV1FlinkUdfTask>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readComputeV1FlinkUdfTaskFinalizersCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/compute/v1/orgs/{org}/environments/{environment}/flinkudftasks/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readComputeV1FlinkUdfTaskFinalizersValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readComputeV1FlinkUdfTaskFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readComputeV1FlinkUdfTaskFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readComputeV1FlinkUdfTaskFinalizers(Async)");
        }
        return this.readComputeV1FlinkUdfTaskFinalizersCall(environment, name, org, resourceVersion, _callback);
    }

    public ComputeV1FlinkUdfTask readComputeV1FlinkUdfTaskFinalizers(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<ComputeV1FlinkUdfTask> localVarResp = this.readComputeV1FlinkUdfTaskFinalizersWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<ComputeV1FlinkUdfTask> readComputeV1FlinkUdfTaskFinalizersWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readComputeV1FlinkUdfTaskFinalizersValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<ComputeV1FlinkUdfTask>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readComputeV1FlinkUdfTaskFinalizersAsync(String environment, String name, String org, String resourceVersion, ApiCallback<ComputeV1FlinkUdfTask> _callback) throws ApiException {
        Call localVarCall = this.readComputeV1FlinkUdfTaskFinalizersValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<ComputeV1FlinkUdfTask>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readComputeV1FlinkUdfTaskStatusCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/compute/v1/orgs/{org}/environments/{environment}/flinkudftasks/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readComputeV1FlinkUdfTaskStatusValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readComputeV1FlinkUdfTaskStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readComputeV1FlinkUdfTaskStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readComputeV1FlinkUdfTaskStatus(Async)");
        }
        return this.readComputeV1FlinkUdfTaskStatusCall(environment, name, org, resourceVersion, _callback);
    }

    public ComputeV1FlinkUdfTask readComputeV1FlinkUdfTaskStatus(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<ComputeV1FlinkUdfTask> localVarResp = this.readComputeV1FlinkUdfTaskStatusWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<ComputeV1FlinkUdfTask> readComputeV1FlinkUdfTaskStatusWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readComputeV1FlinkUdfTaskStatusValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<ComputeV1FlinkUdfTask>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readComputeV1FlinkUdfTaskStatusAsync(String environment, String name, String org, String resourceVersion, ApiCallback<ComputeV1FlinkUdfTask> _callback) throws ApiException {
        Call localVarCall = this.readComputeV1FlinkUdfTaskStatusValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<ComputeV1FlinkUdfTask>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readComputeV1ServiceInstanceCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/compute/v1/orgs/{org}/environments/{environment}/serviceinstances/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readComputeV1ServiceInstanceValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readComputeV1ServiceInstance(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readComputeV1ServiceInstance(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readComputeV1ServiceInstance(Async)");
        }
        return this.readComputeV1ServiceInstanceCall(environment, name, org, resourceVersion, _callback);
    }

    public ComputeV1ServiceInstance readComputeV1ServiceInstance(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<ComputeV1ServiceInstance> localVarResp = this.readComputeV1ServiceInstanceWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<ComputeV1ServiceInstance> readComputeV1ServiceInstanceWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readComputeV1ServiceInstanceValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<ComputeV1ServiceInstance>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readComputeV1ServiceInstanceAsync(String environment, String name, String org, String resourceVersion, ApiCallback<ComputeV1ServiceInstance> _callback) throws ApiException {
        Call localVarCall = this.readComputeV1ServiceInstanceValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<ComputeV1ServiceInstance>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readComputeV1ServiceInstanceFinalizersCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/compute/v1/orgs/{org}/environments/{environment}/serviceinstances/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readComputeV1ServiceInstanceFinalizersValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readComputeV1ServiceInstanceFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readComputeV1ServiceInstanceFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readComputeV1ServiceInstanceFinalizers(Async)");
        }
        return this.readComputeV1ServiceInstanceFinalizersCall(environment, name, org, resourceVersion, _callback);
    }

    public ComputeV1ServiceInstance readComputeV1ServiceInstanceFinalizers(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<ComputeV1ServiceInstance> localVarResp = this.readComputeV1ServiceInstanceFinalizersWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<ComputeV1ServiceInstance> readComputeV1ServiceInstanceFinalizersWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readComputeV1ServiceInstanceFinalizersValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<ComputeV1ServiceInstance>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readComputeV1ServiceInstanceFinalizersAsync(String environment, String name, String org, String resourceVersion, ApiCallback<ComputeV1ServiceInstance> _callback) throws ApiException {
        Call localVarCall = this.readComputeV1ServiceInstanceFinalizersValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<ComputeV1ServiceInstance>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call readComputeV1ServiceInstanceStatusCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/compute/v1/orgs/{org}/environments/{environment}/serviceinstances/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readComputeV1ServiceInstanceStatusValidateBeforeCall(String environment, String name, String org, String resourceVersion, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling readComputeV1ServiceInstanceStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readComputeV1ServiceInstanceStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling readComputeV1ServiceInstanceStatus(Async)");
        }
        return this.readComputeV1ServiceInstanceStatusCall(environment, name, org, resourceVersion, _callback);
    }

    public ComputeV1ServiceInstance readComputeV1ServiceInstanceStatus(String environment, String name, String org, String resourceVersion) throws ApiException {
        ApiResponse<ComputeV1ServiceInstance> localVarResp = this.readComputeV1ServiceInstanceStatusWithHttpInfo(environment, name, org, resourceVersion);
        return localVarResp.getData();
    }

    public ApiResponse<ComputeV1ServiceInstance> readComputeV1ServiceInstanceStatusWithHttpInfo(String environment, String name, String org, String resourceVersion) throws ApiException {
        Call localVarCall = this.readComputeV1ServiceInstanceStatusValidateBeforeCall(environment, name, org, resourceVersion, null);
        Type localVarReturnType = new TypeToken<ComputeV1ServiceInstance>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call readComputeV1ServiceInstanceStatusAsync(String environment, String name, String org, String resourceVersion, ApiCallback<ComputeV1ServiceInstance> _callback) throws ApiException {
        Call localVarCall = this.readComputeV1ServiceInstanceStatusValidateBeforeCall(environment, name, org, resourceVersion, _callback);
        Type localVarReturnType = new TypeToken<ComputeV1ServiceInstance>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateComputeV1FlinkUdfTaskCall(String environment, String name, String org, ComputeV1FlinkUdfTask computeV1FlinkUdfTask, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ComputeV1FlinkUdfTask localVarPostBody = computeV1FlinkUdfTask;
        String localVarPath = "/apis/compute/v1/orgs/{org}/environments/{environment}/flinkudftasks/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateComputeV1FlinkUdfTaskValidateBeforeCall(String environment, String name, String org, ComputeV1FlinkUdfTask computeV1FlinkUdfTask, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateComputeV1FlinkUdfTask(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateComputeV1FlinkUdfTask(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateComputeV1FlinkUdfTask(Async)");
        }
        if (computeV1FlinkUdfTask == null) {
            throw new ApiException("Missing the required parameter 'computeV1FlinkUdfTask' when calling updateComputeV1FlinkUdfTask(Async)");
        }
        return this.updateComputeV1FlinkUdfTaskCall(environment, name, org, computeV1FlinkUdfTask, _callback);
    }

    public ComputeV1FlinkUdfTask updateComputeV1FlinkUdfTask(String environment, String name, String org, ComputeV1FlinkUdfTask computeV1FlinkUdfTask) throws ApiException {
        ApiResponse<ComputeV1FlinkUdfTask> localVarResp = this.updateComputeV1FlinkUdfTaskWithHttpInfo(environment, name, org, computeV1FlinkUdfTask);
        return localVarResp.getData();
    }

    public ApiResponse<ComputeV1FlinkUdfTask> updateComputeV1FlinkUdfTaskWithHttpInfo(String environment, String name, String org, ComputeV1FlinkUdfTask computeV1FlinkUdfTask) throws ApiException {
        Call localVarCall = this.updateComputeV1FlinkUdfTaskValidateBeforeCall(environment, name, org, computeV1FlinkUdfTask, null);
        Type localVarReturnType = new TypeToken<ComputeV1FlinkUdfTask>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateComputeV1FlinkUdfTaskAsync(String environment, String name, String org, ComputeV1FlinkUdfTask computeV1FlinkUdfTask, ApiCallback<ComputeV1FlinkUdfTask> _callback) throws ApiException {
        Call localVarCall = this.updateComputeV1FlinkUdfTaskValidateBeforeCall(environment, name, org, computeV1FlinkUdfTask, _callback);
        Type localVarReturnType = new TypeToken<ComputeV1FlinkUdfTask>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateComputeV1FlinkUdfTaskFinalizersCall(String environment, String name, String org, ComputeV1FlinkUdfTask computeV1FlinkUdfTask, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ComputeV1FlinkUdfTask localVarPostBody = computeV1FlinkUdfTask;
        String localVarPath = "/apis/compute/v1/orgs/{org}/environments/{environment}/flinkudftasks/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateComputeV1FlinkUdfTaskFinalizersValidateBeforeCall(String environment, String name, String org, ComputeV1FlinkUdfTask computeV1FlinkUdfTask, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateComputeV1FlinkUdfTaskFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateComputeV1FlinkUdfTaskFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateComputeV1FlinkUdfTaskFinalizers(Async)");
        }
        if (computeV1FlinkUdfTask == null) {
            throw new ApiException("Missing the required parameter 'computeV1FlinkUdfTask' when calling updateComputeV1FlinkUdfTaskFinalizers(Async)");
        }
        return this.updateComputeV1FlinkUdfTaskFinalizersCall(environment, name, org, computeV1FlinkUdfTask, _callback);
    }

    public ComputeV1FlinkUdfTask updateComputeV1FlinkUdfTaskFinalizers(String environment, String name, String org, ComputeV1FlinkUdfTask computeV1FlinkUdfTask) throws ApiException {
        ApiResponse<ComputeV1FlinkUdfTask> localVarResp = this.updateComputeV1FlinkUdfTaskFinalizersWithHttpInfo(environment, name, org, computeV1FlinkUdfTask);
        return localVarResp.getData();
    }

    public ApiResponse<ComputeV1FlinkUdfTask> updateComputeV1FlinkUdfTaskFinalizersWithHttpInfo(String environment, String name, String org, ComputeV1FlinkUdfTask computeV1FlinkUdfTask) throws ApiException {
        Call localVarCall = this.updateComputeV1FlinkUdfTaskFinalizersValidateBeforeCall(environment, name, org, computeV1FlinkUdfTask, null);
        Type localVarReturnType = new TypeToken<ComputeV1FlinkUdfTask>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateComputeV1FlinkUdfTaskFinalizersAsync(String environment, String name, String org, ComputeV1FlinkUdfTask computeV1FlinkUdfTask, ApiCallback<ComputeV1FlinkUdfTask> _callback) throws ApiException {
        Call localVarCall = this.updateComputeV1FlinkUdfTaskFinalizersValidateBeforeCall(environment, name, org, computeV1FlinkUdfTask, _callback);
        Type localVarReturnType = new TypeToken<ComputeV1FlinkUdfTask>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateComputeV1FlinkUdfTaskStatusCall(String environment, String name, String org, ComputeV1FlinkUdfTask computeV1FlinkUdfTask, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ComputeV1FlinkUdfTask localVarPostBody = computeV1FlinkUdfTask;
        String localVarPath = "/apis/compute/v1/orgs/{org}/environments/{environment}/flinkudftasks/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateComputeV1FlinkUdfTaskStatusValidateBeforeCall(String environment, String name, String org, ComputeV1FlinkUdfTask computeV1FlinkUdfTask, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateComputeV1FlinkUdfTaskStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateComputeV1FlinkUdfTaskStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateComputeV1FlinkUdfTaskStatus(Async)");
        }
        if (computeV1FlinkUdfTask == null) {
            throw new ApiException("Missing the required parameter 'computeV1FlinkUdfTask' when calling updateComputeV1FlinkUdfTaskStatus(Async)");
        }
        return this.updateComputeV1FlinkUdfTaskStatusCall(environment, name, org, computeV1FlinkUdfTask, _callback);
    }

    public ComputeV1FlinkUdfTask updateComputeV1FlinkUdfTaskStatus(String environment, String name, String org, ComputeV1FlinkUdfTask computeV1FlinkUdfTask) throws ApiException {
        ApiResponse<ComputeV1FlinkUdfTask> localVarResp = this.updateComputeV1FlinkUdfTaskStatusWithHttpInfo(environment, name, org, computeV1FlinkUdfTask);
        return localVarResp.getData();
    }

    public ApiResponse<ComputeV1FlinkUdfTask> updateComputeV1FlinkUdfTaskStatusWithHttpInfo(String environment, String name, String org, ComputeV1FlinkUdfTask computeV1FlinkUdfTask) throws ApiException {
        Call localVarCall = this.updateComputeV1FlinkUdfTaskStatusValidateBeforeCall(environment, name, org, computeV1FlinkUdfTask, null);
        Type localVarReturnType = new TypeToken<ComputeV1FlinkUdfTask>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateComputeV1FlinkUdfTaskStatusAsync(String environment, String name, String org, ComputeV1FlinkUdfTask computeV1FlinkUdfTask, ApiCallback<ComputeV1FlinkUdfTask> _callback) throws ApiException {
        Call localVarCall = this.updateComputeV1FlinkUdfTaskStatusValidateBeforeCall(environment, name, org, computeV1FlinkUdfTask, _callback);
        Type localVarReturnType = new TypeToken<ComputeV1FlinkUdfTask>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateComputeV1ServiceInstanceCall(String environment, String name, String org, ComputeV1ServiceInstance computeV1ServiceInstance, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ComputeV1ServiceInstance localVarPostBody = computeV1ServiceInstance;
        String localVarPath = "/apis/compute/v1/orgs/{org}/environments/{environment}/serviceinstances/{name}".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateComputeV1ServiceInstanceValidateBeforeCall(String environment, String name, String org, ComputeV1ServiceInstance computeV1ServiceInstance, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateComputeV1ServiceInstance(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateComputeV1ServiceInstance(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateComputeV1ServiceInstance(Async)");
        }
        if (computeV1ServiceInstance == null) {
            throw new ApiException("Missing the required parameter 'computeV1ServiceInstance' when calling updateComputeV1ServiceInstance(Async)");
        }
        return this.updateComputeV1ServiceInstanceCall(environment, name, org, computeV1ServiceInstance, _callback);
    }

    public ComputeV1ServiceInstance updateComputeV1ServiceInstance(String environment, String name, String org, ComputeV1ServiceInstance computeV1ServiceInstance) throws ApiException {
        ApiResponse<ComputeV1ServiceInstance> localVarResp = this.updateComputeV1ServiceInstanceWithHttpInfo(environment, name, org, computeV1ServiceInstance);
        return localVarResp.getData();
    }

    public ApiResponse<ComputeV1ServiceInstance> updateComputeV1ServiceInstanceWithHttpInfo(String environment, String name, String org, ComputeV1ServiceInstance computeV1ServiceInstance) throws ApiException {
        Call localVarCall = this.updateComputeV1ServiceInstanceValidateBeforeCall(environment, name, org, computeV1ServiceInstance, null);
        Type localVarReturnType = new TypeToken<ComputeV1ServiceInstance>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateComputeV1ServiceInstanceAsync(String environment, String name, String org, ComputeV1ServiceInstance computeV1ServiceInstance, ApiCallback<ComputeV1ServiceInstance> _callback) throws ApiException {
        Call localVarCall = this.updateComputeV1ServiceInstanceValidateBeforeCall(environment, name, org, computeV1ServiceInstance, _callback);
        Type localVarReturnType = new TypeToken<ComputeV1ServiceInstance>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateComputeV1ServiceInstanceFinalizersCall(String environment, String name, String org, ComputeV1ServiceInstance computeV1ServiceInstance, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ComputeV1ServiceInstance localVarPostBody = computeV1ServiceInstance;
        String localVarPath = "/apis/compute/v1/orgs/{org}/environments/{environment}/serviceinstances/{name}/finalizers".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateComputeV1ServiceInstanceFinalizersValidateBeforeCall(String environment, String name, String org, ComputeV1ServiceInstance computeV1ServiceInstance, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateComputeV1ServiceInstanceFinalizers(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateComputeV1ServiceInstanceFinalizers(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateComputeV1ServiceInstanceFinalizers(Async)");
        }
        if (computeV1ServiceInstance == null) {
            throw new ApiException("Missing the required parameter 'computeV1ServiceInstance' when calling updateComputeV1ServiceInstanceFinalizers(Async)");
        }
        return this.updateComputeV1ServiceInstanceFinalizersCall(environment, name, org, computeV1ServiceInstance, _callback);
    }

    public ComputeV1ServiceInstance updateComputeV1ServiceInstanceFinalizers(String environment, String name, String org, ComputeV1ServiceInstance computeV1ServiceInstance) throws ApiException {
        ApiResponse<ComputeV1ServiceInstance> localVarResp = this.updateComputeV1ServiceInstanceFinalizersWithHttpInfo(environment, name, org, computeV1ServiceInstance);
        return localVarResp.getData();
    }

    public ApiResponse<ComputeV1ServiceInstance> updateComputeV1ServiceInstanceFinalizersWithHttpInfo(String environment, String name, String org, ComputeV1ServiceInstance computeV1ServiceInstance) throws ApiException {
        Call localVarCall = this.updateComputeV1ServiceInstanceFinalizersValidateBeforeCall(environment, name, org, computeV1ServiceInstance, null);
        Type localVarReturnType = new TypeToken<ComputeV1ServiceInstance>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateComputeV1ServiceInstanceFinalizersAsync(String environment, String name, String org, ComputeV1ServiceInstance computeV1ServiceInstance, ApiCallback<ComputeV1ServiceInstance> _callback) throws ApiException {
        Call localVarCall = this.updateComputeV1ServiceInstanceFinalizersValidateBeforeCall(environment, name, org, computeV1ServiceInstance, _callback);
        Type localVarReturnType = new TypeToken<ComputeV1ServiceInstance>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateComputeV1ServiceInstanceStatusCall(String environment, String name, String org, ComputeV1ServiceInstance computeV1ServiceInstance, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ComputeV1ServiceInstance localVarPostBody = computeV1ServiceInstance;
        String localVarPath = "/apis/compute/v1/orgs/{org}/environments/{environment}/serviceinstances/{name}/status".replace("{environment}", this.localVarApiClient.escapeString(environment.toString())).replace("{name}", this.localVarApiClient.escapeString(name.toString())).replace("{org}", this.localVarApiClient.escapeString(org.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/yaml"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateComputeV1ServiceInstanceStatusValidateBeforeCall(String environment, String name, String org, ComputeV1ServiceInstance computeV1ServiceInstance, ApiCallback _callback) throws ApiException {
        if (environment == null) {
            throw new ApiException("Missing the required parameter 'environment' when calling updateComputeV1ServiceInstanceStatus(Async)");
        }
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateComputeV1ServiceInstanceStatus(Async)");
        }
        if (org == null) {
            throw new ApiException("Missing the required parameter 'org' when calling updateComputeV1ServiceInstanceStatus(Async)");
        }
        if (computeV1ServiceInstance == null) {
            throw new ApiException("Missing the required parameter 'computeV1ServiceInstance' when calling updateComputeV1ServiceInstanceStatus(Async)");
        }
        return this.updateComputeV1ServiceInstanceStatusCall(environment, name, org, computeV1ServiceInstance, _callback);
    }

    public ComputeV1ServiceInstance updateComputeV1ServiceInstanceStatus(String environment, String name, String org, ComputeV1ServiceInstance computeV1ServiceInstance) throws ApiException {
        ApiResponse<ComputeV1ServiceInstance> localVarResp = this.updateComputeV1ServiceInstanceStatusWithHttpInfo(environment, name, org, computeV1ServiceInstance);
        return localVarResp.getData();
    }

    public ApiResponse<ComputeV1ServiceInstance> updateComputeV1ServiceInstanceStatusWithHttpInfo(String environment, String name, String org, ComputeV1ServiceInstance computeV1ServiceInstance) throws ApiException {
        Call localVarCall = this.updateComputeV1ServiceInstanceStatusValidateBeforeCall(environment, name, org, computeV1ServiceInstance, null);
        Type localVarReturnType = new TypeToken<ComputeV1ServiceInstance>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateComputeV1ServiceInstanceStatusAsync(String environment, String name, String org, ComputeV1ServiceInstance computeV1ServiceInstance, ApiCallback<ComputeV1ServiceInstance> _callback) throws ApiException {
        Call localVarCall = this.updateComputeV1ServiceInstanceStatusValidateBeforeCall(environment, name, org, computeV1ServiceInstance, _callback);
        Type localVarReturnType = new TypeToken<ComputeV1ServiceInstance>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

