/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.flink.apiserver.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.confluent.flink.apiserver.client.JSON;
import io.confluent.flink.apiserver.client.model.ApiextensionsV1CustomResourceDefinitionNames;
import io.confluent.flink.apiserver.client.model.ApiextensionsV1CustomResourceDefinitionVersion;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ApiextensionsV1CustomResourceDefinitionSpec
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_DELETION_PROPAGATION_POLICY = "deletionPropagationPolicy";
    @SerializedName(value="deletionPropagationPolicy")
    private String deletionPropagationPolicy = "Background";
    public static final String SERIALIZED_NAME_GROUP = "group";
    @SerializedName(value="group")
    private String group = "";
    public static final String SERIALIZED_NAME_LOCALITY = "locality";
    @SerializedName(value="locality")
    private LocalityEnum locality = LocalityEnum.REGIONAL;
    public static final String SERIALIZED_NAME_NAMES = "names";
    @SerializedName(value="names")
    private ApiextensionsV1CustomResourceDefinitionNames names;
    public static final String SERIALIZED_NAME_SCOPE = "scope";
    @SerializedName(value="scope")
    private String scope = "";
    public static final String SERIALIZED_NAME_VERSIONS = "versions";
    @SerializedName(value="versions")
    private List<ApiextensionsV1CustomResourceDefinitionVersion> versions = new ArrayList<ApiextensionsV1CustomResourceDefinitionVersion>();
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public ApiextensionsV1CustomResourceDefinitionSpec deletionPropagationPolicy(String deletionPropagationPolicy) {
        this.deletionPropagationPolicy = deletionPropagationPolicy;
        return this;
    }

    @Nullable
    public String getDeletionPropagationPolicy() {
        return this.deletionPropagationPolicy;
    }

    public void setDeletionPropagationPolicy(String deletionPropagationPolicy) {
        this.deletionPropagationPolicy = deletionPropagationPolicy;
    }

    public ApiextensionsV1CustomResourceDefinitionSpec group(String group) {
        this.group = group;
        return this;
    }

    @Nonnull
    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public ApiextensionsV1CustomResourceDefinitionSpec locality(LocalityEnum locality) {
        this.locality = locality;
        return this;
    }

    @Nullable
    public LocalityEnum getLocality() {
        return this.locality;
    }

    public void setLocality(LocalityEnum locality) {
        this.locality = locality;
    }

    public ApiextensionsV1CustomResourceDefinitionSpec names(ApiextensionsV1CustomResourceDefinitionNames names) {
        this.names = names;
        return this;
    }

    @Nonnull
    public ApiextensionsV1CustomResourceDefinitionNames getNames() {
        return this.names;
    }

    public void setNames(ApiextensionsV1CustomResourceDefinitionNames names) {
        this.names = names;
    }

    public ApiextensionsV1CustomResourceDefinitionSpec scope(String scope) {
        this.scope = scope;
        return this;
    }

    @Nonnull
    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public ApiextensionsV1CustomResourceDefinitionSpec versions(List<ApiextensionsV1CustomResourceDefinitionVersion> versions) {
        this.versions = versions;
        return this;
    }

    public ApiextensionsV1CustomResourceDefinitionSpec addVersionsItem(ApiextensionsV1CustomResourceDefinitionVersion versionsItem) {
        if (this.versions == null) {
            this.versions = new ArrayList<ApiextensionsV1CustomResourceDefinitionVersion>();
        }
        this.versions.add(versionsItem);
        return this;
    }

    @Nonnull
    public List<ApiextensionsV1CustomResourceDefinitionVersion> getVersions() {
        return this.versions;
    }

    public void setVersions(List<ApiextensionsV1CustomResourceDefinitionVersion> versions) {
        this.versions = versions;
    }

    public ApiextensionsV1CustomResourceDefinitionSpec putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiextensionsV1CustomResourceDefinitionSpec apiextensionsV1CustomResourceDefinitionSpec = (ApiextensionsV1CustomResourceDefinitionSpec)o;
        return Objects.equals(this.deletionPropagationPolicy, apiextensionsV1CustomResourceDefinitionSpec.deletionPropagationPolicy) && Objects.equals(this.group, apiextensionsV1CustomResourceDefinitionSpec.group) && Objects.equals((Object)this.locality, (Object)apiextensionsV1CustomResourceDefinitionSpec.locality) && Objects.equals(this.names, apiextensionsV1CustomResourceDefinitionSpec.names) && Objects.equals(this.scope, apiextensionsV1CustomResourceDefinitionSpec.scope) && Objects.equals(this.versions, apiextensionsV1CustomResourceDefinitionSpec.versions) && Objects.equals(this.additionalProperties, apiextensionsV1CustomResourceDefinitionSpec.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.deletionPropagationPolicy, this.group, this.locality, this.names, this.scope, this.versions, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiextensionsV1CustomResourceDefinitionSpec {\n");
        sb.append("    deletionPropagationPolicy: ").append(this.toIndentedString(this.deletionPropagationPolicy)).append("\n");
        sb.append("    group: ").append(this.toIndentedString(this.group)).append("\n");
        sb.append("    locality: ").append(this.toIndentedString((Object)this.locality)).append("\n");
        sb.append("    names: ").append(this.toIndentedString(this.names)).append("\n");
        sb.append("    scope: ").append(this.toIndentedString(this.scope)).append("\n");
        sb.append("    versions: ").append(this.toIndentedString(this.versions)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in ApiextensionsV1CustomResourceDefinitionSpec is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_DELETION_PROPAGATION_POLICY) != null && !jsonObj.get(SERIALIZED_NAME_DELETION_PROPAGATION_POLICY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DELETION_PROPAGATION_POLICY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `deletionPropagationPolicy` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DELETION_PROPAGATION_POLICY).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_GROUP).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `group` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_GROUP).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_LOCALITY) != null && !jsonObj.get(SERIALIZED_NAME_LOCALITY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_LOCALITY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `locality` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LOCALITY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_LOCALITY) != null && !jsonObj.get(SERIALIZED_NAME_LOCALITY).isJsonNull()) {
            LocalityEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_LOCALITY));
        }
        if (!jsonObj.get(SERIALIZED_NAME_SCOPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `scope` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SCOPE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_VERSIONS) == null) {
            throw new IllegalArgumentException("Expected the field `linkedContent` to be an array in the JSON string but got `null`");
        }
        if (!jsonObj.get(SERIALIZED_NAME_VERSIONS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `versions` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VERSIONS).toString()));
        }
    }

    public static ApiextensionsV1CustomResourceDefinitionSpec fromJson(String jsonString) throws IOException {
        return (ApiextensionsV1CustomResourceDefinitionSpec)JSON.getGson().fromJson(jsonString, ApiextensionsV1CustomResourceDefinitionSpec.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_DELETION_PROPAGATION_POLICY);
        openapiFields.add(SERIALIZED_NAME_GROUP);
        openapiFields.add(SERIALIZED_NAME_LOCALITY);
        openapiFields.add(SERIALIZED_NAME_NAMES);
        openapiFields.add(SERIALIZED_NAME_SCOPE);
        openapiFields.add(SERIALIZED_NAME_VERSIONS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_GROUP);
        openapiRequiredFields.add(SERIALIZED_NAME_NAMES);
        openapiRequiredFields.add(SERIALIZED_NAME_SCOPE);
        openapiRequiredFields.add(SERIALIZED_NAME_VERSIONS);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!ApiextensionsV1CustomResourceDefinitionSpec.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ApiextensionsV1CustomResourceDefinitionSpec.class));
            return new TypeAdapter<ApiextensionsV1CustomResourceDefinitionSpec>(){

                public void write(JsonWriter out, ApiextensionsV1CustomResourceDefinitionSpec value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            JsonElement jsonElement = gson.toJsonTree(entry.getValue());
                            if (jsonElement.isJsonArray()) {
                                obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonArray());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public ApiextensionsV1CustomResourceDefinitionSpec read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    ApiextensionsV1CustomResourceDefinitionSpec.validateJsonElement(jsonElement);
                    JsonObject jsonObj = jsonElement.getAsJsonObject();
                    ApiextensionsV1CustomResourceDefinitionSpec instance = (ApiextensionsV1CustomResourceDefinitionSpec)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        if (((JsonElement)entry.getValue()).isJsonArray()) {
                            instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), List.class));
                            continue;
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum LocalityEnum {
        GLOBAL("Global"),
        REGIONAL("Regional");

        private String value;

        private LocalityEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static LocalityEnum fromValue(String value) {
            for (LocalityEnum b : LocalityEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            String value = jsonElement.getAsString();
            LocalityEnum.fromValue(value);
        }

        public static class Adapter
        extends TypeAdapter<LocalityEnum> {
            public void write(JsonWriter jsonWriter, LocalityEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public LocalityEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return LocalityEnum.fromValue(value);
            }
        }
    }
}

