/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.hybrid.internal;

import com.google.crypto.tink.hybrid.internal.HkdfHpkeKdf;
import com.google.crypto.tink.hybrid.internal.HpkeKem;
import com.google.crypto.tink.hybrid.internal.HpkeKemEncapOutput;
import com.google.crypto.tink.hybrid.internal.HpkeKemPrivateKey;
import com.google.crypto.tink.hybrid.internal.HpkeUtil;
import com.google.crypto.tink.subtle.Bytes;
import com.google.crypto.tink.subtle.X25519;
import com.google.errorprone.annotations.Immutable;
import java.security.GeneralSecurityException;
import java.util.Arrays;

@Immutable
final class X25519HpkeKem
implements HpkeKem {
    private final HkdfHpkeKdf hkdf;

    X25519HpkeKem(HkdfHpkeKdf hkdf) {
        this.hkdf = hkdf;
    }

    private byte[] deriveKemSharedSecret(byte[] dhSharedSecret, byte[] senderEphemeralPublicKey, byte[] recipientPublicKey) throws GeneralSecurityException {
        byte[] kemContext = Bytes.concat(senderEphemeralPublicKey, recipientPublicKey);
        return this.extractAndExpand(dhSharedSecret, kemContext);
    }

    private byte[] deriveKemSharedSecret(byte[] dhSharedSecret, byte[] senderEphemeralPublicKey, byte[] recipientPublicKey, byte[] senderPublicKey) throws GeneralSecurityException {
        byte[] kemContext = Bytes.concat(senderEphemeralPublicKey, recipientPublicKey, senderPublicKey);
        return this.extractAndExpand(dhSharedSecret, kemContext);
    }

    private byte[] extractAndExpand(byte[] dhSharedSecret, byte[] kemContext) throws GeneralSecurityException {
        byte[] kemSuiteId = HpkeUtil.kemSuiteId(HpkeUtil.X25519_HKDF_SHA256_KEM_ID);
        return this.hkdf.extractAndExpand(null, dhSharedSecret, "eae_prk", kemContext, "shared_secret", kemSuiteId, this.hkdf.getMacLength());
    }

    HpkeKemEncapOutput encapsulate(byte[] recipientPublicKey, byte[] senderPrivateKey) throws GeneralSecurityException {
        byte[] dhSharedSecret = X25519.computeSharedSecret(senderPrivateKey, recipientPublicKey);
        byte[] senderPublicKey = X25519.publicFromPrivate(senderPrivateKey);
        byte[] kemSharedSecret = this.deriveKemSharedSecret(dhSharedSecret, senderPublicKey, recipientPublicKey);
        return new HpkeKemEncapOutput(kemSharedSecret, senderPublicKey);
    }

    @Override
    public HpkeKemEncapOutput encapsulate(byte[] recipientPublicKey) throws GeneralSecurityException {
        return this.encapsulate(recipientPublicKey, X25519.generatePrivateKey());
    }

    HpkeKemEncapOutput authEncapsulate(byte[] recipientPublicKey, byte[] senderEphemeralPrivateKey, HpkeKemPrivateKey senderPrivateKey) throws GeneralSecurityException {
        byte[] dhSharedSecret = Bytes.concat(X25519.computeSharedSecret(senderEphemeralPrivateKey, recipientPublicKey), X25519.computeSharedSecret(senderPrivateKey.getSerializedPrivate().toByteArray(), recipientPublicKey));
        byte[] senderEphemeralPublicKey = X25519.publicFromPrivate(senderEphemeralPrivateKey);
        byte[] senderPublicKey = X25519.publicFromPrivate(senderPrivateKey.getSerializedPrivate().toByteArray());
        byte[] kemSharedSecret = this.deriveKemSharedSecret(dhSharedSecret, senderEphemeralPublicKey, recipientPublicKey, senderPublicKey);
        return new HpkeKemEncapOutput(kemSharedSecret, senderEphemeralPublicKey);
    }

    @Override
    public HpkeKemEncapOutput authEncapsulate(byte[] recipientPublicKey, HpkeKemPrivateKey senderPrivateKey) throws GeneralSecurityException {
        return this.authEncapsulate(recipientPublicKey, X25519.generatePrivateKey(), senderPrivateKey);
    }

    @Override
    public byte[] decapsulate(byte[] encapsulatedKey, HpkeKemPrivateKey recipientPrivateKey) throws GeneralSecurityException {
        byte[] dhSharedSecret = X25519.computeSharedSecret(recipientPrivateKey.getSerializedPrivate().toByteArray(), encapsulatedKey);
        return this.deriveKemSharedSecret(dhSharedSecret, encapsulatedKey, recipientPrivateKey.getSerializedPublic().toByteArray());
    }

    @Override
    public byte[] authDecapsulate(byte[] encapsulatedKey, HpkeKemPrivateKey recipientPrivateKey, byte[] senderPublicKey) throws GeneralSecurityException {
        byte[] privateKey = recipientPrivateKey.getSerializedPrivate().toByteArray();
        byte[] dhSharedSecret = Bytes.concat(X25519.computeSharedSecret(privateKey, encapsulatedKey), X25519.computeSharedSecret(privateKey, senderPublicKey));
        byte[] recipientPublicKey = X25519.publicFromPrivate(privateKey);
        return this.deriveKemSharedSecret(dhSharedSecret, encapsulatedKey, recipientPublicKey, senderPublicKey);
    }

    @Override
    public byte[] getKemId() throws GeneralSecurityException {
        if (Arrays.equals(this.hkdf.getKdfId(), HpkeUtil.HKDF_SHA256_KDF_ID)) {
            return HpkeUtil.X25519_HKDF_SHA256_KEM_ID;
        }
        throw new GeneralSecurityException("Could not determine HPKE KEM ID");
    }
}

