/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.k2.kafka;

import io.confluent.k2.kafka.K2RangeAssignmentProto;

public record K2Node(String id, String zone) {
    public K2Node(Integer id) {
        this(id, null);
    }

    public K2Node(String id) {
        this(id, null);
    }

    public K2Node(Integer id, String zone) {
        this(Integer.toString(id), zone);
    }

    public K2Node {
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("K2Node id must be set");
        }
        if (zone == null) {
            zone = "";
        }
    }

    public static K2RangeAssignmentProto.Node toProto(K2Node node) {
        return K2RangeAssignmentProto.Node.newBuilder().setId(node.id()).setZone(node.zone()).build();
    }

    public static K2Node fromProto(K2RangeAssignmentProto.Node nodeId) {
        return new K2Node(nodeId.getId(), nodeId.getZone());
    }

    public static enum NodeStatus {
        OFFLINE,
        ONLINE;

    }
}

