/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.model;

import com.github.rvesse.airline.builder.ParserBuilder;
import com.github.rvesse.airline.help.sections.HelpSection;
import com.github.rvesse.airline.model.CommandGroupMetadata;
import com.github.rvesse.airline.model.CommandMetadata;
import com.github.rvesse.airline.model.OptionMetadata;
import com.github.rvesse.airline.model.ParserMetadata;
import com.github.rvesse.airline.restrictions.GlobalRestriction;
import com.github.rvesse.airline.utils.AirlineUtils;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class GlobalMetadata<T> {
    private final String name;
    private final String description;
    private final List<OptionMetadata> options;
    private final CommandMetadata defaultCommand;
    private final List<CommandMetadata> defaultGroupCommands;
    private final List<CommandGroupMetadata> commandGroups;
    private final ParserMetadata<T> parserConfig;
    private final List<GlobalRestriction> restrictions;
    private final List<HelpSection> baseHelpSections;

    public GlobalMetadata(String name, String description, Iterable<OptionMetadata> options, CommandMetadata defaultCommand, Iterable<CommandMetadata> defaultGroupCommands, Iterable<CommandGroupMetadata> commandGroups, Iterable<GlobalRestriction> restrictions, Iterable<HelpSection> baseHelpSections, ParserMetadata<T> parserConfig) {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("Program name cannot be null/empty/whitespace");
        }
        if (parserConfig == null) {
            throw new NullPointerException("parserConfig cannot be null");
        }
        this.name = name;
        this.description = description;
        this.options = AirlineUtils.unmodifiableListCopy(options);
        this.defaultCommand = defaultCommand;
        this.defaultGroupCommands = AirlineUtils.unmodifiableListCopy(defaultGroupCommands);
        this.commandGroups = AirlineUtils.unmodifiableListCopy(commandGroups);
        this.restrictions = AirlineUtils.unmodifiableListCopy(restrictions);
        this.baseHelpSections = AirlineUtils.unmodifiableListCopy(baseHelpSections);
        this.parserConfig = parserConfig != null ? parserConfig : ParserBuilder.defaultConfiguration();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<OptionMetadata> getOptions() {
        return this.options;
    }

    public CommandMetadata getDefaultCommand() {
        return this.defaultCommand;
    }

    public List<CommandMetadata> getDefaultGroupCommands() {
        return this.defaultGroupCommands;
    }

    public List<CommandGroupMetadata> getCommandGroups() {
        return this.commandGroups;
    }

    public List<GlobalRestriction> getRestrictions() {
        return this.restrictions;
    }

    public List<HelpSection> getBaseHelpSections() {
        return this.baseHelpSections;
    }

    public ParserMetadata<T> getParserConfiguration() {
        return this.parserConfig;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("GlobalMetadata");
        sb.append("{name='").append(this.name).append('\'');
        sb.append(", description='").append(this.description).append('\'');
        sb.append(", options=").append(this.options);
        sb.append(", defaultCommand=").append(this.defaultCommand);
        sb.append(", defaultGroupCommands=").append(this.defaultGroupCommands);
        sb.append(", commandGroups=").append(this.commandGroups);
        sb.append(", parserConfig=").append('\n').append(this.parserConfig);
        sb.append('\n').append('}');
        return sb.toString();
    }
}

