/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.restrictions.options;

import com.github.rvesse.airline.help.sections.HelpFormat;
import com.github.rvesse.airline.help.sections.HelpHint;
import com.github.rvesse.airline.model.OptionMetadata;
import com.github.rvesse.airline.parser.ParseState;
import com.github.rvesse.airline.parser.errors.ParseOptionMissingException;
import com.github.rvesse.airline.restrictions.OptionRestriction;
import com.github.rvesse.airline.utils.predicates.parser.ParsedOptionFinder;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class RequiredOnlyIfRestriction
implements OptionRestriction,
HelpHint {
    private final Set<String> names = new LinkedHashSet<String>();

    public RequiredOnlyIfRestriction(String ... names) {
        this.names.addAll(Arrays.asList(names));
    }

    @Override
    public <T> void finalValidate(ParseState<T> state, OptionMetadata option) {
        if (this.names.isEmpty()) {
            return;
        }
        Collection parsedOptions = CollectionUtils.select(state.getParsedOptions(), (Predicate)new ParsedOptionFinder(option));
        if (parsedOptions.size() > 0) {
            return;
        }
        for (Pair<OptionMetadata, Object> otherOption : state.getParsedOptions()) {
            if (((OptionMetadata)otherOption.getLeft()).equals(option)) continue;
            for (String name : this.names) {
                if (!((OptionMetadata)otherOption.getLeft()).getOptions().contains(name)) continue;
                throw new ParseOptionMissingException(option.getTitle());
            }
        }
    }

    @Override
    public <T> void preValidate(ParseState<T> state, OptionMetadata option, String value) {
    }

    @Override
    public String getPreamble() {
        return null;
    }

    @Override
    public HelpFormat getFormat() {
        return HelpFormat.PROSE;
    }

    @Override
    public int numContentBlocks() {
        return 1;
    }

    @Override
    public String[] getContentBlock(int blockNumber) {
        if (blockNumber != 0) {
            throw new IndexOutOfBoundsException();
        }
        return new String[]{String.format("This option is required if any of the following options are specified: %s", StringUtils.join(this.names, (String)", "))};
    }

    @Override
    public <T> void postValidate(ParseState<T> state, OptionMetadata option, Object value) {
    }
}

