/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.corretto.crypto.provider;

import com.amazon.corretto.crypto.provider.ConstantTime;
import com.amazon.corretto.crypto.provider.Utils;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;

class AesXtsSpi
extends CipherSpi {
    private static final int BLOCK_SIZE_IN_BYTES = 16;
    private static final int TWEAK_SIZE_IN_BYTES = 16;
    private static final int KEY_SIZE_IN_BYTES = 64;
    private static final int MINIMUM_INPUT_SIZE_FOR_AES_XTS = 16;
    private final byte[] packedTweakKey = new byte[80];
    private CipherState cipherState = CipherState.CREATED;

    AesXtsSpi() {
    }

    @Override
    protected void engineSetMode(String string) throws NoSuchAlgorithmException {
        if (!"XTS".equalsIgnoreCase(string)) {
            throw new NoSuchAlgorithmException();
        }
    }

    @Override
    protected void engineSetPadding(String string) throws NoSuchPaddingException {
        if (!"NoPadding".equalsIgnoreCase(string)) {
            throw new NoSuchPaddingException();
        }
    }

    @Override
    protected int engineGetBlockSize() {
        return 16;
    }

    @Override
    protected int engineGetOutputSize(int n) {
        return this.getExactOutputSize(n);
    }

    private int getExactOutputSize(int n) {
        if (n < 16) {
            throw new IllegalArgumentException("AES-XTS requires input of at least 16 bytes.");
        }
        return n;
    }

    @Override
    protected byte[] engineGetIV() {
        return this.cipherState == CipherState.CREATED ? null : Arrays.copyOfRange(this.packedTweakKey, 0, 16);
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    @Override
    protected void engineInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        throw new UnsupportedOperationException("Tweak must be provided by passing an instance of IvParameterSpec.");
    }

    @Override
    protected void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof IvParameterSpec)) {
            throw new InvalidAlgorithmParameterException("params must be an instance of IvParameterSpec");
        }
        IvParameterSpec ivParameterSpec = (IvParameterSpec)algorithmParameterSpec;
        byte[] byArray = ivParameterSpec.getIV();
        if (byArray.length != 16) {
            throw new InvalidAlgorithmParameterException("Provided tweak must be of length 16");
        }
        if (!(key instanceof SecretKey)) {
            throw new InvalidKeyException("Key must of type SecretKey");
        }
        SecretKey secretKey = (SecretKey)key;
        if (!"RAW".equalsIgnoreCase(secretKey.getFormat())) {
            throw new InvalidKeyException("Key's format must be raw");
        }
        byte[] byArray2 = secretKey.getEncoded();
        if (byArray2 == null) {
            throw new InvalidKeyException("Key must be transparent");
        }
        if (byArray2.length != 64) {
            throw new InvalidKeyException("Key length must be 64");
        }
        this.init(n, byArray2, byArray);
    }

    @Override
    protected void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        throw new UnsupportedOperationException("Tweak must be provided by passing an instance of IvParameterSpec.");
    }

    private void init(int n, byte[] byArray, byte[] byArray2) throws InvalidAlgorithmParameterException {
        if (this.cipherState.shouldCheckForReuse(n) && this.checkKeyTweakEquality(byArray, byArray2)) {
            throw new InvalidAlgorithmParameterException("The combination of key and tweak cannot be reused.");
        }
        this.cipherState = CipherState.fromOp(n);
        System.arraycopy(byArray2, 0, this.packedTweakKey, 0, 16);
        System.arraycopy(byArray, 0, this.packedTweakKey, 16, 64);
    }

    private boolean checkKeyTweakEquality(byte[] byArray, byte[] byArray2) {
        for (int i = 0; i != 16; ++i) {
            if (this.packedTweakKey[i] == byArray2[i]) continue;
            return false;
        }
        return ConstantTime.equals(this.packedTweakKey, 16, 64, byArray);
    }

    @Override
    protected byte[] engineUpdate(byte[] byArray, int n, int n2) {
        throw new UnsupportedOperationException("Multiple-part encryption or decryption is not supported. Consider using DoFinal.");
    }

    @Override
    protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        throw new UnsupportedOperationException("Multiple-part encryption or decryption is not supported. Consider using DoFinal.");
    }

    @Override
    protected byte[] engineDoFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
        byte[] byArray2 = new byte[this.getExactOutputSize(n2)];
        try {
            this.engineDoFinal(byArray, n, n2, byArray2, 0);
        }
        catch (ShortBufferException shortBufferException) {
            throw new AssertionError((Object)shortBufferException);
        }
        return byArray2;
    }

    @Override
    protected int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        this.cipherState.checkCipherStateForFinal();
        Utils.checkArrayLimits(byArray, n, n2);
        int n4 = byArray2.length - n3;
        Utils.checkArrayLimits(byArray2, n3, n4);
        int n5 = this.getExactOutputSize(n2);
        if (n4 < n5) {
            throw new ShortBufferException("Output buffer is not large enough.");
        }
        if (Utils.outputClobbersInput(byArray, n, n2, byArray2, n3)) {
            byte[] byArray3 = this.engineDoFinal(byArray, n, n2);
            System.arraycopy(byArray3, 0, byArray2, n3, byArray3.length);
        } else if (this.cipherState == CipherState.ENCRYPT_INIT) {
            this.encrypt(byArray, n, n2, byArray2, n3);
        } else {
            this.decrypt(byArray, n, n2, byArray2, n3);
        }
        this.cipherState = this.cipherState.nextStateAfterDoFinal();
        return n5;
    }

    private void encrypt(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        if (byArray != byArray2) {
            AesXtsSpi.enc(this.packedTweakKey, byArray, n, n2, byArray2, n3);
        } else {
            AesXtsSpi.encSameBuffer(this.packedTweakKey, byArray, n, n2, n3);
        }
    }

    private void decrypt(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        if (byArray != byArray2) {
            AesXtsSpi.dec(this.packedTweakKey, byArray, n, n2, byArray2, n3);
        } else {
            AesXtsSpi.decSameBuffer(this.packedTweakKey, byArray, n, n2, n3);
        }
    }

    private static native void enc(byte[] var0, byte[] var1, int var2, int var3, byte[] var4, int var5);

    private static native void encSameBuffer(byte[] var0, byte[] var1, int var2, int var3, int var4);

    private static native void dec(byte[] var0, byte[] var1, int var2, int var3, byte[] var4, int var5);

    private static native void decSameBuffer(byte[] var0, byte[] var1, int var2, int var3, int var4);

    private static enum CipherState {
        CREATED,
        ENCRYPT_INIT,
        ENCRYPT_DONE,
        DECRYPT_INIT,
        DECRYPT_DONE;


        public boolean shouldCheckForReuse(int n) {
            return this == ENCRYPT_DONE && n == 1;
        }

        public void checkCipherStateForFinal() {
            if (this != ENCRYPT_INIT && this != DECRYPT_INIT) {
                throw new IllegalStateException("Cipher is not initialized.");
            }
        }

        public CipherState nextStateAfterDoFinal() {
            return this == ENCRYPT_INIT ? ENCRYPT_DONE : DECRYPT_DONE;
        }

        static CipherState fromOp(int n) {
            if (n == 1) {
                return ENCRYPT_INIT;
            }
            if (n == 2) {
                return DECRYPT_INIT;
            }
            throw new UnsupportedOperationException("Only Encrypt and Decrypt are supported.");
        }
    }
}

