/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.corretto.crypto.provider;

import com.amazon.corretto.crypto.provider.Utils;

final class ConstantTime {
    private static int LONG_UNSIGNED_SHIFT = 63;

    private ConstantTime() {
    }

    static int isNonZero(int n) {
        return (n | -n) >>> 31 & 1;
    }

    static int isZero(int n) {
        return 1 - ConstantTime.isNonZero(n);
    }

    static int isNegative(int n) {
        return n >>> 31 & 1;
    }

    static int equal(int n, int n2) {
        int n3 = n - n2;
        return ConstantTime.isZero(n3);
    }

    static int gt(int n, int n2) {
        long l = n;
        long l2 = n2;
        long l3 = l2 - l;
        return (int)(l3 >>> LONG_UNSIGNED_SHIFT);
    }

    static int select(int n, int n2, int n3) {
        int n4 = ConstantTime.isZero(n) - 1;
        int n5 = n2 ^ n3;
        return n3 ^ n5 & n4;
    }

    static boolean equals(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
        Utils.checkArrayLimits(byArray, n, n2);
        Utils.checkArrayLimits(byArray2, n3, n4);
        if (n2 != n4) {
            return false;
        }
        int n5 = 0;
        for (int i = 0; i < n2; ++i) {
            n5 |= byArray[n + i] ^ byArray2[n3 + i];
        }
        return n5 == 0;
    }

    static boolean equals(byte[] byArray, int n, int n2, byte[] byArray2) {
        return ConstantTime.equals(byArray, n, n2, byArray2, 0, byArray2.length);
    }

    static boolean equals(byte[] byArray, byte[] byArray2) {
        if (byArray == byArray2) {
            return true;
        }
        if (byArray == null || byArray2 == null) {
            return false;
        }
        return ConstantTime.equals(byArray, 0, byArray.length, byArray2);
    }
}

