/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.corretto.crypto.provider;

import com.amazon.corretto.crypto.provider.Utils;
import java.security.spec.KeySpec;
import java.util.Objects;

public class CounterKdfSpec
implements KeySpec {
    private final byte[] secret;
    private final byte[] info;
    private final int outputLen;
    private final String algorithName;

    public CounterKdfSpec(byte[] byArray, byte[] byArray2, int n, String string) {
        this.secret = Objects.requireNonNull(byArray);
        if (this.secret.length == 0) {
            throw new IllegalArgumentException("Secret must be byte array with non-zero length.");
        }
        this.info = Objects.requireNonNull(byArray2);
        if (n <= 0) {
            throw new IllegalArgumentException("Output size must be greater than zero.");
        }
        this.outputLen = n;
        this.algorithName = Objects.requireNonNull(string);
    }

    public CounterKdfSpec(byte[] byArray, int n, String string) {
        this(byArray, Utils.EMPTY_ARRAY, n, string);
    }

    public byte[] getSecret() {
        return this.secret;
    }

    public byte[] getInfo() {
        return this.info;
    }

    public int getOutputLen() {
        return this.outputLen;
    }

    public String getAlgorithName() {
        return this.algorithName;
    }
}

