/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.corretto.crypto.provider;

import com.amazon.corretto.crypto.provider.Utils;
import java.security.spec.KeySpec;

public class HkdfSpec
implements KeySpec {
    final int mode;
    final byte[] secretOrPrk;
    final byte[] salt;
    final byte[] info;
    final int desiredLength;
    final String algorithmName;
    public static final String DEFAULT_ALGORITHM_NAME = "Hkdf";
    public static final int HKDF_MODE = 1;
    public static final int HKDF_EXTRACT_MODE = 2;
    public static final int HKDF_EXPAND_MODE = 3;

    public HkdfSpec(int n, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, int n2, String string) {
        switch (n) {
            case 1: {
                this.secretOrPrk = Utils.requireNonNull(byArray, "secret cannot be null for HKDF");
                this.salt = Utils.requireNonNull(byArray2, "salt cannot be null for HKDF");
                this.info = Utils.requireNonNull(byArray3, "info cannot be null for HKDF");
                this.desiredLength = HkdfSpec.validateDesiredLength(n2);
                break;
            }
            case 2: {
                this.secretOrPrk = Utils.requireNonNull(byArray, "secret cannot be null for HKDF_EXTRACT");
                this.salt = Utils.requireNonNull(byArray2, "salt cannot be null for HKDF_EXTRACT");
                this.info = null;
                this.desiredLength = 0;
                break;
            }
            case 3: {
                this.secretOrPrk = Utils.requireNonNull(byArray4, "prk cannot be null for HKDF_EXPAND");
                this.salt = null;
                this.info = Utils.requireNonNull(byArray3, "info cannot be null for HKDF_EXPAND");
                this.desiredLength = HkdfSpec.validateDesiredLength(n2);
                break;
            }
            default: {
                throw new IllegalArgumentException("mode is not a valid value");
            }
        }
        this.mode = n;
        this.algorithmName = string != null ? string : DEFAULT_ALGORITHM_NAME;
    }

    private static int validateDesiredLength(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Desired length must be positive");
        }
        return n;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static HkdfSpec hkdfSpec(byte[] byArray, byte[] byArray2, byte[] byArray3, int n, String string) {
        return HkdfSpec.builder().withMode(1).withSecret(byArray).withSalt(byArray2).withInfo(byArray3).withDesiredLength(n).withAlgorithmName(string).build();
    }

    public static HkdfSpec hkdfExtractSpec(byte[] byArray, byte[] byArray2, String string) {
        return HkdfSpec.builder().withMode(2).withSecret(byArray).withSalt(byArray2).withAlgorithmName(string).build();
    }

    public static HkdfSpec hkdfExpandSpec(byte[] byArray, byte[] byArray2, int n, String string) {
        return HkdfSpec.builder().withMode(3).withPrk(byArray).withInfo(byArray2).withDesiredLength(n).withAlgorithmName(string).build();
    }

    public static class Builder {
        private int mode;
        private byte[] secret;
        private byte[] salt;
        private byte[] info;
        private byte[] prk;
        private int desiredLength;
        private String algorithmName;

        Builder() {
        }

        public HkdfSpec build() {
            return new HkdfSpec(this.mode, this.secret, this.salt, this.info, this.prk, this.desiredLength, this.algorithmName);
        }

        public Builder withMode(int n) {
            this.mode = n;
            return this;
        }

        public Builder withSecret(byte[] byArray) {
            this.secret = byArray;
            return this;
        }

        public Builder withSalt(byte[] byArray) {
            this.salt = byArray;
            return this;
        }

        public Builder withInfo(byte[] byArray) {
            this.info = byArray;
            return this;
        }

        public Builder withPrk(byte[] byArray) {
            this.prk = byArray;
            return this;
        }

        public Builder withDesiredLength(int n) {
            this.desiredLength = n;
            return this;
        }

        public Builder withAlgorithmName(String string) {
            this.algorithmName = string;
            return this;
        }
    }
}

