/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.corretto.crypto.provider;

import com.amazon.corretto.crypto.provider.AccessibleByteArrayOutputStream;
import com.amazon.corretto.crypto.provider.AmazonCorrettoCryptoProvider;
import com.amazon.corretto.crypto.provider.EvpKey;
import com.amazon.corretto.crypto.provider.EvpKeyType;
import com.amazon.corretto.crypto.provider.Loader;
import com.amazon.corretto.crypto.provider.Utils;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.RSAKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.MGF1ParameterSpec;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;

class RsaCipher
extends CipherSpi {
    private static final int HANDLE_USAGE_IGNORE = 1;
    private static final int HANDLE_USAGE_USE = 2;
    private static final int HANDLE_USAGE_CREATE = 3;
    private final AmazonCorrettoCryptoProvider provider_;
    private final Object lock_ = new Object();
    private final Padding padding_;
    private final boolean allowParamUpdates_;
    private int mode_;
    private RSAKey key_;
    private int keySizeBytes_;
    private int paddingSize_;
    private OAEPParameterSpec oaepParams_;
    private EvpKey nativeKey_;
    private AccessibleByteArrayOutputStream buffer_;

    private static native int cipher(long var0, int var2, int var3, long var4, long var6, byte[] var8, int var9, int var10, byte[] var11, int var12) throws BadPaddingException;

    RsaCipher(AmazonCorrettoCryptoProvider amazonCorrettoCryptoProvider, Padding padding, int n, boolean bl) {
        Loader.checkNativeLibraryAvailability();
        this.provider_ = amazonCorrettoCryptoProvider;
        this.padding_ = padding;
        this.paddingSize_ = n;
        this.allowParamUpdates_ = bl;
        this.oaepParams_ = padding == Padding.OAEP ? OAEPParameterSpec.DEFAULT : null;
    }

    @Override
    protected byte[] engineDoFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
        Object object = this.lock_;
        synchronized (object) {
            this.assertInitialized();
            byte[] byArray2 = new byte[this.engineGetOutputSize(n2)];
            try {
                int n3 = this.engineDoFinal(byArray, n, n2, byArray2, 0);
                if (n3 == byArray2.length) {
                    return byArray2;
                }
                return Arrays.copyOf(byArray2, n3);
            }
            catch (ShortBufferException shortBufferException) {
                throw new AssertionError((Object)shortBufferException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        Object object = this.lock_;
        synchronized (object) {
            long l;
            long l2;
            this.assertInitialized();
            if (this.buffer_.size() != 0) {
                if (byArray != null) {
                    this.buffer_.write(byArray, n, n2);
                }
                byArray = this.buffer_.getDataBuffer();
                n = 0;
                n2 = this.buffer_.size();
            } else if (byArray == null) {
                byArray = Utils.EMPTY_ARRAY;
                n = 0;
                n2 = 0;
            }
            if (byArray2.length - n3 < this.engineGetOutputSize(n2)) {
                throw new ShortBufferException();
            }
            if (this.mode_ == 1 || this.mode_ == 3) {
                if (n2 > this.keySizeBytes_ - this.paddingSize_) {
                    throw new IllegalBlockSizeException("Data must not be longer than " + (this.keySizeBytes_ - this.paddingSize_) + " bytes");
                }
                if (this.padding_.equals((Object)Padding.NO_PADDING) && n2 < this.keySizeBytes_) {
                    byte[] byArray3 = new byte[this.keySizeBytes_];
                    System.arraycopy(byArray, n, byArray3, this.keySizeBytes_ - n2, n2);
                    byArray = byArray3;
                    n = 0;
                    n2 = this.keySizeBytes_;
                }
            } else if (n2 > this.keySizeBytes_) {
                throw new IllegalBlockSizeException("Data must not be longer than " + this.keySizeBytes_ + " bytes");
            }
            if (this.padding_ == Padding.OAEP) {
                l2 = Utils.getMdPtr(this.oaepParams_.getDigestAlgorithm());
                l = Utils.getMdPtr(((MGF1ParameterSpec)this.oaepParams_.getMGFParameters()).getDigestAlgorithm());
            } else {
                l2 = 0L;
                l = 0L;
            }
            byte[] byArray4 = byArray;
            int n4 = n;
            int n5 = n2;
            int n6 = this.nativeKey_.use(l3 -> RsaCipher.cipher(l3, this.mode_, this.padding_.nativeVal, l2, l, byArray4, n4, n5, byArray2, n3));
            this.buffer_ = new AccessibleByteArrayOutputStream();
            return n6;
        }
    }

    @Override
    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        if (key instanceof RSAKey) {
            return ((RSAKey)((Object)key)).getModulus().bitLength();
        }
        throw new InvalidKeyException();
    }

    @Override
    protected int engineGetBlockSize() {
        return 0;
    }

    @Override
    protected byte[] engineGetIV() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int engineGetOutputSize(int n) {
        Object object = this.lock_;
        synchronized (object) {
            this.assertInitialized();
            return this.keySizeBytes_;
        }
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        if (this.padding_ == Padding.OAEP) {
            try {
                AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance("OAEP");
                algorithmParameters.init(this.oaepParams_);
                return algorithmParameters;
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new AssertionError((Object)generalSecurityException);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (algorithmParameterSpec != null) {
            if (algorithmParameterSpec instanceof OAEPParameterSpec) {
                if (this.padding_ != Padding.OAEP) {
                    throw new InvalidAlgorithmParameterException();
                }
                object4 = (OAEPParameterSpec)algorithmParameterSpec;
                if (!"MGF1".equalsIgnoreCase(((OAEPParameterSpec)object4).getMGFAlgorithm()) || ((OAEPParameterSpec)object4).getMGFParameters() == null || !(((OAEPParameterSpec)object4).getMGFParameters() instanceof MGF1ParameterSpec)) {
                    throw new InvalidAlgorithmParameterException();
                }
                object3 = PSource.PSpecified.DEFAULT;
                object2 = ((OAEPParameterSpec)object4).getPSource();
                if (object2 == null || !((PSource)object3).getAlgorithm().equalsIgnoreCase(((PSource)object2).getAlgorithm())) {
                    throw new InvalidAlgorithmParameterException();
                }
                if (!(object2 instanceof PSource.PSpecified)) {
                    throw new InvalidAlgorithmParameterException();
                }
                if (((PSource.PSpecified)object2).getValue().length != 0) {
                    throw new InvalidAlgorithmParameterException();
                }
                object = (MGF1ParameterSpec)((OAEPParameterSpec)object4).getMGFParameters();
                MGF1ParameterSpec mGF1ParameterSpec = (MGF1ParameterSpec)this.oaepParams_.getMGFParameters();
                if (!(this.allowParamUpdates_ || ((OAEPParameterSpec)object4).getDigestAlgorithm().equals(this.oaepParams_.getDigestAlgorithm()) && ((MGF1ParameterSpec)object).getDigestAlgorithm().equals(mGF1ParameterSpec.getDigestAlgorithm()))) {
                    throw new InvalidAlgorithmParameterException();
                }
            } else {
                throw new InvalidAlgorithmParameterException();
            }
        }
        object4 = this.lock_;
        synchronized (object4) {
            if (!(key instanceof RSAKey)) {
                throw new InvalidKeyException();
            }
            this.mode_ = RsaCipher.checkMode(n, key);
            if (this.key_ != key) {
                if (this.nativeKey_ != null) {
                    this.nativeKey_.releaseEphemeral();
                    this.nativeKey_ = null;
                }
                this.key_ = (RSAKey)((Object)key);
                this.keySizeBytes_ = (this.key_.getModulus().bitLength() + 7) / 8;
                this.buffer_ = new AccessibleByteArrayOutputStream(this.keySizeBytes_, this.keySizeBytes_);
                this.nativeKey_ = this.provider_.translateKey(key, EvpKeyType.RSA);
            }
            if (algorithmParameterSpec instanceof OAEPParameterSpec) {
                object3 = (OAEPParameterSpec)algorithmParameterSpec;
                object2 = ((OAEPParameterSpec)object3).getDigestAlgorithm();
                object = ((MGF1ParameterSpec)((OAEPParameterSpec)object3).getMGFParameters()).getDigestAlgorithm();
                try {
                    Utils.getMdPtr(((OAEPParameterSpec)object3).getDigestAlgorithm());
                    Utils.getMdPtr(((MGF1ParameterSpec)((OAEPParameterSpec)object3).getMGFParameters()).getDigestAlgorithm());
                }
                catch (Exception exception) {
                    throw new InvalidAlgorithmParameterException();
                }
                this.paddingSize_ = RsaCipher.calculateOaepPaddingLen(((OAEPParameterSpec)object3).getDigestAlgorithm());
                this.oaepParams_ = object3;
            }
        }
    }

    private static int calculateOaepPaddingLen(String string) {
        return 2 * Utils.getMdLen(Utils.getMdPtr(string)) + 2;
    }

    @Override
    protected void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        try {
            this.engineInit(n, key, algorithmParameters != null ? algorithmParameters.getParameterSpec(OAEPParameterSpec.class) : null, secureRandom);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new InvalidAlgorithmParameterException(invalidParameterSpecException);
        }
    }

    @Override
    protected void engineInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        OAEPParameterSpec oAEPParameterSpec = null;
        if (this.padding_ == Padding.OAEP) {
            oAEPParameterSpec = this.oaepParams_;
        }
        try {
            this.engineInit(n, key, oAEPParameterSpec, secureRandom);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidKeyException(invalidAlgorithmParameterException);
        }
    }

    private static int checkMode(int n, Key key) throws InvalidKeyException {
        if (key instanceof PrivateKey) {
            switch (n) {
                case 2: 
                case 4: {
                    return n;
                }
                case 1: {
                    return -1 * n;
                }
            }
            throw new InvalidKeyException("Private keys not supported for mode " + n);
        }
        if (key instanceof PublicKey) {
            switch (n) {
                case 1: 
                case 3: {
                    return n;
                }
                case 2: {
                    return -1 * n;
                }
            }
            throw new InvalidKeyException("Public keys not supported for mode " + n);
        }
        throw new InvalidKeyException("Unsupported key type: " + key.getClass());
    }

    @Override
    protected void engineSetMode(String string) throws NoSuchAlgorithmException {
        if (!"ECB".equalsIgnoreCase(string)) {
            throw new NoSuchAlgorithmException();
        }
    }

    @Override
    protected void engineSetPadding(String string) throws NoSuchPaddingException {
        if (!this.padding_.paddingStr.equalsIgnoreCase(string)) {
            throw new NoSuchPaddingException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected byte[] engineUpdate(byte[] byArray, int n, int n2) {
        Object object = this.lock_;
        synchronized (object) {
            this.assertInitialized();
            this.buffer_.write(byArray, n, n2);
        }
        return Utils.EMPTY_ARRAY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
        Object object = this.lock_;
        synchronized (object) {
            this.assertInitialized();
            this.buffer_.write(byArray, n, n2);
        }
        return 0;
    }

    @Override
    protected Key engineUnwrap(byte[] byArray, String string, int n) throws InvalidKeyException, NoSuchAlgorithmException {
        if (this.mode_ != 4 && this.mode_ != 2) {
            throw new IllegalStateException("Cipher must be in UNWRAP_MODE");
        }
        try {
            byte[] byArray2 = this.engineDoFinal(byArray, 0, byArray.length);
            return Utils.buildUnwrappedKey(this.provider_, byArray2, string, n);
        }
        catch (InvalidKeySpecException | BadPaddingException | IllegalBlockSizeException generalSecurityException) {
            throw new InvalidKeyException("Unwrapping failed", generalSecurityException);
        }
    }

    @Override
    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        if (this.mode_ != 3 && this.mode_ != 1) {
            throw new IllegalStateException("Cipher must be in WRAP_MODE");
        }
        try {
            byte[] byArray = Utils.encodeForWrapping(this.provider_, key);
            return this.engineDoFinal(byArray, 0, byArray.length);
        }
        catch (BadPaddingException badPaddingException) {
            throw new InvalidKeyException("Wrapping failed", badPaddingException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertInitialized() {
        Object object = this.lock_;
        synchronized (object) {
            if (this.key_ == null) {
                throw new IllegalStateException();
            }
        }
    }

    static {
        Loader.load();
    }

    private static enum Padding {
        PKCS1(1, "PKCS1Padding"),
        NO_PADDING(3, "NoPadding"),
        OAEP(4, "OAEP");

        private final int nativeVal;
        private final String paddingStr;

        private Padding(int n2, String string2) {
            this.nativeVal = n2;
            this.paddingStr = string2;
        }
    }

    static class OAEPSha1
    extends RsaCipher {
        OAEPSha1(AmazonCorrettoCryptoProvider amazonCorrettoCryptoProvider) {
            super(amazonCorrettoCryptoProvider, Padding.OAEP, RsaCipher.calculateOaepPaddingLen(OAEPParameterSpec.DEFAULT.getDigestAlgorithm()), false);
        }
    }

    static class OAEP
    extends RsaCipher {
        OAEP(AmazonCorrettoCryptoProvider amazonCorrettoCryptoProvider) {
            super(amazonCorrettoCryptoProvider, Padding.OAEP, RsaCipher.calculateOaepPaddingLen(OAEPParameterSpec.DEFAULT.getDigestAlgorithm()), true);
        }
    }

    static class Pkcs1
    extends RsaCipher {
        Pkcs1(AmazonCorrettoCryptoProvider amazonCorrettoCryptoProvider) {
            super(amazonCorrettoCryptoProvider, Padding.PKCS1, 11, false);
        }
    }

    static class NoPadding
    extends RsaCipher {
        NoPadding(AmazonCorrettoCryptoProvider amazonCorrettoCryptoProvider) {
            super(amazonCorrettoCryptoProvider, Padding.NO_PADDING, 0, false);
        }
    }
}

