/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.corretto.crypto.provider;

import com.amazon.corretto.crypto.provider.AmazonCorrettoCryptoProvider;
import com.amazon.corretto.crypto.provider.EvpKeyType;
import com.amazon.corretto.crypto.provider.Loader;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

final class Utils {
    static final int SHA1_CODE = 1;
    static final int SHA256_CODE = 2;
    static final int SHA384_CODE = 3;
    static final int SHA512_CODE = 4;
    private static final String PROPERTY_NATIVE_CONTEXT_RELEASE_STRATEGY = "nativeContextReleaseStrategy";
    static final byte[] EMPTY_ARRAY = new byte[0];
    private static final Logger LOG = Logger.getLogger("AmazonCorrettoCryptoProvider");
    private static final Map<String, Long> digestPtrByName = new ConcurrentHashMap<String, Long>();
    private static final Map<Long, Integer> digestLengthByPtr = new ConcurrentHashMap<Long, Integer>();
    private static final ByteBuffer ZERO_BYTE_BUF = ByteBuffer.allocate(8192).asReadOnlyBuffer();
    private static int JAVA_VERSION = 0;

    private Utils() {
    }

    static native long getNativeBufferOffset(ByteBuffer var0, ByteBuffer var1);

    static native long getEvpMdFromName(String var0);

    static native int getDigestLength(long var0);

    static int getDigestLength(String string) {
        return Utils.getDigestLength(Utils.getEvpMdFromName(string));
    }

    static String jceDigestNameToAwsLcName(String string) {
        if (string == null) {
            return null;
        }
        return string.replace("-", "").replace("/", "-").toUpperCase();
    }

    static long getMdPtr(String string) {
        if (string == null) {
            return 0L;
        }
        String string2 = Utils.jceDigestNameToAwsLcName(string);
        if (!string2.startsWith("SHA")) {
            throw new IllegalArgumentException("Unsupported digest algorithm: " + string);
        }
        long l = digestPtrByName.computeIfAbsent(string2, Utils::getEvpMdFromName);
        if (l == 0L) {
            throw new IllegalArgumentException("Unsupported digest algorith: " + string);
        }
        return l;
    }

    static int getMdLen(long l) {
        return digestLengthByPtr.computeIfAbsent(l, Utils::getDigestLength);
    }

    static boolean outputClobbersInput(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        boolean bl = byteBuffer.isDirect();
        boolean bl2 = byteBuffer2.isDirect();
        boolean bl3 = byteBuffer.hasArray();
        boolean bl4 = byteBuffer2.hasArray();
        if ((bl || bl2) && bl != bl2) {
            return false;
        }
        if (bl && bl2) {
            return Utils.getNativeBufferOffset(byteBuffer.slice(), byteBuffer2.slice()) <= Integer.MAX_VALUE;
        }
        if (!bl3 || !bl4) {
            return true;
        }
        int n = byteBuffer.arrayOffset() + byteBuffer.position();
        int n2 = byteBuffer2.arrayOffset() + byteBuffer2.position();
        return Utils.outputClobbersInput(byteBuffer.array(), n, byteBuffer.remaining(), byteBuffer2.array(), n2);
    }

    static boolean outputClobbersInput(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        if (byArray != byArray2) {
            return false;
        }
        if (n3 <= n) {
            return false;
        }
        int n4 = n + n2;
        return n3 < n4;
    }

    static byte[] encodeForWrapping(AmazonCorrettoCryptoProvider amazonCorrettoCryptoProvider, Key key) throws InvalidKeyException {
        try {
            byte[] byArray;
            if (key instanceof SecretKey) {
                byArray = key.getEncoded();
            } else if (key instanceof PublicKey) {
                KeyFactory keyFactory = Utils.getKeyFactory(amazonCorrettoCryptoProvider, key.getAlgorithm());
                byArray = keyFactory.getKeySpec(key, X509EncodedKeySpec.class).getEncoded();
            } else if (key instanceof PrivateKey) {
                KeyFactory keyFactory = Utils.getKeyFactory(amazonCorrettoCryptoProvider, key.getAlgorithm());
                byArray = keyFactory.getKeySpec(key, PKCS8EncodedKeySpec.class).getEncoded();
            } else {
                throw new InvalidKeyException("Key does not implement SecretKey, PublicKey, or PrivateKey");
            }
            if (byArray == null || byArray.length == 0) {
                throw new InvalidKeyException("Could not obtain encoded key");
            }
            return byArray;
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException generalSecurityException) {
            throw new InvalidKeyException("Wrapping failed", generalSecurityException);
        }
    }

    static byte[] encodeForWrapping(Key key) throws InvalidKeyException {
        return Utils.encodeForWrapping(AmazonCorrettoCryptoProvider.INSTANCE, key);
    }

    static Key buildUnwrappedKey(AmazonCorrettoCryptoProvider amazonCorrettoCryptoProvider, byte[] byArray, String string, int n) throws NoSuchAlgorithmException, InvalidKeySpecException {
        switch (n) {
            case 3: {
                return Utils.buildUnwrappedSecretKey(byArray, string);
            }
            case 1: {
                return Utils.buildUnwrappedPublicKey(amazonCorrettoCryptoProvider, byArray, string);
            }
            case 2: {
                return Utils.buildUnwrappedPrivateKey(amazonCorrettoCryptoProvider, byArray, string);
            }
        }
        throw new IllegalArgumentException("Unexpected key type: " + n);
    }

    static Key buildUnwrappedKey(byte[] byArray, String string, int n) throws NoSuchAlgorithmException, InvalidKeySpecException {
        return Utils.buildUnwrappedKey(AmazonCorrettoCryptoProvider.INSTANCE, byArray, string, n);
    }

    static SecretKey buildUnwrappedSecretKey(byte[] byArray, String string) {
        return new SecretKeySpec(byArray, string);
    }

    static PublicKey buildUnwrappedPublicKey(AmazonCorrettoCryptoProvider amazonCorrettoCryptoProvider, byte[] byArray, String string) throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory keyFactory = Utils.getKeyFactory(amazonCorrettoCryptoProvider, string);
        return keyFactory.generatePublic(new X509EncodedKeySpec(byArray));
    }

    static PrivateKey buildUnwrappedPrivateKey(AmazonCorrettoCryptoProvider amazonCorrettoCryptoProvider, byte[] byArray, String string) throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory keyFactory = Utils.getKeyFactory(amazonCorrettoCryptoProvider, string);
        return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(byArray));
    }

    static byte[] xor(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            throw new IllegalArgumentException("arrays must be the same length");
        }
        byte[] byArray3 = new byte[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            byArray3[i] = (byte)(byArray[i] ^ byArray2[i]);
        }
        return byArray3;
    }

    static byte[] decodeHex(String string) {
        if (string.length() % 2 != 0) {
            throw new IllegalArgumentException("Input length must be even");
        }
        byte[] byArray = new byte[string.length() / 2];
        for (int i = 0; i < string.length() / 2; ++i) {
            byArray[i] = (byte)Integer.parseInt(string.substring(2 * i, 2 * i + 2), 16);
        }
        return byArray;
    }

    private static void assertArrayEquals(String string, byte[] byArray, byte[] byArray2) {
        if (!Arrays.equals(byArray, byArray2)) {
            throw new AssertionError((Object)("Arrays do not match: " + string));
        }
    }

    public static void testMac(Mac mac, SecretKey secretKey, byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        int n;
        int n2;
        int n32;
        mac.init(secretKey);
        int[] nArray = new int[]{1, 3, 4, 7, 8, 16, 32, 48, 64, 128, 256};
        String string = mac.getAlgorithm();
        Utils.assertArrayEquals(string, byArray2, mac.doFinal(byArray));
        for (int i = 0; i < byArray.length; ++i) {
            mac.update(byArray[i]);
        }
        Utils.assertArrayEquals(string + "-Byte", byArray2, mac.doFinal());
        for (int n4 : nArray) {
            for (n32 = 0; n32 < byArray.length; n32 += n4) {
                n2 = n32 + n4 > byArray.length ? byArray.length - n32 : n4;
                mac.update(byArray, n32, n2);
            }
            Utils.assertArrayEquals(string + "-" + n4, byArray2, mac.doFinal());
        }
        mac.update(ByteBuffer.wrap(byArray));
        Utils.assertArrayEquals(string + "-ByteBuffer-Wrap", byArray2, mac.doFinal());
        for (int n4 : nArray) {
            for (n32 = 0; n32 < byArray.length; n32 += n4) {
                n2 = n32 + n4 > byArray.length ? byArray.length - n32 : n4;
                mac.update(ByteBuffer.wrap(byArray, n32, n2));
            }
            Utils.assertArrayEquals(string + "-ByteBuffer-Wrap-" + n4, byArray2, mac.doFinal());
        }
        mac.update(ByteBuffer.wrap(byArray).asReadOnlyBuffer());
        Utils.assertArrayEquals(string + "-ByteBuffer-Wrap-RO", byArray2, mac.doFinal());
        for (int n4 : nArray) {
            for (n32 = 0; n32 < byArray.length; n32 += n4) {
                n2 = n32 + n4 > byArray.length ? byArray.length - n32 : n4;
                mac.update(ByteBuffer.wrap(byArray, n32, n2).asReadOnlyBuffer());
            }
            Utils.assertArrayEquals(string + "-ByteBuffer-Wrap-RO-" + n4, byArray2, mac.doFinal());
        }
        Object object = ByteBuffer.allocate(byArray.length);
        ((ByteBuffer)object).put(byArray);
        ((ByteBuffer)object).flip();
        mac.update((ByteBuffer)object);
        Utils.assertArrayEquals(string + "-ByteBuffer-NonDirect", byArray2, mac.doFinal());
        for (int n32 : nArray) {
            object = ByteBuffer.allocate(n32);
            for (n2 = 0; n2 < byArray.length; n2 += n32) {
                n = n2 + n32 > byArray.length ? byArray.length - n2 : n32;
                ((ByteBuffer)object).clear();
                ((ByteBuffer)object).put(byArray, n2, n);
                ((ByteBuffer)object).flip();
                mac.update((ByteBuffer)object);
            }
            Utils.assertArrayEquals(string + "-ByteBuffer-NonDirect-" + n32, byArray2, mac.doFinal());
        }
        object = ByteBuffer.allocateDirect(byArray.length);
        ((ByteBuffer)object).put(byArray);
        ((ByteBuffer)object).flip();
        mac.update((ByteBuffer)object);
        Utils.assertArrayEquals(string + "-ByteBuffer-Direct", byArray2, mac.doFinal());
        for (int n32 : nArray) {
            object = ByteBuffer.allocateDirect(n32);
            for (n2 = 0; n2 < byArray.length; n2 += n32) {
                n = n2 + n32 > byArray.length ? byArray.length - n2 : n32;
                ((ByteBuffer)object).clear();
                ((ByteBuffer)object).put(byArray, n2, n);
                ((ByteBuffer)object).flip();
                mac.update((ByteBuffer)object);
            }
            Utils.assertArrayEquals(string + "-ByteBuffer-Direct-" + n32, byArray2, mac.doFinal());
        }
        object = ByteBuffer.allocateDirect(byArray.length);
        ((ByteBuffer)object).put(byArray);
        ((ByteBuffer)object).flip();
        mac.update(((ByteBuffer)object).asReadOnlyBuffer());
        Utils.assertArrayEquals(string + "-ByteBuffer-Direct", byArray2, mac.doFinal());
        for (int n32 : nArray) {
            object = ByteBuffer.allocateDirect(n32);
            for (n2 = 0; n2 < byArray.length; n2 += n32) {
                n = n2 + n32 > byArray.length ? byArray.length - n2 : n32;
                ((ByteBuffer)object).clear();
                ((ByteBuffer)object).put(byArray, n2, n);
                ((ByteBuffer)object).flip();
                mac.update(((ByteBuffer)object).asReadOnlyBuffer());
            }
            Utils.assertArrayEquals(string + "-ByteBuffer-Direct-" + n32, byArray2, mac.doFinal());
        }
    }

    public static void testDigest(MessageDigest messageDigest, byte[] byArray, byte[] byArray2) {
        int n;
        int n2;
        int n32;
        int[] nArray = new int[]{1, 3, 4, 7, 8, 16, 32, 48, 64, 128, 256};
        String string = messageDigest.getAlgorithm();
        Utils.assertArrayEquals(string, byArray2, messageDigest.digest(byArray));
        for (int i = 0; i < byArray.length; ++i) {
            messageDigest.update(byArray[i]);
        }
        Utils.assertArrayEquals(string + "-Byte", byArray2, messageDigest.digest());
        for (int n4 : nArray) {
            for (n32 = 0; n32 < byArray.length; n32 += n4) {
                n2 = n32 + n4 > byArray.length ? byArray.length - n32 : n4;
                messageDigest.update(byArray, n32, n2);
            }
            Utils.assertArrayEquals(string + "-" + n4, byArray2, messageDigest.digest());
        }
        messageDigest.update(ByteBuffer.wrap(byArray));
        Utils.assertArrayEquals(string + "-ByteBuffer-Wrap", byArray2, messageDigest.digest());
        for (int n4 : nArray) {
            for (n32 = 0; n32 < byArray.length; n32 += n4) {
                n2 = n32 + n4 > byArray.length ? byArray.length - n32 : n4;
                messageDigest.update(ByteBuffer.wrap(byArray, n32, n2));
            }
            Utils.assertArrayEquals(string + "-ByteBuffer-Wrap-" + n4, byArray2, messageDigest.digest());
        }
        messageDigest.update(ByteBuffer.wrap(byArray).asReadOnlyBuffer());
        Utils.assertArrayEquals(string + "-ByteBuffer-Wrap-RO", byArray2, messageDigest.digest());
        for (int n4 : nArray) {
            for (n32 = 0; n32 < byArray.length; n32 += n4) {
                n2 = n32 + n4 > byArray.length ? byArray.length - n32 : n4;
                messageDigest.update(ByteBuffer.wrap(byArray, n32, n2).asReadOnlyBuffer());
            }
            Utils.assertArrayEquals(string + "-ByteBuffer-Wrap-RO-" + n4, byArray2, messageDigest.digest());
        }
        Object object = ByteBuffer.allocate(byArray.length);
        ((ByteBuffer)object).put(byArray);
        ((ByteBuffer)object).flip();
        messageDigest.update((ByteBuffer)object);
        Utils.assertArrayEquals(string + "-ByteBuffer-NonDirect", byArray2, messageDigest.digest());
        for (int n32 : nArray) {
            object = ByteBuffer.allocate(n32);
            for (n2 = 0; n2 < byArray.length; n2 += n32) {
                n = n2 + n32 > byArray.length ? byArray.length - n2 : n32;
                ((ByteBuffer)object).clear();
                ((ByteBuffer)object).put(byArray, n2, n);
                ((ByteBuffer)object).flip();
                messageDigest.update((ByteBuffer)object);
            }
            Utils.assertArrayEquals(string + "-ByteBuffer-NonDirect-" + n32, byArray2, messageDigest.digest());
        }
        object = ByteBuffer.allocateDirect(byArray.length);
        ((ByteBuffer)object).put(byArray);
        ((ByteBuffer)object).flip();
        messageDigest.update((ByteBuffer)object);
        Utils.assertArrayEquals(string + "-ByteBuffer-Direct", byArray2, messageDigest.digest());
        for (int n32 : nArray) {
            object = ByteBuffer.allocateDirect(n32);
            for (n2 = 0; n2 < byArray.length; n2 += n32) {
                n = n2 + n32 > byArray.length ? byArray.length - n2 : n32;
                ((ByteBuffer)object).clear();
                ((ByteBuffer)object).put(byArray, n2, n);
                ((ByteBuffer)object).flip();
                messageDigest.update((ByteBuffer)object);
            }
            Utils.assertArrayEquals(string + "-ByteBuffer-Direct-" + n32, byArray2, messageDigest.digest());
        }
        object = ByteBuffer.allocateDirect(byArray.length);
        ((ByteBuffer)object).put(byArray);
        ((ByteBuffer)object).flip();
        messageDigest.update(((ByteBuffer)object).asReadOnlyBuffer());
        Utils.assertArrayEquals(string + "-ByteBuffer-Direct", byArray2, messageDigest.digest());
        for (int n32 : nArray) {
            object = ByteBuffer.allocateDirect(n32);
            for (n2 = 0; n2 < byArray.length; n2 += n32) {
                n = n2 + n32 > byArray.length ? byArray.length - n2 : n32;
                ((ByteBuffer)object).clear();
                ((ByteBuffer)object).put(byArray, n2, n);
                ((ByteBuffer)object).flip();
                messageDigest.update(((ByteBuffer)object).asReadOnlyBuffer());
            }
            Utils.assertArrayEquals(string + "-ByteBuffer-Direct-" + n32, byArray2, messageDigest.digest());
        }
    }

    static void zeroByteBuffer(ByteBuffer byteBuffer) {
        byteBuffer = byteBuffer.duplicate();
        byteBuffer.clear();
        while (byteBuffer.hasRemaining()) {
            ByteBuffer byteBuffer2 = ZERO_BYTE_BUF.duplicate();
            byteBuffer2.limit(Math.min(byteBuffer2.remaining(), byteBuffer.remaining()));
            byteBuffer.put(byteBuffer2);
        }
    }

    private static KeyFactory getKeyFactory(AmazonCorrettoCryptoProvider amazonCorrettoCryptoProvider, String string) throws NoSuchAlgorithmException {
        EvpKeyType evpKeyType = EvpKeyType.fromJceName(string);
        if (evpKeyType != null) {
            return amazonCorrettoCryptoProvider.getKeyFactory(evpKeyType);
        }
        return KeyFactory.getInstance(string);
    }

    static <E extends Enum<E>> void optionsFromProperty(Class<E> clazz, EnumSet<E> enumSet, String string) {
        String[] stringArray;
        String string2 = Loader.getProperty(string, "");
        if (string2.equalsIgnoreCase("help")) {
            System.err.format("Valid values for %s%s are: %s or ALL", "com.amazon.corretto.crypto.provider.", string, EnumSet.allOf(clazz));
        }
        for (String string3 : stringArray = string2.split(",")) {
            if (string3.equalsIgnoreCase("all")) {
                enumSet.addAll(EnumSet.allOf(clazz));
                break;
            }
            try {
                E e = Enum.valueOf(clazz, string3.toUpperCase());
                if (e == null) continue;
                enumSet.add(e);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static int getJavaVersion() {
        if (JAVA_VERSION > 0) {
            return JAVA_VERSION;
        }
        String string = AccessController.doPrivileged(() -> System.getProperty("java.specification.version"));
        try {
            String[] stringArray = string.split("\\.");
            JAVA_VERSION = stringArray[0].equals("1") ? Integer.parseInt(stringArray[1]) : Integer.parseInt(stringArray[0]);
        }
        catch (RuntimeException runtimeException) {
            LOG.warning("Unable to parse version string: " + string);
            JAVA_VERSION = 8;
        }
        return JAVA_VERSION;
    }

    static boolean getBooleanProperty(String string, boolean bl) {
        String string2 = bl ? "true" : "false";
        String string3 = Loader.getProperty(string, string2).toLowerCase();
        if (!string3.equals("true") && !string3.equals("false")) {
            LOG.warning(String.format("Valid values for %s are false and true, with %s as default", string, string2));
            return bl;
        }
        return Boolean.parseBoolean(string3);
    }

    static void checkArrayLimits(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            throw new IllegalArgumentException("Bad argument: bytes cannot be null.");
        }
        if (n < 0 || n2 < 0) {
            throw new ArrayIndexOutOfBoundsException("Negative offset or length");
        }
        if ((long)n + (long)n2 > (long)byArray.length) {
            throw new ArrayIndexOutOfBoundsException("Requested range is outside of buffer limits" + byArray.length + ":" + n + ":" + n2);
        }
    }

    static <T> T requireNonNull(T t, String string) {
        if (t == null) {
            throw new IllegalArgumentException(string);
        }
        return t;
    }

    static String requireNonNullString(String string, String string2) {
        return Utils.requireNonNull(string, string2);
    }

    private static NativeContextReleaseStrategy getNativeContextReleaseStrategyProperty(String string) {
        String string2 = Loader.getProperty(string, "HYBRID").toUpperCase();
        if (string2.equals("LAZY")) {
            return NativeContextReleaseStrategy.LAZY;
        }
        if (string2.equals("EAGER")) {
            return NativeContextReleaseStrategy.EAGER;
        }
        if (!string2.equals("HYBRID")) {
            LOG.warning(String.format("Valid values for %s are HYBRID, LAZY, EAGER, with HYBRID as default", string));
        }
        return NativeContextReleaseStrategy.HYBRID;
    }

    static NativeContextReleaseStrategy getNativeContextReleaseStrategyProperty() {
        return Utils.getNativeContextReleaseStrategyProperty(PROPERTY_NATIVE_CONTEXT_RELEASE_STRATEGY);
    }

    static native void releaseEvpCipherCtx(long var0);

    public static byte[] checkAesKey(Key key) throws InvalidKeyException {
        if (key == null) {
            throw new InvalidKeyException("Key can't be null");
        }
        if (!(key instanceof SecretKey)) {
            throw new InvalidKeyException("Need a SecretKey");
        }
        if (!"RAW".equalsIgnoreCase(key.getFormat())) {
            throw new InvalidKeyException("Need a raw format key");
        }
        if (!"AES".equalsIgnoreCase(key.getAlgorithm())) {
            throw new InvalidKeyException("Expected an AES key");
        }
        byte[] byArray = key.getEncoded();
        if (byArray == null) {
            throw new InvalidKeyException("Key doesn't support encoding");
        }
        if (byArray.length != 16 && byArray.length != 24 && byArray.length != 32) {
            throw new InvalidKeyException("Bad key length of " + byArray.length * 8 + " bits; expected 128, 192, or 256 bits");
        }
        return byArray;
    }

    static enum NativeContextReleaseStrategy {
        HYBRID,
        LAZY,
        EAGER;

    }
}

